/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.scr.elm;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import net.fexcraft.lib.scr.ScriptElm;
import net.fexcraft.lib.scr.ScriptElmType;

public class MapElm
implements ScriptElm {
    private final Map<String, ScriptElm> value;

    public MapElm(Map<String, ScriptElm> type) {
        this.value = type;
    }

    public MapElm(String type) {
        switch (type) {
            case "tree": {
                this.value = new TreeMap<String, ScriptElm>();
                break;
            }
            case "linked": {
                this.value = new LinkedHashMap<String, ScriptElm>();
                break;
            }
            default: {
                this.value = new HashMap<String, ScriptElm>();
            }
        }
    }

    public MapElm() {
        this("");
    }

    @Override
    public String scr_str() {
        return this.value.toString();
    }

    @Override
    public int scr_int() {
        return this.value.size();
    }

    @Override
    public float scr_flt() {
        return this.value.size();
    }

    @Override
    public boolean scr_bln() {
        return this.value.size() > 1;
    }

    @Override
    public ScriptElmType scr_type() {
        return ScriptElmType.MAP;
    }

    @Override
    public ScriptElm scr_get(String sub) {
        ScriptElm elm = this.value.get(sub);
        return elm == null ? NULL : elm;
    }

    @Override
    public void scr_set(String sub, ScriptElm val, boolean ov) {
        ScriptElm elm = this.value.get(sub);
        if (elm == null || ov && elm.replaceable()) {
            this.value.put(sub, val);
        } else {
            elm.scr_set(val);
        }
    }

    @Override
    public ScriptElm exec(String str, ScriptElm ... args) {
        return NULL;
    }
}

