/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fexcraft.lib.script.ScrCond;
import net.fexcraft.lib.script.ScrElm;
import net.fexcraft.lib.script.ScrExpr;
import net.fexcraft.lib.script.ScrTask;
import net.fexcraft.lib.script.Script;
import net.fexcraft.lib.script.Two;

public class ScrBlock {
    public final HashMap<String, ScrElm> locals = new HashMap();
    public final ArrayList<ScrExpr> exprs = new ArrayList();
    public final ArrayList<ScrBlock> subs = new ArrayList();
    public final ArrayList<ScrTask> tasks = new ArrayList();
    private ScrCond condition;
    public Script script;
    public final ScrBlock root;
    public final String name;
    public final Type type;

    public ScrBlock(Type type, Script script, ScrBlock root, String name) {
        this.root = root;
        this.script = script;
        this.name = name == null ? type.name().toLowerCase() : name;
        this.type = type;
        if (root != null) {
            root.subs.add(this);
        }
    }

    public ScrBlock action() {
        if (this.type == Type.ACTION) {
            return this;
        }
        if (this.root != null) {
            return this.root.action();
        }
        return null;
    }

    public ScrBlock rootnn() {
        return this.root == null ? this : this.root;
    }

    public void cond(ScrCond cond) {
        this.condition = cond;
    }

    public ScrElm getElm(String elm, ScrBlock sub) {
        if (this.locals.containsKey(elm)) {
            return this.locals.get(elm);
        }
        return this.root == null ? ScrElm.NULL : this.root.getElm(elm, this);
    }

    public String print(int depth) {
        String tab = ScrBlock.getDepthTab(depth);
        String tab1 = ScrBlock.getDepthTab(depth + 1);
        String cond = this.condition == null ? "" : this.condition.print();
        Object ret = tab + this.type.name() + " " + this.name + "(" + cond + "){\n";
        ret = this.preprint((String)ret, tab, tab1, depth);
        for (Map.Entry<String, ScrElm> entry : this.locals.entrySet()) {
            ret = (String)ret + tab1 + String.valueOf((Object)entry.getValue().scr_type()) + " " + entry.getKey() + " = " + entry.getValue().scr_print() + "\n";
        }
        for (ScrTask task : this.tasks) {
            ret = (String)ret + task.print(depth + 1);
        }
        ret = this.postprint((String)ret, tab, tab1, depth);
        ret = (String)ret + tab + "}\n";
        return ret;
    }

    public String print() {
        return this.print(0);
    }

    protected String preprint(String ret, String tab, String tab1, int depth) {
        return ret;
    }

    protected String postprint(String ret, String tab, String tab1, int depth) {
        return ret;
    }

    protected static String getDepthTab(int depth) {
        Object ret = "";
        for (int i = 0; i < depth; ++i) {
            ret = (String)ret + "   ";
        }
        return ret;
    }

    public ScrTask lastTask() {
        return this.tasks.size() == 0 ? null : this.tasks.get(this.tasks.size() - 1);
    }

    public Two<ScrElm, Boolean> process() {
        block0: for (ScrTask task : this.tasks) {
            if (task.type.ifelse()) {
                for (ScrBlock block : task.blocks) {
                    if (block.condition != null && !block.condition.isMet()) continue;
                    Two<ScrElm, Boolean> two = block.process();
                    if (!((Boolean)two.second).booleanValue()) continue block0;
                    return two;
                }
                continue;
            }
            if (task.expr.isReturn()) {
                return new Two<ScrElm, Boolean>(task.expr.process(this, null, ScrElm.NULL), true);
            }
            task.expr.process(this, null, ScrElm.NULL);
        }
        return new Two<ScrElm, Boolean>(ScrElm.NULL, false);
    }

    public Script getScript() {
        ScrBlock block = this;
        while (block.root != null) {
            block = block.root;
        }
        return (Script)block;
    }

    public static enum Type {
        SCRIPT,
        ACTION,
        IFELSE;


        boolean is(Type o) {
            return this == o;
        }

        boolean is(Type ... o) {
            for (Type type : o) {
                if (this != type) continue;
                return true;
            }
            return false;
        }
    }
}

