/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.script;

import java.lang.constant.Constable;
import java.util.ArrayList;
import net.fexcraft.lib.common.utils.Print;
import net.fexcraft.lib.script.ScrAction;
import net.fexcraft.lib.script.ScrBlock;
import net.fexcraft.lib.script.ScrElmType;
import net.fexcraft.lib.script.ScrExpr;
import net.fexcraft.lib.script.Two;
import net.fexcraft.lib.script.elm.BoolElm;
import net.fexcraft.lib.script.elm.FltElm;
import net.fexcraft.lib.script.elm.IntElm;
import net.fexcraft.lib.script.elm.ListElm;
import net.fexcraft.lib.script.elm.NullElm;
import net.fexcraft.lib.script.elm.ObjElm;
import net.fexcraft.lib.script.elm.RefElm;
import net.fexcraft.lib.script.elm.StrElm;

public interface ScrElm {
    public static final NullElm NULL = new NullElm();
    public static final BoolElm TRUE = new BoolElm.Final(true);
    public static final BoolElm FALSE = new BoolElm.Final(false);

    default public String scr_str() {
        return this.getClass().getName();
    }

    default public int scr_int() {
        return 0;
    }

    default public float scr_flt() {
        return 0.0f;
    }

    default public boolean scr_bln() {
        return false;
    }

    default public ScrElmType scr_type() {
        return ScrElmType.OBJ;
    }

    default public void scr_set(String val) {
    }

    default public void scr_set(int val) {
    }

    default public void scr_set(float val) {
    }

    default public void scr_set(boolean val) {
    }

    default public void scr_set(ScrElm nex) {
    }

    default public String scr_print() {
        return this.scr_type() == ScrElmType.STRING ? "\"" + this.scr_str() + "\"" : this.scr_str();
    }

    default public ScrElm scr_get(ScrBlock block, String target) {
        return NULL;
    }

    default public ScrElm scr_exec(ScrBlock block, String act, ArrayList<ScrElm> args) {
        if (block.script.blocks.containsKey(act)) {
            return ((ScrAction)block.script.blocks.get(act)).process(args);
        }
        switch (act) {
            case "print": {
                if (args == null) break;
                for (ScrElm elm : args) {
                    if (elm.scr_type().reference()) {
                        ScrElm e = ((RefElm)elm).getElm(block);
                        Object[] objectArray = new Object[1];
                        objectArray[0] = ((RefElm)elm).negative() ? (e.scr_type().number() ? (Constable)Float.valueOf(-elm.scr_flt()) : (Constable)Boolean.valueOf(!elm.scr_bln())) : e.scr_print();
                        Print.console(objectArray);
                        continue;
                    }
                    Print.console(elm.scr_print());
                }
                break;
            }
        }
        return NULL;
    }

    default public boolean overrides() {
        return false;
    }

    default public boolean scr_bool(ScrBlock block, ScrExpr prev, ScrElm pelm) {
        return this.scr_bln();
    }

    public static ScrElm wrap(Object obj) {
        if (obj instanceof String) {
            return new StrElm(obj.toString());
        }
        if (obj instanceof Integer) {
            return new IntElm((Integer)obj);
        }
        if (obj instanceof Float) {
            return new FltElm(((Float)obj).floatValue());
        }
        if (obj instanceof Boolean) {
            return new BoolElm((Boolean)obj);
        }
        return NULL;
    }

    public static Two<String, ScrElm> parse(String line, ScrElmType type) {
        if (!(line = line.substring(4)).contains("=")) {
            return new Two<String, ScrElm>(line.trim(), ScrElm.from(type));
        }
        String name = line.substring(0, line.indexOf("=")).trim();
        line = line.substring(line.indexOf("=") + 1).trim();
        ScrElm elm = null;
        switch (type) {
            case BOOLEAN: {
                elm = new BoolElm(Boolean.parseBoolean(line));
                break;
            }
            case FLOAT: {
                elm = new FltElm(Float.parseFloat(line));
                break;
            }
            case INTEGER: {
                elm = new IntElm(Integer.parseInt(line));
                break;
            }
            case STRING: {
                int s = 0;
                int e = line.length();
                if (line.startsWith("\"")) {
                    s = 1;
                }
                if (line.endsWith("\"")) {
                    --e;
                }
                elm = new StrElm(line.substring(s, e));
                break;
            }
            case LIST: {
                elm = new ListElm();
                break;
            }
            case OBJ: {
                elm = new ObjElm();
                break;
            }
            default: {
                elm = NullElm.NULL;
            }
        }
        return new Two<String, ScrElm>(name, elm);
    }

    public static ScrElm from(ScrElmType from) {
        switch (from) {
            case BOOLEAN: {
                return new BoolElm(false);
            }
            case FLOAT: {
                return new FltElm(0.0f);
            }
            case INTEGER: {
                return new IntElm(0);
            }
            case LIST: {
                return new ListElm();
            }
            case OBJ: {
                return new ObjElm();
            }
            case STRING: {
                return new StrElm("");
            }
        }
        return NullElm.NULL;
    }

    public static ScrElm asBool(boolean bool) {
        return bool ? TRUE : FALSE;
    }
}

