/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.script;

import java.util.ArrayList;
import net.fexcraft.lib.script.ScrBlock;
import net.fexcraft.lib.script.ScrElm;
import net.fexcraft.lib.script.ScrOper;
import net.fexcraft.lib.script.Script;
import net.fexcraft.lib.script.elm.BoolElm;
import net.fexcraft.lib.script.elm.FltElm;
import net.fexcraft.lib.script.elm.IntElm;
import net.fexcraft.lib.script.elm.RefElm;
import net.fexcraft.lib.script.elm.StrElm;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class ScrExpr {
    public String target;
    public ScrExpr next;

    public abstract ScrElm process(ScrBlock var1, ScrExpr var2, ScrElm var3);

    public ScrExpr next(ScrExpr expr) {
        this.next = expr;
        return this;
    }

    public abstract String print();

    public boolean isReturn() {
        return false;
    }

    public static class Value
    extends ScrExpr {
        private ScrElm elm;

        public Value() {
            this.elm = ScrElm.NULL;
        }

        public Value(String tar, boolean number, boolean bool, boolean str) {
            this.elm = number ? (tar.contains(".") ? new FltElm(Float.parseFloat(tar)) : new IntElm(Integer.parseInt(tar))) : (bool ? new BoolElm(tar.toLowerCase().equals("true")) : (str ? new StrElm(tar.substring(1)) : ScrElm.NULL));
        }

        @Override
        public ScrElm process(ScrBlock block, ScrExpr prev, ScrElm pelm) {
            return this.next == null ? this.elm : this.next.process(block, this, this.elm);
        }

        @Override
        public String print() {
            return this.elm.scr_print() + (this.next == null ? "" : this.next.print());
        }
    }

    public static class Compare
    extends ScrExpr {
        private ScrOper oper;

        public Compare(ScrOper oper) {
            this.oper = oper == null ? ScrOper.SET : oper;
        }

        @Override
        public ScrElm process(ScrBlock block, ScrExpr prev, ScrElm pelm) {
            ScrElm next = this.next.process(block, this, pelm);
            switch (this.oper) {
                case GRT: {
                    return pelm.scr_flt() > next.scr_flt() ? ScrElm.TRUE : ScrElm.FALSE;
                }
                case GRT_EQL: {
                    return pelm.scr_flt() >= next.scr_flt() ? ScrElm.TRUE : ScrElm.FALSE;
                }
                case LES: {
                    return pelm.scr_flt() < next.scr_flt() ? ScrElm.TRUE : ScrElm.FALSE;
                }
                case LES_EQL: {
                    return pelm.scr_flt() <= next.scr_flt() ? ScrElm.TRUE : ScrElm.FALSE;
                }
                case NOT_EQL: {
                    if (pelm.scr_type().number()) {
                        return pelm.scr_flt() != next.scr_flt() ? ScrElm.TRUE : ScrElm.FALSE;
                    }
                    if (pelm.scr_type().bool()) {
                        return pelm.scr_bool(block, prev, pelm) != next.scr_bool(block, prev, pelm) ? ScrElm.TRUE : ScrElm.FALSE;
                    }
                    return !pelm.equals(next) ? ScrElm.TRUE : ScrElm.FALSE;
                }
                case EQL: {
                    if (pelm.scr_type().number()) {
                        return pelm.scr_flt() == next.scr_flt() ? ScrElm.TRUE : ScrElm.FALSE;
                    }
                    if (pelm.scr_type().bool()) {
                        return pelm.scr_bool(block, prev, pelm) == next.scr_bool(block, prev, pelm) ? ScrElm.TRUE : ScrElm.FALSE;
                    }
                    return pelm.equals(next) ? ScrElm.TRUE : ScrElm.FALSE;
                }
                case AND: {
                    return ScrElm.asBool(pelm.scr_bool(block, prev, pelm) && next.scr_bool(block, prev, pelm));
                }
                case OR: {
                    return ScrElm.asBool(pelm.scr_bool(block, prev, pelm) || next.scr_bool(block, prev, pelm));
                }
            }
            return ScrElm.FALSE;
        }

        @Override
        public String print() {
            return " " + this.oper.sign + " " + (this.next == null ? "" : this.next.print());
        }
    }

    public static class Math
    extends ScrExpr {
        private ScrOper oper;

        public Math(ScrOper oper) {
            this.oper = oper;
        }

        @Override
        public ScrElm process(ScrBlock block, ScrExpr prev, ScrElm pelm) {
            ScrElm nex = this.next.process(block, this, ScrElm.NULL);
            if ((pelm.scr_type().string() || nex.scr_type().string()) && this.oper == ScrOper.ADD) {
                return new StrElm(pelm.scr_str() + nex.scr_str());
            }
            boolean deci = pelm.scr_type().decimal() || nex.scr_type().decimal();
            ScrElm res = pelm.scr_type().integer() ? new IntElm(0) : new FltElm(0.0f);
            switch (this.oper) {
                case ADD: {
                    if (deci) {
                        res.scr_set(pelm.scr_flt() + nex.scr_flt());
                        break;
                    }
                    res.scr_set(pelm.scr_int() + nex.scr_int());
                    break;
                }
                case SUB: {
                    if (deci) {
                        res.scr_set(pelm.scr_flt() - nex.scr_flt());
                        break;
                    }
                    res.scr_set(pelm.scr_int() - nex.scr_int());
                    break;
                }
                case DIV: {
                    if (deci) {
                        res.scr_set(pelm.scr_flt() / nex.scr_flt());
                        break;
                    }
                    res.scr_set(pelm.scr_int() / nex.scr_int());
                    break;
                }
                case MUL: {
                    if (deci) {
                        res.scr_set(pelm.scr_flt() * nex.scr_flt());
                        break;
                    }
                    res.scr_set(pelm.scr_int() * nex.scr_int());
                    break;
                }
                case MOD: {
                    if (deci) {
                        res.scr_set(pelm.scr_flt() % nex.scr_flt());
                        break;
                    }
                    res.scr_set(pelm.scr_int() % nex.scr_int());
                    break;
                }
            }
            return res;
        }

        @Override
        public String print() {
            return " " + this.oper.sign + " " + (this.next == null ? "" : this.next.print());
        }
    }

    public static class Set
    extends ScrExpr {
        private ScrOper oper;

        public Set(ScrOper oper) {
            this.oper = oper == null ? ScrOper.SET : oper;
        }

        @Override
        public ScrElm process(ScrBlock block, ScrExpr prev, ScrElm pelm) {
            if (!pelm.scr_type().primitive() && this.oper != ScrOper.SET) {
                return ScrElm.NULL;
            }
            ScrElm nex = this.next.process(block, this, ScrElm.NULL);
            switch (this.oper) {
                case SET: {
                    if (pelm.scr_type().decimal()) {
                        pelm.scr_set(nex.scr_flt());
                        break;
                    }
                    if (pelm.scr_type().integer()) {
                        pelm.scr_set(nex.scr_int());
                        break;
                    }
                    if (pelm.scr_type().bool()) {
                        pelm.scr_set(nex.scr_bln());
                        break;
                    }
                    if (pelm.scr_type().string()) {
                        pelm.scr_set(nex.scr_str());
                        break;
                    }
                    pelm.scr_set(nex);
                    break;
                }
                case ADD: {
                    if (pelm.scr_type().decimal()) {
                        pelm.scr_set(pelm.scr_flt() + nex.scr_flt());
                        break;
                    }
                    pelm.scr_set(pelm.scr_int() + nex.scr_int());
                    break;
                }
                case SUB: {
                    if (pelm.scr_type().decimal()) {
                        pelm.scr_set(pelm.scr_flt() - nex.scr_flt());
                        break;
                    }
                    pelm.scr_set(pelm.scr_int() - nex.scr_int());
                    break;
                }
                case DIV: {
                    if (pelm.scr_type().decimal()) {
                        pelm.scr_set(pelm.scr_flt() / nex.scr_flt());
                        break;
                    }
                    pelm.scr_set(pelm.scr_int() / nex.scr_int());
                    break;
                }
                case MUL: {
                    if (pelm.scr_type().decimal()) {
                        pelm.scr_set(pelm.scr_flt() * nex.scr_flt());
                        break;
                    }
                    pelm.scr_set(pelm.scr_int() * nex.scr_int());
                    break;
                }
                case MOD: {
                    if (pelm.scr_type().decimal()) {
                        pelm.scr_set(pelm.scr_flt() % nex.scr_flt());
                        break;
                    }
                    pelm.scr_set(pelm.scr_int() % nex.scr_int());
                    break;
                }
            }
            return pelm;
        }

        @Override
        public String print() {
            return " " + (this.oper == ScrOper.SET ? "" : this.oper.sign) + "= " + (this.next == null ? "" : this.next.print());
        }
    }

    public static class Exec
    extends ScrExpr {
        private ArrayList<ScrElm> args;

        public Exec(String tar) {
            this.target = tar;
        }

        public Exec(String tar, String[] split) {
            this(tar);
            this.args = new ArrayList();
            for (String str : split) {
                boolean neg = false;
                if ((str = str.trim()).startsWith("!") || str.startsWith("-")) {
                    neg = true;
                    str = str.substring(1);
                }
                if (str.startsWith("\"")) {
                    this.args.add(new StrElm(str.substring(1, str.endsWith("\"") ? str.length() - 1 : str.length())));
                    continue;
                }
                if (NumberUtils.isParsable((String)str)) {
                    ScrElm elm = null;
                    elm = str.contains(".") ? new FltElm(neg ? -Float.parseFloat(str) : Float.parseFloat(str)) : new IntElm(neg ? -Integer.parseInt(str) : Integer.parseInt(str));
                    this.args.add(elm);
                    continue;
                }
                if (Script.isb(str)) {
                    boolean bool = str.toLowerCase().equals("true");
                    this.args.add(new BoolElm(neg ? !bool : bool));
                    continue;
                }
                this.args.add(new RefElm(str, neg));
            }
        }

        @Override
        public ScrElm process(ScrBlock block, ScrExpr prev, ScrElm pelm) {
            if (this.next == null) {
                return pelm == ScrElm.NULL ? ScrElm.NULL.scr_exec(block, this.target, this.args) : pelm.scr_exec(block, this.target, this.args);
            }
            return this.next.process(block, this, pelm == ScrElm.NULL ? ScrElm.NULL.scr_exec(block, this.target, this.args) : pelm.scr_exec(block, this.target, this.args));
        }

        @Override
        public String print() {
            String dot = this.next != null && (this.next instanceof Reference || this.next instanceof Exec) ? "." : "";
            Object arg = "";
            if (this.args != null) {
                for (int i = 0; i < this.args.size(); ++i) {
                    arg = (String)arg + this.args.get(i).scr_print();
                    if (i >= this.args.size() - 1) continue;
                    arg = (String)arg + ", ";
                }
            }
            return this.target + "(" + (String)arg + ")" + dot + (this.next == null ? "" : this.next.print());
        }
    }

    public static class Negate
    extends ScrExpr {
        @Override
        public ScrElm process(ScrBlock block, ScrExpr prev, ScrElm pelm) {
            ScrElm elm = this.next.process(block, this, ScrElm.NULL);
            return elm.scr_type().decimal() ? new FltElm(-elm.scr_flt()) : new IntElm(-elm.scr_int());
        }

        @Override
        public String print() {
            return "-" + (this.next == null ? "" : this.next.print());
        }
    }

    public static class Not
    extends ScrExpr {
        @Override
        public ScrElm process(ScrBlock block, ScrExpr prev, ScrElm pelm) {
            return new BoolElm(!this.next.process(block, this, ScrElm.NULL).scr_bln());
        }

        @Override
        public String print() {
            return "!" + (this.next == null ? "" : this.next.print());
        }
    }

    public static class Reference
    extends ScrExpr {
        public Reference(String tar) {
            this.target = tar;
        }

        @Override
        public ScrElm process(ScrBlock block, ScrExpr prev, ScrElm pelm) {
            ScrElm elm = block.getElm(this.target, null);
            if (this.next == null) {
                return elm;
            }
            if (this.next instanceof Reference) {
                ScrExpr nex = this.next;
                while (nex instanceof Reference) {
                    elm = elm.scr_get(block, nex.target);
                    nex = nex.next;
                }
                return nex == null ? elm : nex.process(block, this, elm);
            }
            return this.next.process(block, this, elm);
        }

        @Override
        public String print() {
            String dot = this.next != null && (this.next instanceof Reference || this.next instanceof Exec) ? "." : "";
            return "{" + this.target + "}" + dot + (this.next == null ? "" : this.next.print());
        }
    }

    public static class Return
    extends ScrExpr {
        @Override
        public ScrElm process(ScrBlock block, ScrExpr prev, ScrElm pelm) {
            return this.next == null ? ScrElm.NULL : this.next.process(block, this, ScrElm.NULL);
        }

        @Override
        public String print() {
            return "return " + (this.next == null ? "" : this.next.print());
        }

        @Override
        public boolean isReturn() {
            return true;
        }
    }
}

