/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.script;

import java.util.ArrayList;
import net.fexcraft.lib.script.ScrBlock;
import net.fexcraft.lib.script.ScrExpr;

public class ScrTask {
    protected final Type type;
    protected ArrayList<ScrBlock> blocks = new ArrayList();
    protected ScrExpr expr;
    protected boolean closed;

    public ScrTask(Type type, ScrBlock block) {
        this.type = type;
        this.blocks.add(block);
    }

    public ScrTask(Type type, ScrExpr expr) {
        this.type = type;
        this.expr = expr;
    }

    public void add(ScrBlock block) {
        this.blocks.add(block);
    }

    public void close(ScrBlock block) {
        this.blocks.add(block);
        this.closed = true;
    }

    public String print(int depth) {
        if (this.type == Type.LINE) {
            return ScrBlock.getDepthTab(depth) + this.expr.print() + "\n";
        }
        Object ret = "";
        for (ScrBlock block : this.blocks) {
            ret = (String)ret + block.print(depth);
        }
        return ret;
    }

    public static enum Type {
        IFELSE,
        LINE;


        boolean ifelse() {
            return this == IFELSE;
        }
    }
}

