/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.script;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.fexcraft.lib.common.utils.Print;
import net.fexcraft.lib.script.ScrAction;
import net.fexcraft.lib.script.ScrBlock;
import net.fexcraft.lib.script.ScrCond;
import net.fexcraft.lib.script.ScrElm;
import net.fexcraft.lib.script.ScrElmType;
import net.fexcraft.lib.script.ScrExpr;
import net.fexcraft.lib.script.ScrExprType;
import net.fexcraft.lib.script.ScrOper;
import net.fexcraft.lib.script.ScrTask;
import net.fexcraft.lib.script.Two;

public class Script
extends ScrBlock {
    public static final ConcurrentHashMap<String, ConcurrentHashMap<String, ScrElm>> globals = new ConcurrentHashMap();
    public final HashMap<String, String> attrmap = new HashMap();
    public final HashMap<String, ScrBlock> blocks = new HashMap();
    public final String id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script(InputStream stream, String scriptid) {
        super(ScrBlock.Type.SCRIPT, null, null, scriptid);
        this.script = this;
        Scanner scanner = new Scanner(stream);
        this.id = scriptid;
        String line = null;
        ScrBlock block = this;
        boolean ignore = false;
        try {
            while (scanner.hasNextLine()) {
                line = scanner.nextLine().trim();
                if (ignore) {
                    if (!line.endsWith("*/")) continue;
                    ignore = false;
                    continue;
                }
                if (line.startsWith("//")) continue;
                if (line.startsWith("/*")) {
                    ignore = true;
                    continue;
                }
                if (line.startsWith("}") || line.startsWith(";;")) {
                    block = block.rootnn();
                    continue;
                }
                if (this.checkForDataTypes(block, line, block == this && line.startsWith("global"))) continue;
                if (line.startsWith("use ") && this.blocks.isEmpty()) {
                    if (!(line = line.substring(4)).startsWith("attr ")) continue;
                    line = line.substring(5);
                    int idx = line.indexOf("->");
                    String attr = line.substring(0, idx).trim();
                    String nick = line.substring(idx + 2).trim();
                    this.attrmap.put(nick, attr);
                    continue;
                }
                if (block == this && line.startsWith("act ")) {
                    int idx0 = line.indexOf("(");
                    String name = line.substring(4, idx0);
                    String[] args = line.substring(idx0 + 1, line.indexOf(")")).split(",");
                    ScrAction act = new ScrAction(this, name);
                    for (String str : args) {
                        if (str.length() < 3) continue;
                        String[] s = str.split(" ");
                        act.locals.put(s[1], ScrElm.from(ScrElmType.from(s[0])));
                        act.parameters.add(s[1]);
                    }
                    block = act;
                    this.blocks.put(name, block);
                    continue;
                }
                if (block == this) continue;
                if (line.startsWith("if")) {
                    ScrBlock old = block;
                    block = new ScrBlock(ScrBlock.Type.IFELSE, this, block, "if");
                    block.cond(new ScrCond(block, line.substring(line.indexOf("(") + 1, line.lastIndexOf(")"))));
                    old.tasks.add(new ScrTask(ScrTask.Type.IFELSE, block));
                    continue;
                }
                if (line.startsWith("elif") || line.startsWith("else if")) {
                    ScrTask last = block.lastTask();
                    if (last == null || !last.type.ifelse() || last.closed) continue;
                    block = new ScrBlock(ScrBlock.Type.IFELSE, this, block, "elseif");
                    block.cond(new ScrCond(block, line.substring(line.indexOf("(") + 1, line.lastIndexOf(")"))));
                    last.add(block);
                    continue;
                }
                if (line.startsWith("else")) {
                    ScrTask last = block.lastTask();
                    if (last == null || !last.type.ifelse() || last.closed) continue;
                    block = new ScrBlock(ScrBlock.Type.IFELSE, this, block, "else");
                    last.close(block);
                    continue;
                }
                ScrExpr expr = Script.parseExpression(line, ScrExprType.EXT_NONE);
                if (expr == null) continue;
                block.exprs.add(expr);
                block.tasks.add(new ScrTask(ScrTask.Type.LINE, expr));
            }
        }
        catch (Exception e) {
            Print.console("Error while parsing script with ID '" + this.id + "'!");
            Print.console("Parsed till: \n" + this.print(0));
            e.printStackTrace();
        }
        finally {
            scanner.close();
        }
    }

    public static ScrExpr parseExpression(String line, ScrExprType current) {
        ScrExpr next;
        ScrExpr expr = null;
        ScrExpr last = null;
        ParseExprParams par = new ParseExprParams(line, current);
        while ((next = Script.parseExpression(par)) != null) {
            if (expr == null) {
                expr = last = next;
                continue;
            }
            ScrExpr scrExpr = last.next != null ? last.next : last;
            last = next;
            scrExpr.next(last);
        }
        return expr;
    }

    public ScrAction act(String name) {
        return (ScrAction)this.blocks.get(name);
    }

    protected static ScrExpr parseExpression(ParseExprParams par) {
        boolean left;
        par.line = par.line.trim();
        if (par.line.length() == 0) {
            return null;
        }
        if (par.current.returnable() && par.line.startsWith("return")) {
            par.set(par.line.substring(6), ScrExprType.EXT_RETURN);
            return new ScrExpr.Return();
        }
        if (par.current == ScrExprType.EXT_NONE) {
            par.current = ScrExprType.EXT_LEFT;
        }
        boolean bl = left = par.current == ScrExprType.EXT_LEFT;
        if (!left && par.line.startsWith("!")) {
            par.line = par.line.substring(1);
            return new ScrExpr.Not();
        }
        if (!left && par.line.startsWith("-")) {
            par.line = par.line.substring(1);
            return new ScrExpr.Negate();
        }
        char[] arr = par.line.toCharArray();
        int till0 = Script.till(arr, 0, !left);
        if (till0 < 0) {
            return null;
        }
        String tar = par.line.substring(0, till0).trim();
        par.line = par.line.substring(till0).trim();
        if (par.line.length() < 2) {
            par.line = "";
            if (tar.equals("null")) {
                return new ScrExpr.Value();
            }
            boolean bool = Script.isb(tar);
            boolean number = Script.isn(tar.charAt(0));
            boolean str = tar.startsWith("\"");
            return number || bool || str ? new ScrExpr.Value(tar, number, bool, str) : new ScrExpr.Reference(tar);
        }
        if (par.line.startsWith(".")) {
            par.line = par.line.substring(1);
            return new ScrExpr.Reference(tar);
        }
        if (par.line.startsWith("(")) {
            ScrExpr.Exec exec = null;
            if (par.line.charAt(1) == ')') {
                exec = new ScrExpr.Exec(tar);
            } else {
                String pars = par.line.substring(par.line.indexOf("(") + 1, par.line.lastIndexOf(")"));
                exec = new ScrExpr.Exec(tar, pars.split(","));
            }
            par.line = par.line.substring(par.line.lastIndexOf(")") + 1);
            return exec;
        }
        ScrExpr.Reference ref = new ScrExpr.Reference(tar);
        if (par.current == ScrExprType.EXT_LEFT) {
            if (par.line.startsWith("=")) {
                par.set(par.line.substring(1), ScrExprType.EXT_RIGHT);
                return ref.next(new ScrExpr.Set(null));
            }
            if (par.line.startsWith("+=")) {
                par.set(par.line.substring(2), ScrExprType.EXT_RIGHT);
                return ref.next(new ScrExpr.Set(ScrOper.ADD));
            }
            if (par.line.startsWith("-=")) {
                par.set(par.line.substring(2), ScrExprType.EXT_RIGHT);
                return ref.next(new ScrExpr.Set(ScrOper.SUB));
            }
            if (par.line.startsWith("*=")) {
                par.set(par.line.substring(2), ScrExprType.EXT_RIGHT);
                return ref.next(new ScrExpr.Set(ScrOper.MUL));
            }
            if (par.line.startsWith("/=")) {
                par.set(par.line.substring(2), ScrExprType.EXT_RIGHT);
                return ref.next(new ScrExpr.Set(ScrOper.DIV));
            }
            if (par.line.startsWith("%=")) {
                par.set(par.line.substring(2), ScrExprType.EXT_RIGHT);
                return ref.next(new ScrExpr.Set(ScrOper.MOD));
            }
        } else if (par.current == ScrExprType.EXT_COND) {
            if (par.line.startsWith("==")) {
                par.line = par.line.substring(2);
                return ref.next(new ScrExpr.Compare(ScrOper.EQL));
            }
            if (par.line.startsWith(">=")) {
                par.line = par.line.substring(2);
                return ref.next(new ScrExpr.Compare(ScrOper.GRT_EQL));
            }
            if (par.line.startsWith("<=")) {
                par.line = par.line.substring(2);
                return ref.next(new ScrExpr.Compare(ScrOper.LES_EQL));
            }
            if (par.line.startsWith(">")) {
                par.line = par.line.substring(1);
                return ref.next(new ScrExpr.Compare(ScrOper.GRT));
            }
            if (par.line.startsWith("<")) {
                par.line = par.line.substring(1);
                return ref.next(new ScrExpr.Compare(ScrOper.LES));
            }
            if (par.line.startsWith("!=")) {
                par.line = par.line.substring(2);
                return ref.next(new ScrExpr.Compare(ScrOper.NOT_EQL));
            }
            if (par.line.startsWith("&&")) {
                par.line = par.line.substring(2);
                return ref.next(new ScrExpr.Compare(ScrOper.AND));
            }
            if (par.line.startsWith("||")) {
                par.line = par.line.substring(2);
                return ref.next(new ScrExpr.Compare(ScrOper.OR));
            }
        } else if (par.current == ScrExprType.EXT_RIGHT) {
            if (par.line.startsWith("+")) {
                par.line = par.line.substring(1);
                return ref.next(new ScrExpr.Math(ScrOper.ADD));
            }
            if (par.line.startsWith("-")) {
                par.line = par.line.substring(1);
                return ref.next(new ScrExpr.Math(ScrOper.SUB));
            }
            if (par.line.startsWith("*")) {
                par.line = par.line.substring(1);
                return ref.next(new ScrExpr.Math(ScrOper.MUL));
            }
            if (par.line.startsWith("/")) {
                par.line = par.line.substring(1);
                return ref.next(new ScrExpr.Math(ScrOper.DIV));
            }
            if (par.line.startsWith("%")) {
                par.line = par.line.substring(1);
                return ref.next(new ScrExpr.Math(ScrOper.MOD));
            }
        }
        return null;
    }

    private static int till(char[] arr, int from, boolean dot) {
        int i;
        boolean ia = dot && arr[from] == '\"';
        int n = i = ia ? from + 1 : from;
        while (i < arr.length) {
            if (ia) {
                if (arr[i] == '\"' && arr[i - 1] != '\\') {
                    return i;
                }
            } else if (!(arr[i] == '_' || arr[i] == ' ' || arr[i] >= 'a' && arr[i] <= 'z' || arr[i] >= 'A' && arr[i] <= 'Z' || Script.isn(arr[i]) || dot && arr[i] == '.' && (i - 1 <= 0 || Script.isn(arr[i])) && (i + 1 >= arr.length - 1 || Script.isn(arr[i])))) {
                return i;
            }
            ++i;
        }
        return arr.length;
    }

    public static boolean isn(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isb(String str) {
        return (str = str.toLowerCase()).equals("true") || str.equals("false");
    }

    private boolean checkForDataTypes(ScrBlock block, String line, boolean global) {
        if (global) {
            line = line.substring(7);
        }
        Two<String, ScrElm> elm = null;
        if (line.startsWith("str ")) {
            elm = ScrElm.parse(line, ScrElmType.STRING);
        } else if (line.startsWith("int ")) {
            elm = ScrElm.parse(line, ScrElmType.INTEGER);
        } else if (line.startsWith("flt ")) {
            elm = ScrElm.parse(line, ScrElmType.FLOAT);
        } else if (line.startsWith("bln ")) {
            elm = ScrElm.parse(line, ScrElmType.BOOLEAN);
        } else if (line.startsWith("lis ")) {
            elm = ScrElm.parse(line, ScrElmType.LIST);
        } else if (line.startsWith("obj ")) {
            elm = ScrElm.parse(line, ScrElmType.OBJ);
        }
        if (elm != null) {
            if (global) {
                if (!globals.contains(this.id)) {
                    globals.put(this.id, new ConcurrentHashMap());
                }
                globals.get(this.id).put((String)elm.first, (ScrElm)elm.second);
            } else {
                block.locals.put((String)elm.first, (ScrElm)elm.second);
            }
            return true;
        }
        return false;
    }

    public static final <A, B> void insert(HashMap<A, B> map, Two<A, B> two) {
        map.put(two.first, two.second);
    }

    @Override
    public ScrElm getElm(String elm, ScrBlock sub) {
        if (this.locals.containsKey(elm)) {
            return (ScrElm)this.locals.get(elm);
        }
        if (globals.contains(this.id) && globals.get(this.id).containsKey(elm)) {
            return globals.get(this.id).get(elm);
        }
        return ScrElm.NULL;
    }

    public ScrElm getLocalScriptElm(String elm, Supplier<ScrElm> create) {
        if (this.locals.containsKey(elm)) {
            return (ScrElm)this.locals.get(elm);
        }
        this.locals.put(elm, create.get());
        return (ScrElm)this.locals.get(elm);
    }

    @Override
    protected String preprint(String ret, String tab, String tab1, int depth) {
        if (globals.contains(this.id)) {
            for (Map.Entry<String, Object> entry : globals.get(this.id).entrySet()) {
                ret = (String)ret + tab1 + "global " + String.valueOf((Object)((ScrElm)entry.getValue()).scr_type()) + " " + entry.getKey() + " = " + ((ScrElm)entry.getValue()).scr_print() + "\n";
            }
        }
        for (Map.Entry<String, Object> entry : this.attrmap.entrySet()) {
            ret = (String)ret + tab1 + "using attr " + (String)entry.getValue() + " as " + entry.getKey() + "\n";
        }
        return ret;
    }

    @Override
    protected String postprint(String ret, String tab, String tab1, int depth) {
        if (this.subs.size() > 0) {
            ret = (String)ret + "\n";
        }
        for (ScrBlock sub : this.subs) {
            ret = (String)ret + sub.print(depth + 1);
        }
        return ret;
    }

    public String toString() {
        return this.print();
    }

    private static class ParseExprParams {
        private String line;
        private ScrExprType current;

        public ParseExprParams(String ln, ScrExprType curr) {
            this.line = ln;
            this.current = curr;
        }

        public ParseExprParams set(String ln, ScrExprType curr) {
            if (ln != null) {
                this.line = ln;
            }
            if (curr != null) {
                this.current = curr;
            }
            return this;
        }
    }
}

