/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.script.elm;

import net.fexcraft.lib.script.ScrBlock;
import net.fexcraft.lib.script.ScrElm;
import net.fexcraft.lib.script.ScrElmType;
import net.fexcraft.lib.script.ScrExpr;
import net.fexcraft.lib.script.ScrExprType;
import net.fexcraft.lib.script.Script;

public class RefElm
implements ScrElm {
    private String value;
    private boolean negative;
    private ScrExpr expr;

    public RefElm(String string, boolean neg) {
        this.value = string;
        this.negative = neg;
        if (this.value.contains(".")) {
            this.expr = Script.parseExpression(string, ScrExprType.EXT_RIGHT);
        }
    }

    @Override
    public String scr_str() {
        return this.value;
    }

    @Override
    public ScrElmType scr_type() {
        return ScrElmType.REF;
    }

    @Override
    public String scr_print() {
        return this.expr == null ? "{" + this.value + "}" : "{" + this.expr.print() + "}";
    }

    public boolean negative() {
        return this.negative;
    }

    public ScrElm getElm(ScrBlock block) {
        if (this.expr != null) {
            return this.expr.process(block, null, NULL);
        }
        return block.getElm(this.value, null);
    }
}

