/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fexcraft.app.json.FJson;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.RGB;

public abstract class ConfigBase {
    public static final LinkedHashMap<String, ConfigBase> CONFIGS = new LinkedHashMap();
    protected final File file;
    protected LinkedHashMap<String, ArrayList<ConfigEntry>> categories = new LinkedHashMap();
    protected ArrayList<ConfigEntry> entries = new ArrayList();
    protected ArrayList<Runnable> listeners = new ArrayList();
    protected boolean changes = false;
    protected String name;

    public ConfigBase(File fl) {
        this(fl, fl.getName());
    }

    public ConfigBase(File fl, String nome) {
        this.file = fl;
        this.name = nome;
        CONFIGS.put(this.name, this);
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            JsonMap map = new JsonMap();
            map.add("format", 1);
            this.fillInfo(map);
            JsonHandler.print(this.file, map, JsonHandler.PrintOption.SPACED);
        }
        this.fillEntries();
        this.reload();
    }

    protected abstract void fillInfo(JsonMap var1);

    protected abstract void fillEntries();

    protected abstract void onReload(JsonMap var1);

    public void reload() {
        this.changes = false;
        JsonMap map = JsonHandler.parse(this.file);
        this.createCategories();
        for (ConfigEntry entry : this.entries) {
            if (entry.consumer == null) continue;
            entry.consumer.accept(entry, map);
        }
        this.onReload(map);
        if (this.changes) {
            JsonHandler.print(this.file, map, JsonHandler.PrintOption.SPACED);
        }
        for (Runnable run : this.listeners) {
            run.run();
        }
    }

    private void createCategories() {
        this.categories.clear();
        for (ConfigEntry entry : this.entries) {
            if (!this.categories.containsKey(entry.cat)) {
                this.categories.put(entry.cat, new ArrayList());
            }
            this.categories.get(entry.cat).add(entry);
        }
    }

    public void addListener(Runnable run) {
        this.listeners.add(run);
    }

    public Map<String, ArrayList<ConfigEntry>> getCategories() {
        return this.categories;
    }

    public ArrayList<ConfigEntry> getEntries() {
        return this.entries;
    }

    public String name() {
        return this.name;
    }

    public int getCategoryIndex(String cat) {
        int idx = 0;
        for (String key : this.categories.keySet()) {
            if (key.equals(cat)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public String getCategoryByIndex(int idx) {
        int cat = 0;
        for (String key : this.categories.keySet()) {
            if (cat == idx) {
                return key;
            }
            ++cat;
        }
        return null;
    }

    public ArrayList<ConfigEntry> getCategoryEntries(int idx) {
        int cat = 0;
        for (ArrayList<ConfigEntry> list : this.categories.values()) {
            if (cat == idx) {
                return list;
            }
            ++cat;
        }
        return null;
    }

    public ConfigEntry getEntry(String cat, String key) {
        ArrayList<ConfigEntry> entries = this.categories.get(cat);
        if (entries != null) {
            for (ConfigEntry entry : entries) {
                if (!entry.key.equals(key)) continue;
                return entry;
            }
        }
        return null;
    }

    public static class ConfigEntry {
        private ConfigBase base;
        public final String key;
        public final String cat;
        private String info;
        private JsonValue defval;
        private JsonValue value;
        private BiConsumer<ConfigEntry, JsonMap> consumer;
        private float min;
        private float max;
        private Boolean req_level;
        private Boolean req_start;

        public ConfigEntry(ConfigBase base, String cat, String key, JsonValue def) {
            this.cat = cat;
            this.key = key;
            this.defval = def;
            this.base = base;
        }

        public ConfigEntry(ConfigBase base, String cat, String key, boolean def) {
            this(base, cat, key, new JsonValue<Boolean>(def));
        }

        public ConfigEntry(ConfigBase base, String cat, String key, String def) {
            this(base, cat, key, new JsonValue<String>(def));
        }

        public ConfigEntry(ConfigBase base, String cat, String key, float def) {
            this(base, cat, key, new JsonValue<Float>(Float.valueOf(def)));
        }

        public ConfigEntry(ConfigBase base, String cat, String key, int def) {
            this(base, cat, key, new JsonValue<Integer>(def));
        }

        public ConfigEntry info(String str) {
            this.info = str;
            return this;
        }

        public ConfigEntry rang(float mn, float mx) {
            this.min = mn;
            this.max = mx;
            return this;
        }

        public ConfigEntry cons(BiConsumer<ConfigEntry, JsonMap> cons) {
            this.consumer = cons;
            return this;
        }

        public ConfigEntry req(boolean re_level, boolean re_start) {
            this.req_level = re_level;
            this.req_start = re_start;
            return this;
        }

        public String getString(JsonMap map) {
            if (!(map = this.checkCat(map)).has(this.key)) {
                this.fill(map);
            }
            this.value = map.getMap(this.key).get("value");
            return this.value.string_value();
        }

        public boolean getBoolean(JsonMap map) {
            if (!(map = this.checkCat(map)).has(this.key)) {
                this.fill(map);
            }
            this.value = map.getMap(this.key).get("value");
            return this.value.bool();
        }

        public int getInteger(JsonMap map) {
            int i;
            if (!(map = this.checkCat(map)).has(this.key)) {
                this.fill(map);
            }
            i = (float)(i = map.getMap(this.key).get("value").integer_value()) > this.max ? (int)this.max : ((float)i < this.min ? (int)this.min : i);
            this.value = new JsonValue<Integer>(i);
            return i;
        }

        public float getFloat(JsonMap map) {
            float f;
            if (!(map = this.checkCat(map)).has(this.key)) {
                this.fill(map);
            }
            f = (f = map.getMap(this.key).get("value").float_value()) > this.max ? this.max : (f < this.min ? this.min : f);
            this.value = new JsonValue<Float>(Float.valueOf(f));
            return f;
        }

        public FJson getJson(JsonMap map) {
            if (!(map = this.checkCat(map)).has(this.key)) {
                this.fill(map);
            }
            this.value = map.getMap(this.key).get("value");
            return this.value;
        }

        private JsonMap checkCat(JsonMap map) {
            if (!map.has(this.cat)) {
                map.addMap(this.cat);
            }
            return map.getMap(this.cat);
        }

        private void fill(JsonMap map) {
            JsonMap con = new JsonMap();
            if (this.info != null) {
                con.add("info", this.info);
            }
            if (this.min != 0.0f || this.max != 0.0f) {
                con.add("range", RGB.df.format(this.min) + " ~ " + RGB.df.format(this.max));
            }
            con.add("value", this.defval);
            map.add(this.key, con);
            this.base.changes = true;
        }

        public String info() {
            return this.info;
        }

        public float min() {
            return this.min;
        }

        public float max() {
            return this.max;
        }

        public JsonValue initial() {
            return this.defval;
        }

        public JsonValue value() {
            return this.value == null ? this.defval : this.value;
        }

        public Boolean reqLevelRestart() {
            return this.req_level;
        }

        public Boolean reqGameRestart() {
            return this.req_start;
        }
    }
}

