/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import net.fexcraft.mod.fcl.FCL;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;

public class FclRecipe {
    public static LinkedHashMap<String, LinkedHashMap<IDL, ArrayList<FclRecipe>>> RECIPES = new LinkedHashMap();
    public static Function<Component, Boolean> VALIDATE;
    public static Function<Component, List<StackWrapper>> GET_TAG_AS_LIST;
    public final StackWrapper output;
    public final List<Component> components;

    public FclRecipe(StackWrapper stack, Component ... comps) {
        this.output = stack;
        this.components = ImmutableList.copyOf((Object[])comps);
    }

    public FclRecipe(StackWrapper stack, Collection<Component> comps) {
        this.output = stack;
        this.components = ImmutableList.copyOf(comps);
    }

    public FclRecipe(Object stack, Component ... comps) {
        this.output = UniStack.createStack(stack);
        this.components = ImmutableList.copyOf((Object[])comps);
    }

    public static void register(String category, FclRecipe recipe) {
        if (category.length() == 0) {
            return;
        }
        if (recipe.output.empty()) {
            FCL.LOGGER.info("Failed to register recipe for '" + category + "': no output");
            return;
        }
        for (Component comp : recipe.components) {
            if (VALIDATE.apply(comp).booleanValue()) continue;
            FCL.LOGGER.info("Failed to register recipe for '" + category + "': invalid component / " + (comp.tag ? comp.id : "empty"));
            return;
        }
        IDL idl = recipe.output.getIDL();
        if (!RECIPES.containsKey(category)) {
            RECIPES.put(category, new LinkedHashMap());
        }
        if (!RECIPES.get(category).containsKey(idl)) {
            RECIPES.get(category).put(idl, new ArrayList());
        }
        RECIPES.get(category).get(idl).add(recipe);
    }

    public void register(String category) {
        FclRecipe.register(category, this);
    }

    public static int indexOfCategory(String cat) {
        int idx = 0;
        for (String key : RECIPES.keySet()) {
            if (key.equals(cat)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static LinkedHashMap<IDL, ArrayList<FclRecipe>> getCategoryAt(int cat) {
        int idx = 0;
        for (String key : RECIPES.keySet()) {
            if (idx == cat) {
                return RECIPES.get(key);
            }
            ++idx;
        }
        return null;
    }

    public static String getCategoryIdAt(int cat) {
        int idx = 0;
        for (String key : RECIPES.keySet()) {
            if (idx == cat) {
                return key;
            }
            ++idx;
        }
        return null;
    }

    public static IDL getResultKey(String category, int kid) {
        LinkedHashMap<IDL, ArrayList<FclRecipe>> results = RECIPES.get(category);
        int idx = 0;
        for (IDL key : results.keySet()) {
            if (idx == kid) {
                return key;
            }
            ++idx;
        }
        return null;
    }

    public static int getResultIdx(String category, String res) {
        LinkedHashMap<IDL, ArrayList<FclRecipe>> results = RECIPES.get(category);
        int idx = 0;
        for (IDL key : results.keySet()) {
            if (key.colon().equals(res)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static Builder newBuilder(String cat) {
        return new Builder(cat);
    }

    public static class Component {
        public final boolean tag;
        public final String id;
        public final int amount;
        public final StackWrapper stack;
        public List<StackWrapper> list;
        public Object key;

        public Component(String tagid, int am) {
            this.tag = true;
            this.id = tagid;
            this.amount = am;
            this.stack = null;
        }

        public Component(StackWrapper stack) {
            this.stack = stack;
            this.amount = stack.count();
            this.tag = false;
            this.id = null;
        }

        public Component(Object stack) {
            this.stack = UniStack.createStack(stack);
            this.amount = this.stack.count();
            this.tag = false;
            this.id = null;
        }

        public void refreshList() {
            this.list = GET_TAG_AS_LIST.apply(this);
        }
    }

    public static class Builder {
        private ArrayList<Component> comps = new ArrayList();
        private StackWrapper stack;
        private String category;

        public Builder(String cat) {
            this.category = cat;
        }

        public Builder output(StackWrapper stack) {
            this.stack = stack;
            return this;
        }

        public Builder output(Object stack) {
            this.stack = UniStack.createStack(stack);
            return this;
        }

        public Builder add(Object stack) {
            this.comps.add(new Component(stack));
            return this;
        }

        public Builder add(Component comp) {
            this.comps.add(comp);
            return this;
        }

        public Builder add(String tag, int am) {
            this.comps.add(new Component(tag, am));
            return this;
        }

        public void register() {
            FclRecipe.register(this.category, new FclRecipe(this.stack, this.comps.toArray(new Component[0])));
        }
    }
}

