/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.inv;

import java.util.Collection;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.inv.ItemWrapper;
import net.fexcraft.mod.uni.tag.TagCW;

public abstract class StackWrapper {
    public static HashMap<String, Function<Object, Boolean>> ITEM_TYPES = new HashMap();
    public static HashMap<String, Function<StackWrapper, Object>> CONTENT_TYPES = new HashMap();
    public static StackWrapper EMPTY = null;
    public static String IT_LEAD = "lead";
    public static String IT_FOOD = "food";
    protected ItemWrapper item;

    public StackWrapper(ItemWrapper item) {
        this.item = item;
    }

    public abstract <IS> IS local();

    public abstract void set(Object var1);

    public abstract Object direct();

    public abstract StackWrapper updateTag(TagCW var1);

    public void updateTag(Consumer<TagCW> cons) {
        TagCW com = this.copyTag();
        cons.accept(com);
        this.updateTag(com);
    }

    public abstract TagCW directTag();

    public abstract TagCW copyTag();

    public abstract boolean hasTag();

    public ItemWrapper getItem() {
        return this.item;
    }

    public abstract String getName();

    public abstract int maxsize();

    public abstract int damage();

    public abstract void damage(int var1);

    public abstract int count();

    public abstract void count(int var1);

    public void decr(int am) {
        this.count(this.count() - am);
    }

    public void incr(int am) {
        this.count(this.count() + am);
    }

    public abstract StackWrapper copy();

    public abstract void save(TagCW var1);

    public abstract boolean empty();

    public boolean isItemOf(String type) {
        Function<Object, Boolean> func = ITEM_TYPES.get(type);
        return func != null && this.getItem() != null && func.apply(this.getItem().direct()) != false;
    }

    public boolean isItemOfAny(String ... types) {
        for (String type : types) {
            if (!this.isItemOf(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isItemOfAny(Collection<String> types) {
        for (String type : types) {
            if (!this.isItemOf(type)) continue;
            return true;
        }
        return false;
    }

    public <C> C getContent(String type) {
        Function<StackWrapper, Object> func = CONTENT_TYPES.get(type);
        return (C)(func == null ? null : func.apply(this));
    }

    public abstract IDL getIDL();

    public abstract String getID();
}

