/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.impl.Slide;
import com.alrex.parcool.common.attachment.common.Parkourability;
import com.alrex.parcool.utilities.Easing;
import com.alrex.parcool.utilities.VectorUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class SlidingAnimator
extends Animator {
    private static final int MAX_TRANSITION_TICK = 5;

    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return !parkourability.get(Slide.class).isDoing();
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        float animFactor = ((float)this.getTick() + transformer.getPartialTick()) / 5.0f;
        if (animFactor > 1.0f) {
            animFactor = 1.0f;
        }
        animFactor = new Easing(animFactor).sinInOut(0.0f, 1.0f, 0.0f, 1.0f).get();
        transformer.translateLeftLeg(0.0f, -1.2f * animFactor, -2.0f * animFactor).translateRightArm(0.0f, 1.2f * animFactor, 1.2f * animFactor).translateHead(0.0f, 0.0f, -animFactor).rotateHeadPitch(50.0f * animFactor).rotateAdditionallyHeadYaw(50.0f * animFactor).rotateAdditionallyHeadRoll(-10.0f * animFactor).rotateRightArm((float)Math.toRadians(50.0), (float)Math.toRadians(-40.0), 0.0f, animFactor).rotateLeftArm((float)Math.toRadians(20.0), 0.0f, (float)Math.toRadians(-100.0), animFactor).rotateRightLeg((float)Math.toRadians(-30.0), (float)Math.toRadians(40.0), 0.0f, animFactor).rotateLeftLeg((float)Math.toRadians(40.0), (float)Math.toRadians(-30.0), (float)Math.toRadians(15.0), animFactor).makeLegsLittleMoving().makeArmsNatural().end();
    }

    @Override
    public boolean rotatePre(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        Vec3 vec = parkourability.get(Slide.class).getSlidingVector();
        if (vec == null) {
            return false;
        }
        float animFactor = ((float)this.getTick() + rotator.getPartialTick()) / 5.0f;
        float yRot = (float)VectorUtil.toYawDegree(vec);
        if (animFactor > 1.0f) {
            animFactor = 1.0f;
        }
        animFactor = new Easing(animFactor).sinInOut(0.0f, 1.0f, 0.0f, 1.0f).get();
        rotator.rotateYawRightward(180.0f + yRot).rotatePitchFrontward(-55.0f * animFactor).translate(0.35f * animFactor, 0.0f, 0.0f).rotateYawRightward(-55.0f * animFactor).translate(0.0f, -0.7f * animFactor, -0.3f * animFactor);
        return true;
    }
}

