/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.input;

import com.alrex.parcool.utilities.VectorUtil;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
public class KeyBindings {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final Options settings = KeyBindings.mc.f_91066_;
    private static final KeyMapping keyBindEnable = new KeyMapping("key.parcool.Enable", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 80, "key.categories.parcool");
    private static final KeyMapping keyBindCrawl = new KeyMapping("key.parcool.Crawl", 67, "key.categories.parcool");
    private static final KeyMapping keyBindGrabWall = new KeyMapping("key.parcool.ClingToCliff", InputConstants.Type.MOUSE, 1, "key.categories.parcool");
    private static final KeyMapping keyBindBreakfall = new KeyMapping("key.parcool.Breakfall", 82, "key.categories.parcool");
    private static final KeyMapping keyBindFastRunning = new KeyMapping("key.parcool.FastRun", 341, "key.categories.parcool");
    private static final KeyMapping keyBindFlipping = new KeyMapping("key.parcool.Flipping", -1, "key.categories.parcool");
    private static final KeyMapping keyBindVault = new KeyMapping("key.parcool.Vault", InputConstants.Type.MOUSE, 1, "key.categories.parcool");
    private static final KeyMapping keyBindDodge = new KeyMapping("key.parcool.Dodge", 82, "key.categories.parcool");
    private static final KeyMapping keyBindRideZipline = new KeyMapping("key.parcool.RideZipline", InputConstants.Type.MOUSE, 1, "key.categories.parcool");
    private static final KeyMapping keyBindWallJump = new KeyMapping("key.parcool.WallJump", 32, "key.categories.parcool");
    private static final KeyMapping keyBindHangDown = new KeyMapping("key.parcool.HangDown", InputConstants.Type.MOUSE, 1, "key.categories.parcool");
    private static final KeyMapping keyBindWallSlide = new KeyMapping("key.parcool.WallSlide", InputConstants.Type.MOUSE, 1, "key.categories.parcool");
    private static final KeyMapping keyBindHideInBlock = new KeyMapping("key.parcool.HideInBlock", 67, "key.categories.parcool");
    private static final KeyMapping keyBindHorizontalWallRun = new KeyMapping("key.parcool.HorizontalWallRun", 82, "key.categories.parcool");
    private static final KeyMapping keyBindQuickTurn = new KeyMapping("key.parcool.QuickTurn", -1, "key.categories.parcool");
    private static final KeyMapping keyBindOpenSettings = new KeyMapping("key.parcool.openSetting", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.ALT, InputConstants.Type.KEYSYM, 80, "key.categories.parcool");
    private static final Vec3 forwardVector = new Vec3(0.0, 0.0, 1.0);

    public static KeyMapping getKeySprint() {
        return KeyBindings.settings.f_92091_;
    }

    public static Boolean isKeyJumpDown() {
        return KeyBindings.mc.f_91074_ != null && KeyBindings.mc.f_91074_.f_108618_ != null && KeyBindings.mc.f_91074_.f_108618_.f_108572_;
    }

    public static KeyMapping getKeySneak() {
        return KeyBindings.settings.f_92090_;
    }

    public static Vec3 getCurrentMoveVector() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return Vec3.f_82478_;
        }
        Vec2 vector = player.f_108618_.m_108575_();
        if (VectorUtil.isZero(vector)) {
            return Vec3.f_82478_;
        }
        double length = vector.m_165907_();
        return new Vec3((double)vector.f_82470_ / length, 0.0, (double)vector.f_82471_ / length);
    }

    public static Vec3 getForwardVector() {
        return forwardVector;
    }

    public static Boolean isAnyMovingKeyDown() {
        return KeyBindings.mc.f_91074_ != null && KeyBindings.mc.f_91074_.f_108618_ != null && (KeyBindings.mc.f_91074_.f_108618_.f_108570_ || KeyBindings.mc.f_91074_.f_108618_.f_108571_ || KeyBindings.mc.f_91074_.f_108618_.f_108567_ != 0.0f || KeyBindings.mc.f_91074_.f_108618_.f_108566_ != 0.0f);
    }

    public static Boolean isLeftAndRightDown() {
        return KeyBindings.mc.f_91074_ != null && KeyBindings.mc.f_91074_.f_108618_ != null && KeyBindings.mc.f_91074_.f_108618_.f_108570_ && KeyBindings.mc.f_91074_.f_108618_.f_108571_;
    }

    public static Boolean isKeyForwardDown() {
        return KeyBindings.mc.f_91074_ != null && KeyBindings.mc.f_91074_.f_108618_ != null && KeyBindings.mc.f_91074_.f_108618_.f_108567_ > 0.0f;
    }

    public static Boolean isKeyLeftDown() {
        return KeyBindings.mc.f_91074_ != null && KeyBindings.mc.f_91074_.f_108618_ != null && KeyBindings.mc.f_91074_.f_108618_.f_108570_;
    }

    public static Boolean isKeyRightDown() {
        return KeyBindings.mc.f_91074_ != null && KeyBindings.mc.f_91074_.f_108618_ != null && KeyBindings.mc.f_91074_.f_108618_.f_108571_;
    }

    public static Boolean isKeyBackDown() {
        return KeyBindings.mc.f_91074_ != null && KeyBindings.mc.f_91074_.f_108618_ != null && KeyBindings.mc.f_91074_.f_108618_.f_108567_ < 0.0f;
    }

    public static KeyMapping getKeyBindEnable() {
        return keyBindEnable;
    }

    public static KeyMapping getKeyCrawl() {
        return keyBindCrawl;
    }

    public static KeyMapping getKeyQuickTurn() {
        return keyBindQuickTurn;
    }

    public static KeyMapping getKeyGrabWall() {
        return keyBindGrabWall;
    }

    public static KeyMapping getKeyVault() {
        return keyBindVault;
    }

    public static KeyMapping getKeyActivateParCool() {
        return keyBindOpenSettings;
    }

    public static KeyMapping getKeyBreakfall() {
        return keyBindBreakfall;
    }

    public static KeyMapping getKeyFastRunning() {
        return keyBindFastRunning;
    }

    public static KeyMapping getKeyDodge() {
        return keyBindDodge;
    }

    public static KeyMapping getKeyRideZipline() {
        return keyBindRideZipline;
    }

    public static KeyMapping getKeyWallSlide() {
        return keyBindWallSlide;
    }

    public static KeyMapping getKeyHangDown() {
        return keyBindHangDown;
    }

    public static KeyMapping getKeyHideInBlock() {
        return keyBindHideInBlock;
    }

    public static KeyMapping getKeyHorizontalWallRun() {
        return keyBindHorizontalWallRun;
    }

    public static KeyMapping getKeyWallJump() {
        return keyBindWallJump;
    }

    public static KeyMapping getKeyFlipping() {
        return keyBindFlipping;
    }

    @SubscribeEvent
    public static void register(FMLClientSetupEvent event) {
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindEnable);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindCrawl);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindGrabWall);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindBreakfall);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindFastRunning);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindDodge);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindRideZipline);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindWallSlide);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindWallJump);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindVault);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindHorizontalWallRun);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindHideInBlock);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindOpenSettings);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindQuickTurn);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindFlipping);
        ClientRegistry.registerKeyBinding((KeyMapping)keyBindHangDown);
    }
}

