/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.renderer.entity;

import com.alrex.parcool.client.renderer.RenderTypes;
import com.alrex.parcool.common.entity.zipline.ZiplineRopeEntity;
import com.alrex.parcool.common.zipline.Zipline;
import com.alrex.parcool.config.ParCoolConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class ZiplineRopeRenderer
extends EntityRenderer<ZiplineRopeEntity> {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("textures/entity/arrow");

    public ZiplineRopeRenderer(EntityRendererProvider.Context p_i46179_1_) {
        super(p_i46179_1_);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull ZiplineRopeEntity ziplineRopeEntity) {
        return TEXTURE_LOCATION;
    }

    public boolean shouldRender(ZiplineRopeEntity entity, Frustum frustum, double x, double y, double z) {
        return entity.m_6000_(x, y, z);
    }

    public void render(@Nonnull ZiplineRopeEntity entity, float p_225623_2_, float partialTick, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource multiBufferSource, int p_225623_6_) {
        this.renderRope(entity, partialTick, matrixStack, multiBufferSource);
    }

    private void renderRope(ZiplineRopeEntity entity, float partialTick, PoseStack matrixStack, MultiBufferSource multiBufferSource) {
        BlockPos start = entity.getStartPos();
        BlockPos end = entity.getEndPos();
        if (start == BlockPos.f_121853_ && end == BlockPos.f_121853_) {
            return;
        }
        int color = entity.getColor();
        float r = (float)((0xFF0000 & color) >> 16) / 255.0f;
        float g = (float)((0xFF00 & color) >> 8) / 255.0f;
        float b = (float)(0xFF & color) / 255.0f;
        Vec3 entityPos = entity.m_20182_();
        Zipline zipline = entity.getZipline();
        Vec3 startPos = zipline.getStartPos();
        Vec3 startPosOffset = startPos.m_82546_(entityPos);
        Vec3 endOffsetFromStart = zipline.getOffsetToEndFromStart();
        boolean render3d = ParCoolConfig.Client.Booleans.Enable3DRenderingForZipline.get();
        matrixStack.m_85836_();
        matrixStack.m_85837_(startPosOffset.m_7096_(), startPosOffset.m_7098_(), startPosOffset.m_7094_());
        VertexConsumer vertexConsumer = render3d ? multiBufferSource.m_6299_(RenderTypes.ZIPLINE_3D) : multiBufferSource.m_6299_(RenderTypes.ZIPLINE_2D);
        Matrix4f transformMatrix = matrixStack.m_85850_().m_85861_();
        int startBlockLightLevel = this.m_6086_(entity, start);
        int endBlockLightLevel = this.m_6086_(entity, end);
        int startSkyBrightness = entity.f_19853_.m_45517_(LightLayer.SKY, start);
        int endSkyBrightness = entity.f_19853_.m_45517_(LightLayer.SKY, end);
        int divisionCount = Math.min((int)Math.ceil(endOffsetFromStart.m_82553_() / 0.6), 24);
        float invLengthSqrtXZ = (float)Mth.m_14193_((double)(endOffsetFromStart.m_7096_() * endOffsetFromStart.m_7096_() + endOffsetFromStart.m_7094_() * endOffsetFromStart.m_7094_()));
        float unitLengthX = (float)(endOffsetFromStart.m_7096_() * (double)invLengthSqrtXZ);
        float unitLengthZ = (float)(endOffsetFromStart.m_7094_() * (double)invLengthSqrtXZ);
        for (int i = 0; i < divisionCount; ++i) {
            float colorScale = i % 2 == 0 ? 1.0f : 0.8f;
            for (int j = 0; j < 2; ++j) {
                if (render3d) {
                    this.renderRopeSingleBlock3D(transformMatrix, vertexConsumer, zipline, i, divisionCount, unitLengthX, unitLengthZ, startBlockLightLevel, endBlockLightLevel, startSkyBrightness, endSkyBrightness, r * colorScale, g * colorScale, b * colorScale);
                    continue;
                }
                this.renderRopeSingleBlock2D(transformMatrix, vertexConsumer, zipline, i, divisionCount, unitLengthX, unitLengthZ, startBlockLightLevel, endBlockLightLevel, startSkyBrightness, endSkyBrightness, r * colorScale, g * colorScale, b * colorScale, j % 2 == 0);
            }
        }
        matrixStack.m_85849_();
    }

    private void renderRopeSingleBlock2D(Matrix4f transformMatrix, VertexConsumer vertexConsumer, Zipline zipline, int currentCount, int maxCount, float unitLengthX, float unitLengthZ, int startBlockLightLevel, int endBlockLightLevel, int startSkyBrightness, int endSkyBrightness, float r, float g, float b, boolean tiltType) {
        for (int i = 0; i < 2; ++i) {
            float phase = (float)(currentCount + i) / (float)maxCount;
            int lightLevel = LightTexture.m_109885_((int)((int)Mth.m_14179_((float)phase, (float)startBlockLightLevel, (float)endBlockLightLevel)), (int)((int)Mth.m_14179_((float)phase, (float)startSkyBrightness, (float)endSkyBrightness)));
            Vec3 midPointD = zipline.getMidPointOffsetFromStart(phase);
            Vector3f midPoint = new Vector3f((float)midPointD.m_7096_(), (float)midPointD.m_7098_(), (float)midPointD.m_7094_());
            float width = 0.075f;
            float tilt = zipline.getSlope(phase);
            float tiltInv = Mth.m_14195_((float)(tilt * tilt + 1.0f));
            float yOffset = 0.075f * tiltInv / 1.4142135f;
            float xBaseOffset = unitLengthX * 0.075f * tilt * tiltInv / 1.4142135f;
            float zBaseOffset = unitLengthZ * 0.075f * tilt * tiltInv / 1.4142135f;
            float sign = tiltType ? 1.0f : -1.0f;
            float xOffset = sign * unitLengthZ * 0.075f / 1.4142135f;
            float zOffset = sign * -unitLengthX * 0.075f / 1.4142135f;
            if (i == 0) {
                vertexConsumer.m_85982_(transformMatrix, midPoint.m_122239_() + xBaseOffset + xOffset, midPoint.m_122260_() - yOffset, midPoint.m_122269_() + zBaseOffset + zOffset).m_85950_(r, g, b, 1.0f).m_85969_(lightLevel).m_5752_();
                vertexConsumer.m_85982_(transformMatrix, midPoint.m_122239_() - xBaseOffset - xOffset, midPoint.m_122260_() + yOffset, midPoint.m_122269_() - zBaseOffset - zOffset).m_85950_(r, g, b, 1.0f).m_85969_(lightLevel).m_5752_();
                continue;
            }
            vertexConsumer.m_85982_(transformMatrix, midPoint.m_122239_() - xBaseOffset - xOffset, midPoint.m_122260_() + yOffset, midPoint.m_122269_() - zBaseOffset - zOffset).m_85950_(r, g, b, 1.0f).m_85969_(lightLevel).m_5752_();
            vertexConsumer.m_85982_(transformMatrix, midPoint.m_122239_() + xBaseOffset + xOffset, midPoint.m_122260_() - yOffset, midPoint.m_122269_() + zBaseOffset + zOffset).m_85950_(r, g, b, 1.0f).m_85969_(lightLevel).m_5752_();
        }
    }

    private void renderRopeSingleBlock3D(Matrix4f transformMatrix, VertexConsumer vertexConsumer, Zipline zipline, int currentCount, int maxCount, float unitLengthX, float unitLengthZ, int startBlockLightLevel, int endBlockLightLevel, int startSkyBrightness, int endSkyBrightness, float r, float g, float b) {
        int i;
        Vector3f[] vertexList = new Vector3f[8];
        int[] lightLevelList = new int[2];
        for (i = 0; i < 2; ++i) {
            float phase = (float)(currentCount + i) / (float)maxCount;
            lightLevelList[i] = LightTexture.m_109885_((int)((int)Mth.m_14179_((float)phase, (float)startBlockLightLevel, (float)endBlockLightLevel)), (int)((int)Mth.m_14179_((float)phase, (float)startSkyBrightness, (float)endSkyBrightness)));
            Vec3 midPointD = zipline.getMidPointOffsetFromStart(phase);
            Vector3f midPoint = new Vector3f((float)midPointD.m_7096_(), (float)midPointD.m_7098_(), (float)midPointD.m_7094_());
            float width = 0.075f;
            float tilt = zipline.getSlope(phase);
            float tiltInv = Mth.m_14195_((float)(tilt * tilt + 1.0f));
            float yOffset = 0.075f * tiltInv / 1.4142135f;
            float xBaseOffset = unitLengthX * 0.075f * tilt * tiltInv / 1.4142135f;
            float zBaseOffset = unitLengthZ * 0.075f * tilt * tiltInv / 1.4142135f;
            float xOffset = unitLengthZ * 0.075f / 1.4142135f;
            float zOffset = -unitLengthX * 0.075f / 1.4142135f;
            vertexList[4 * i] = new Vector3f(midPoint.m_122239_() - xBaseOffset + xOffset, midPoint.m_122260_() + yOffset, midPoint.m_122269_() - zBaseOffset + zOffset);
            vertexList[4 * i + 1] = new Vector3f(midPoint.m_122239_() - xBaseOffset - xOffset, midPoint.m_122260_() + yOffset, midPoint.m_122269_() - zBaseOffset - zOffset);
            vertexList[4 * i + 2] = new Vector3f(midPoint.m_122239_() + xBaseOffset - xOffset, midPoint.m_122260_() - yOffset, midPoint.m_122269_() + zBaseOffset - zOffset);
            vertexList[4 * i + 3] = new Vector3f(midPoint.m_122239_() + xBaseOffset + xOffset, midPoint.m_122260_() - yOffset, midPoint.m_122269_() + zBaseOffset + zOffset);
        }
        for (i = 0; i < 4; ++i) {
            vertexConsumer.m_85982_(transformMatrix, vertexList[i].m_122239_(), vertexList[i].m_122260_(), vertexList[i].m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(lightLevelList[0]).m_5752_();
            vertexConsumer.m_85982_(transformMatrix, vertexList[(i + 1) % 4].m_122239_(), vertexList[(i + 1) % 4].m_122260_(), vertexList[(i + 1) % 4].m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(lightLevelList[0]).m_5752_();
            vertexConsumer.m_85982_(transformMatrix, vertexList[4 + (i + 1) % 4].m_122239_(), vertexList[4 + (i + 1) % 4].m_122260_(), vertexList[4 + (i + 1) % 4].m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(lightLevelList[1]).m_5752_();
            vertexConsumer.m_85982_(transformMatrix, vertexList[4 + i].m_122239_(), vertexList[4 + i].m_122260_(), vertexList[4 + i].m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(lightLevelList[1]).m_5752_();
        }
        if (currentCount == 0) {
            vertexConsumer.m_85982_(transformMatrix, vertexList[3].m_122239_(), vertexList[3].m_122260_(), vertexList[3].m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(lightLevelList[0]).m_5752_();
            vertexConsumer.m_85982_(transformMatrix, vertexList[2].m_122239_(), vertexList[2].m_122260_(), vertexList[2].m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(lightLevelList[0]).m_5752_();
            vertexConsumer.m_85982_(transformMatrix, vertexList[1].m_122239_(), vertexList[1].m_122260_(), vertexList[1].m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(lightLevelList[0]).m_5752_();
            vertexConsumer.m_85982_(transformMatrix, vertexList[0].m_122239_(), vertexList[0].m_122260_(), vertexList[0].m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(lightLevelList[0]).m_5752_();
        } else if (currentCount == maxCount - 1) {
            vertexConsumer.m_85982_(transformMatrix, vertexList[4].m_122239_(), vertexList[4].m_122260_(), vertexList[4].m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(lightLevelList[0]).m_5752_();
            vertexConsumer.m_85982_(transformMatrix, vertexList[5].m_122239_(), vertexList[5].m_122260_(), vertexList[5].m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(lightLevelList[0]).m_5752_();
            vertexConsumer.m_85982_(transformMatrix, vertexList[6].m_122239_(), vertexList[6].m_122260_(), vertexList[6].m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(lightLevelList[0]).m_5752_();
            vertexConsumer.m_85982_(transformMatrix, vertexList[7].m_122239_(), vertexList[7].m_122260_(), vertexList[7].m_122269_()).m_85950_(r, g, b, 1.0f).m_85969_(lightLevelList[0]).m_5752_();
        }
    }
}

