/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.RideZiplineAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.BehaviorEnforcer;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Dive;
import com.alrex.parcool.common.action.impl.Flipping;
import com.alrex.parcool.common.action.impl.HangDown;
import com.alrex.parcool.common.action.impl.HorizontalWallRun;
import com.alrex.parcool.common.action.impl.Vault;
import com.alrex.parcool.common.action.impl.VerticalWallRun;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.entity.zipline.ZiplineRopeEntity;
import com.alrex.parcool.common.zipline.Zipline;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.VectorUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class RideZipline
extends Action {
    private static final BehaviorEnforcer.ID ID_FALL_FLY_CANCEL = BehaviorEnforcer.newID();
    private static final BehaviorEnforcer.ID ID_SPRINT_CANCEL = BehaviorEnforcer.newID();
    @Nullable
    private ZiplineRopeEntity ridingZipline;
    @Nullable
    private Vec3 endOffsetFromStart;
    private double speed;
    private double acceleration;
    private double slope;
    private float currentT;
    @Nullable
    private Vec3 currentPos;
    private boolean previouslyStopByCollision = false;

    public double getAcceleration() {
        return this.acceleration;
    }

    public double getSlope() {
        return this.slope;
    }

    @Nullable
    public Vec3 getEndOffsetFromStart() {
        return this.endOffsetFromStart;
    }

    @Override
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        if (!(!KeyBindings.getKeyRideZipline().m_90857_() || player.m_20096_() || player.m_20069_() || player.m_21255_() || player.m_6047_() || player.m_6069_() || stamina.isExhausted() || KeyBindings.isKeyJumpDown().booleanValue() && this.getNotDoingTick() <= 5 || this.previouslyStopByCollision && this.getNotDoingTick() <= 5 || parkourability.get(Dive.class).isDoing() || parkourability.get(Vault.class).isDoing() || parkourability.get(HangDown.class).isDoing() || parkourability.get(Flipping.class).isDoing() || parkourability.get(HorizontalWallRun.class).isDoing() || parkourability.get(VerticalWallRun.class).isDoing())) {
            ZiplineRopeEntity ropeEntity = Zipline.getHangableZipline(player.f_19853_, player);
            if (ropeEntity == null) {
                return false;
            }
            double t = ropeEntity.getZipline().getParameter(player.m_20182_());
            if (t < 0.0 || 1.0 < t) {
                return false;
            }
            this.ridingZipline = ropeEntity;
            BufferUtil.wrap(startInfo).putVec3(this.ridingZipline.getZipline().getOffsetToEndFromStart());
            return true;
        }
        return false;
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        if (player.f_19862_ || player.f_19863_) {
            this.previouslyStopByCollision = true;
            return false;
        }
        return KeyBindings.getKeyRideZipline().m_90857_() && !KeyRecorder.keyJumpState.isPressed() && !player.m_5830_() && !stamina.isExhausted() && this.ridingZipline != null && this.ridingZipline.m_6084_() && 0.0f <= this.currentT && this.currentT <= 1.0f;
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        if (this.ridingZipline == null) {
            return;
        }
        this.rideNewZipline(this.ridingZipline, player.m_20182_(), player.m_20184_());
        player.m_6858_(false);
        parkourability.getBehaviorEnforcer().setMarkerEnforceMovePoint(this::isDoing, () -> {
            if (this.currentPos == null) {
                return null;
            }
            return this.currentPos.m_82492_(0.0, (double)player.m_20206_() * 1.11, 0.0);
        });
        parkourability.getBehaviorEnforcer().addMarkerCancellingSprint(ID_SPRINT_CANCEL, this::isDoing);
        Animation animation = Animation.get(player);
        if (animation == null) {
            return;
        }
        animation.setAnimator(new RideZiplineAnimator());
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        Animation animation = Animation.get(player);
        if (animation == null) {
            return;
        }
        animation.setAnimator(new RideZiplineAnimator());
    }

    @Override
    public void onStart(Player player, Parkourability parkourability, ByteBuffer startData) {
        this.previouslyStopByCollision = false;
        this.endOffsetFromStart = BufferUtil.getVec3(startData);
        player.m_6858_(false);
        parkourability.getBehaviorEnforcer().addMarkerCancellingFallFlying(ID_FALL_FLY_CANCEL, this::isDoing);
    }

    @Override
    public void onWorkingTickInLocalClient(Player player, Parkourability parkourability, IStamina stamina) {
        if (this.ridingZipline == null) {
            return;
        }
        AttributeInstance speedAttr = player.m_21051_(Attributes.f_22279_);
        if (speedAttr == null) {
            return;
        }
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer localPlayer = (LocalPlayer)player;
        double oldSpeed = this.speed;
        Zipline zipline = this.ridingZipline.getZipline();
        double gravity = player.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        this.slope = zipline.getSlope(this.currentT);
        this.speed *= 0.98;
        if (player.m_20069_()) {
            this.speed *= 0.8;
        }
        this.speed -= gravity * this.slope * Mth.m_14193_((double)(this.slope * this.slope + 1.0));
        Vec3 input = new Vec3((double)(-localPlayer.f_108618_.f_108566_), 0.0, (double)localPlayer.f_108618_.f_108567_);
        Vec3 offset = zipline.getOffsetToEndFromStart();
        if (input.m_82556_() > 0.01) {
            double dot = player.m_20154_().m_82524_((float)Math.toRadians(VectorUtil.toYawDegree(input))).m_82542_(1.0, 0.0, 1.0).m_82541_().m_82526_(new Vec3(offset.m_7096_(), 0.0, offset.m_7094_()).m_82541_());
            this.speed += Math.min(dot * 0.01 * (speedAttr.m_22135_() / speedAttr.m_22115_()), 0.08);
        }
        this.currentT = (float)zipline.getMovedPositionByParameterApproximately(this.currentT, (float)this.speed);
        this.acceleration = this.speed - oldSpeed;
        this.currentPos = zipline.getMidPoint(this.currentT);
    }

    private void rideNewZipline(ZiplineRopeEntity ziplineRopeEntity, Vec3 position, Vec3 deltaMovement) {
        this.ridingZipline = ziplineRopeEntity;
        Zipline zipline = ziplineRopeEntity.getZipline();
        this.acceleration = 0.0;
        this.currentT = Mth.m_14036_((float)zipline.getParameter(position), (float)0.0f, (float)1.0f);
        this.currentPos = zipline.getMidPoint(this.currentT);
        this.slope = zipline.getSlope(this.currentT);
        float yScale = (float)this.slope;
        Vec3 pointsOffset = zipline.getOffsetToEndFromStart();
        double xzLenInvSqrt = Mth.m_14193_((double)(pointsOffset.m_7096_() * pointsOffset.m_7096_() + pointsOffset.m_7094_() * pointsOffset.m_7094_()));
        double xScale = pointsOffset.m_7096_() * xzLenInvSqrt;
        double zScale = pointsOffset.m_7094_() * xzLenInvSqrt;
        Vec3 speedScale = new Vec3(xScale, (double)yScale, zScale).m_82541_();
        this.speed = deltaMovement.m_82526_(speedScale);
    }

    private static Vec3 getDeltaMovement(Zipline zipline, double speed, float currentT) {
        float yScale = zipline.getSlope(currentT);
        Vec3 pointsOffset = zipline.getOffsetToEndFromStart();
        double xzLenInvSqrt = Mth.m_14193_((double)(pointsOffset.m_7096_() * pointsOffset.m_7096_() + pointsOffset.m_7094_() * pointsOffset.m_7094_()));
        double xScale = pointsOffset.m_7096_() * xzLenInvSqrt;
        double zScale = pointsOffset.m_7094_() * xzLenInvSqrt;
        Vec3 speedScale = new Vec3(xScale, (double)yScale, zScale).m_82541_();
        return speedScale.m_82490_(speed);
    }

    @Override
    public void saveSynchronizedState(ByteBuffer buffer) {
        buffer.putDouble(this.acceleration);
        buffer.putDouble(this.slope);
    }

    @Override
    public void restoreSynchronizedState(ByteBuffer buffer) {
        this.acceleration = buffer.getDouble();
        this.slope = buffer.getDouble();
    }

    @Override
    public void onWorkingTick(Player player, Parkourability parkourability, IStamina stamina) {
        player.f_19789_ = 0.0f;
        player.m_20256_(Vec3.f_82478_);
    }

    @Override
    public void onStopInLocalClient(Player player) {
        if (this.ridingZipline != null) {
            player.m_20256_(RideZipline.getDeltaMovement(this.ridingZipline.getZipline(), this.speed, this.currentT).m_82520_(0.0, KeyBindings.isKeyJumpDown() != false ? 0.25 : 0.0, 0.0));
        }
        this.currentT = 0.0f;
        this.currentPos = null;
        this.acceleration = 0.0;
        this.speed = 0.0;
        this.slope = 0.0;
    }

    @Override
    public void onStop(Player player) {
        this.ridingZipline = null;
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }
}

