/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.zipline;

import com.alrex.parcool.common.entity.zipline.ZiplineRopeEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class Zipline {
    public static final double MAXIMUM_HORIZONTAL_DISTANCE = 115.0;
    public static final double MAXIMUM_VERTICAL_DISTANCE = 58.65;
    private final Vec3 startPos;
    private final Vec3 endPos;
    private final Vec3 endOffsetFromStart;
    private final double horizontalDistance;

    protected Zipline(Vec3 point1, Vec3 point2) {
        if (point1.m_7098_() <= point2.m_7098_()) {
            this.startPos = point1;
            this.endPos = point2;
        } else {
            this.startPos = point2;
            this.endPos = point1;
        }
        this.endOffsetFromStart = this.endPos.m_82546_(this.startPos);
        this.horizontalDistance = Math.hypot(this.endOffsetFromStart.m_7096_(), this.endOffsetFromStart.m_7094_());
    }

    public Vec3 getStartPos() {
        return this.startPos;
    }

    public Vec3 getEndPos() {
        return this.endPos;
    }

    public Vec3 getOffsetToEndFromStart() {
        return this.endOffsetFromStart;
    }

    public double getHorizontalDistance() {
        return this.horizontalDistance;
    }

    @Nullable
    public static ZiplineRopeEntity getHangableZipline(Level world, Player player) {
        return Zipline.getHangableZipline(world, player, null);
    }

    @Nullable
    public static ZiplineRopeEntity getHangableZipline(Level world, Player player, @Nullable ZiplineRopeEntity except) {
        double d = 60.800000000000004;
        List entities = world.m_45976_(ZiplineRopeEntity.class, player.m_142469_().m_82377_(60.800000000000004, 59.65, 60.800000000000004));
        double catchRange = (double)player.m_20205_() * 0.6;
        double yDeltaMovement = player.m_20184_().m_7098_();
        double yDistanceScale = Mth.m_14008_((double)(catchRange / yDeltaMovement), (double)0.4, (double)1.0);
        Vec3 grabPos = player.m_20182_().m_82520_(0.0, (double)player.m_20206_() * 1.11 + Mth.m_14008_((double)(yDeltaMovement * (double)0.4f), (double)((double)player.m_20206_() * -0.4), (double)((double)player.m_20206_() * 0.4)), 0.0);
        for (ZiplineRopeEntity ziplineEntity : entities) {
            double distSqr;
            Zipline zipline;
            if (except == ziplineEntity || ziplineEntity.getStartPos().equals((Object)BlockPos.f_121853_) && ziplineEntity.getEndPos().equals((Object)BlockPos.f_121853_) || !(zipline = ziplineEntity.getZipline()).isPossiblyHangable(grabPos) || !((distSqr = zipline.getSquaredDistanceApproximately(grabPos, yDistanceScale)) < catchRange * catchRange)) continue;
            return ziplineEntity;
        }
        return null;
    }

    public boolean conflictsWithSomething(Level world) {
        int count = (int)Math.floor(this.getHorizontalDistance());
        for (int i = 1; i < count - 1; ++i) {
            Vec3 midPoint = this.getMidPoint((float)i / (float)count);
            double d = 0.2;
            if (world.m_45772_(new AABB(midPoint.m_82492_(0.2, 0.2, 0.2), midPoint.m_82520_(0.2, 0.2, 0.2)))) continue;
            return true;
        }
        return false;
    }

    public Vec3 getMidPoint(float t) {
        return this.getMidPointOffsetFromStart(t).m_82549_(this.getStartPos());
    }

    public abstract Vec3 getMidPointOffsetFromStart(float var1);

    public abstract float getSlope(float var1);

    public abstract float getParameter(Vec3 var1);

    public abstract double getMovedPositionByParameterApproximately(float var1, float var2);

    public double getSquaredDistanceApproximately(Vec3 position) {
        return this.getSquaredDistanceApproximately(position, 1.0);
    }

    public abstract double getSquaredDistanceApproximately(Vec3 var1, double var2);

    public abstract boolean isPossiblyHangable(Vec3 var1);
}

