/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.api.unstable.action.ParCoolActionEvent;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.attachment.Attachments;
import com.alrex.parcool.common.attachment.client.Animation;
import com.alrex.parcool.common.attachment.client.LocalStamina;
import com.alrex.parcool.common.attachment.common.Parkourability;
import com.alrex.parcool.common.attachment.common.ReadonlyStamina;
import com.alrex.parcool.common.network.payload.ActionStatePayload;
import com.alrex.parcool.config.ParCoolConfig;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Level;

public class ActionProcessor {
    private static final ResourceLocation STAMINA_DEPLETED_SLOWNESS_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"exhausted.speed");
    private static final AttributeModifier STAMINA_DEPLETED_SLOWNESS_MODIFIER = new AttributeModifier(STAMINA_DEPLETED_SLOWNESS_MODIFIER_ID, -0.05, AttributeModifier.Operation.ADD_VALUE);
    private final ByteBuffer bufferOfPostState = ByteBuffer.allocate(128);
    private final ByteBuffer bufferOfPreState = ByteBuffer.allocate(128);
    private final ByteBuffer bufferOfStarting = ByteBuffer.allocate(128);
    private int staminaSyncCoolTimeTick = 0;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onTickInClient(PlayerTickEvent.Post event) {
        if (!event.getEntity().level().isClientSide()) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntity();
        Animation animation = Animation.get((Player)player);
        if (animation == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        animation.tick(player, parkourability);
    }

    @SubscribeEvent
    public void onTick(PlayerTickEvent.Pre event) {
        AttributeInstance attr;
        LocalPlayer localPlayer;
        LocalStamina stamina;
        boolean needSync;
        Player player = event.getEntity();
        Parkourability parkourability = Parkourability.get(player);
        List<Action> actions = parkourability.getList();
        boolean bl = needSync = player.level().isClientSide() && player.isLocalPlayer();
        if (needSync && !(stamina = LocalStamina.get((LocalPlayer)player)).isAvailable()) {
            return;
        }
        LinkedList<ActionStatePayload.Entry> syncStates = new LinkedList<ActionStatePayload.Entry>();
        if (needSync && player.tickCount > 100 && player.tickCount % 150 == 0 && parkourability.limitationIsNotSynced() && player instanceof LocalPlayer) {
            localPlayer = (LocalPlayer)player;
            int trialCount = parkourability.getSynchronizeTrialCount();
            if (trialCount < 5) {
                parkourability.trySyncLimitation(localPlayer, parkourability);
                if (ParCoolConfig.Client.Booleans.ShowAutoResynchronizationNotification.get().booleanValue()) {
                    player.displayClientMessage((Component)Component.translatable((String)"parcool.message.error.limitation.not_synced"), false);
                }
                ParCool.LOGGER.log(Level.WARN, "Detected ParCool Limitation is not synced. Sending synchronization request...");
            } else if (trialCount == 5) {
                parkourability.incrementSynchronizeTrialCount();
                player.displayClientMessage((Component)Component.translatable((String)"parcool.message.error.limitation.fail_sync").withStyle(ChatFormatting.DARK_RED), false);
                ParCool.LOGGER.log(Level.ERROR, "Failed to synchronize ParCool Limitation. There may be problems about server connection. Please report to the developer after checking connection");
            }
        }
        parkourability.getAdditionalProperties().onTick(player, parkourability);
        block0: for (Action action : actions) {
            StaminaConsumeTiming timing = action.getStaminaConsumeTiming();
            if (needSync) {
                this.bufferOfPreState.clear();
                action.saveSynchronizedState(this.bufferOfPreState);
                this.bufferOfPreState.flip();
            }
            action.tick();
            action.onTick(player, parkourability);
            if (player.level().isClientSide()) {
                action.onClientTick(player, parkourability);
            } else {
                action.onServerTick(player, parkourability);
            }
            if (player.isLocalPlayer()) {
                if (action.isDoing()) {
                    boolean canContinue;
                    boolean bl2 = canContinue = parkourability.getActionInfo().can(action.getClass()) && !((ReadonlyStamina)player.getData(Attachments.STAMINA)).isExhausted() && !((ParCoolActionEvent.TryToContinueEvent)NeoForge.EVENT_BUS.post((Event)new ParCoolActionEvent.TryToContinueEvent(player, action))).isCanceled() && action.canContinue(player, parkourability);
                    if (!canContinue) {
                        action.finish();
                        action.onStopInLocalClient(player);
                        action.onStop(player);
                        NeoForge.EVENT_BUS.post((Event)new ParCoolActionEvent.StopEvent(player, action));
                        syncStates.addLast(new ActionStatePayload.Entry(action.getClass(), ActionStatePayload.Entry.Type.Finish, new byte[0]));
                    }
                } else {
                    this.bufferOfStarting.clear();
                    boolean start = !player.isSpectator() && parkourability.getActionInfo().can(action.getClass()) && !((ReadonlyStamina)player.getData(Attachments.STAMINA)).isExhausted() && !((ParCoolActionEvent.TryToStartEvent)NeoForge.EVENT_BUS.post((Event)new ParCoolActionEvent.TryToStartEvent(player, action))).isCanceled() && action.canStart(player, parkourability, this.bufferOfStarting);
                    this.bufferOfStarting.flip();
                    if (start) {
                        action.start();
                        action.onStart(player, parkourability, this.bufferOfStarting);
                        this.bufferOfStarting.rewind();
                        action.onStartInLocalClient(player, parkourability, this.bufferOfStarting);
                        this.bufferOfStarting.rewind();
                        NeoForge.EVENT_BUS.post((Event)new ParCoolActionEvent.StartEvent(player, action));
                        byte[] data = new byte[this.bufferOfStarting.remaining()];
                        this.bufferOfStarting.get(data);
                        syncStates.addLast(new ActionStatePayload.Entry(action.getClass(), ActionStatePayload.Entry.Type.Start, data));
                        if (timing == StaminaConsumeTiming.OnStart && player instanceof LocalPlayer) {
                            LocalPlayer localPlayer2 = (LocalPlayer)player;
                            LocalStamina stamina2 = LocalStamina.get(localPlayer2);
                            stamina2.consume(localPlayer2, parkourability.getActionInfo().getStaminaConsumptionOf(action.getClass()));
                        }
                    }
                }
            }
            if (action.isDoing()) {
                action.onWorkingTick(player, parkourability);
                if (player.level().isClientSide()) {
                    action.onWorkingTickInClient(player, parkourability);
                    if (player.isLocalPlayer()) {
                        action.onWorkingTickInLocalClient(player, parkourability);
                        if (timing == StaminaConsumeTiming.OnWorking && player instanceof LocalPlayer) {
                            LocalPlayer localPlayer3 = (LocalPlayer)player;
                            LocalStamina stamina3 = LocalStamina.get(localPlayer3);
                            stamina3.consume(localPlayer3, parkourability.getActionInfo().getStaminaConsumptionOf(action.getClass()));
                        }
                    }
                } else {
                    action.onWorkingTickInServer(player, parkourability);
                }
            }
            if (!needSync) continue;
            this.bufferOfPostState.clear();
            action.saveSynchronizedState(this.bufferOfPostState);
            this.bufferOfPostState.flip();
            if (this.bufferOfPostState.limit() == this.bufferOfPreState.limit()) {
                while (this.bufferOfPreState.hasRemaining()) {
                    if (this.bufferOfPostState.get() == this.bufferOfPreState.get()) continue;
                    this.bufferOfPostState.rewind();
                    byte[] data = new byte[this.bufferOfPostState.remaining()];
                    this.bufferOfPostState.get(data);
                    syncStates.addLast(new ActionStatePayload.Entry(action.getClass(), ActionStatePayload.Entry.Type.Normal, data));
                    continue block0;
                }
                continue;
            }
            this.bufferOfPostState.rewind();
            byte[] data = new byte[this.bufferOfPostState.remaining()];
            this.bufferOfPostState.get(data);
            syncStates.addLast(new ActionStatePayload.Entry(action.getClass(), ActionStatePayload.Entry.Type.Normal, data));
        }
        if (needSync) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ActionStatePayload(player.getUUID(), syncStates), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (!parkourability.limitationIsNotSynced() && player instanceof LocalPlayer) {
                localPlayer = (LocalPlayer)player;
                LocalStamina stamina4 = LocalStamina.get(localPlayer);
                ++this.staminaSyncCoolTimeTick;
                if (this.staminaSyncCoolTimeTick > 5) {
                    this.staminaSyncCoolTimeTick = 0;
                    stamina4.sync(localPlayer);
                }
                stamina4.onTick(localPlayer);
            }
        }
        if (!player.level().isClientSide() && (attr = player.getAttribute(Attributes.MOVEMENT_SPEED)) != null) {
            ReadonlyStamina readonlyStamina = (ReadonlyStamina)player.getData(Attachments.STAMINA);
            if (readonlyStamina.isExhausted() && parkourability.getClientInfo().get(ParCoolConfig.Client.Booleans.EnableStaminaExhaustionPenalty).booleanValue()) {
                player.setSprinting(false);
                if (!attr.hasModifier(STAMINA_DEPLETED_SLOWNESS_MODIFIER_ID)) {
                    attr.addTransientModifier(STAMINA_DEPLETED_SLOWNESS_MODIFIER);
                }
            } else {
                attr.removeModifier(STAMINA_DEPLETED_SLOWNESS_MODIFIER_ID);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderTick(RenderFrameEvent.Pre event) {
        LocalPlayer clientPlayer = Minecraft.getInstance().player;
        if (clientPlayer == null) {
            return;
        }
        for (Player player : clientPlayer.getCommandSenderWorld().players()) {
            Parkourability parkourability = Parkourability.get(player);
            if (parkourability == null) {
                return;
            }
            List<Action> actions = parkourability.getList();
            for (Action action : actions) {
                action.onRenderTick((RenderFrameEvent)event, player, parkourability);
            }
            Animation animation = Animation.get(player);
            if (animation == null) {
                return;
            }
            animation.onRenderTick((RenderFrameEvent)event, player, parkourability);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onViewRender(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        Animation animation = Animation.get((Player)player);
        if (animation == null) {
            return;
        }
        animation.cameraSetup(event, player, parkourability);
    }
}

