/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability;

import com.alrex.parcool.common.capability.capabilities.Capabilities;
import com.alrex.parcool.common.capability.stamina.HungerStamina;
import com.alrex.parcool.common.capability.stamina.ParCoolStamina;
import com.alrex.parcool.extern.AdditionalMods;
import com.alrex.parcool.extern.epicfight.EpicFightStamina;
import com.alrex.parcool.extern.feathers.FeathersStamina;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;

public interface IStamina {
    @Nullable
    public static IStamina get(Player player) {
        LazyOptional optional = player.getCapability(Capabilities.STAMINA_CAPABILITY);
        return (IStamina)optional.orElse(null);
    }

    public int getActualMaxStamina();

    public int get();

    public int getOldValue();

    public void consume(int var1);

    public void recover(int var1);

    public boolean isExhausted();

    public void setExhaustion(boolean var1);

    public void tick();

    public void set(int var1);

    default public void updateOldValue() {
    }

    default public boolean isImposingExhaustionPenalty() {
        return this.isExhausted();
    }

    default public boolean wantToConsumeOnServer() {
        return false;
    }

    default public int getRequestedValueConsumedOnServer() {
        return 0;
    }

    public static enum Type {
        Default(ParCoolStamina.class, ParCoolStamina::new, null),
        Hunger(HungerStamina.class, HungerStamina::new, HungerStamina::consumeOnServer),
        Feathers(FeathersStamina.class, AdditionalMods.feathers()::newFeathersStaminaFor, null),
        EpicFight(EpicFightStamina.class, AdditionalMods.epicFight()::newFeathersStaminaFor, EpicFightStamina::consumeOnServer);

        private final Function<Player, IStamina> constructor;
        private final Class<? extends IStamina> clazz;
        @Nullable
        private final BiConsumer<ServerPlayer, Integer> serverStaminaHandler;

        private Type(Class<? extends IStamina> clazz, Function<Player, IStamina> constructor, BiConsumer<ServerPlayer, Integer> serverStaminaHandler) {
            this.constructor = constructor;
            this.clazz = clazz;
            this.serverStaminaHandler = serverStaminaHandler;
        }

        public IStamina newInstance(Player player) {
            return this.constructor.apply(player);
        }

        public void handleConsumeOnServer(ServerPlayer player, int value) {
            if (this.serverStaminaHandler != null) {
                this.serverStaminaHandler.accept(player, value);
            }
        }

        public static Type getFromInstance(IStamina stamina) {
            for (Type type : Type.values()) {
                if (!type.clazz.isAssignableFrom(stamina.getClass())) continue;
                return type;
            }
            return null;
        }
    }
}

