/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.extern;

import com.alrex.parcool.extern.ModManager;
import com.alrex.parcool.extern.betterthirdperson.BetterThirdPersonManager;
import com.alrex.parcool.extern.epicfight.EpicFightManager;
import com.alrex.parcool.extern.feathers.FeathersManager;
import com.alrex.parcool.extern.shouldersurfing.ShoulderSurfingManager;
import java.util.Arrays;
import java.util.function.Supplier;

public enum AdditionalMods {
    FEATHERS(FeathersManager::new),
    EPIC_FIGHT(EpicFightManager::new),
    BETTER_THIRD_PERSON(BetterThirdPersonManager::new),
    SHOULDER_SURFING(ShoulderSurfingManager::new);

    private final ModManager manager;

    private AdditionalMods(Supplier<ModManager> supplier) {
        this.manager = supplier.get();
    }

    public static BetterThirdPersonManager betterThirdPerson() {
        return (BetterThirdPersonManager)AdditionalMods.BETTER_THIRD_PERSON.manager;
    }

    public static ShoulderSurfingManager shoulderSurfing() {
        return (ShoulderSurfingManager)AdditionalMods.SHOULDER_SURFING.manager;
    }

    public static FeathersManager feathers() {
        return (FeathersManager)AdditionalMods.FEATHERS.manager;
    }

    public static EpicFightManager epicFight() {
        return (EpicFightManager)AdditionalMods.EPIC_FIGHT.manager;
    }

    public ModManager get() {
        return this.manager;
    }

    public static void init() {
        Arrays.stream(AdditionalMods.values()).map(AdditionalMods::get).forEach(ModManager::init);
    }

    public static void initInClient() {
        Arrays.stream(AdditionalMods.values()).map(AdditionalMods::get).forEach(ModManager::initInClient);
    }

    public static void initInDedicatedServer() {
        Arrays.stream(AdditionalMods.values()).map(AdditionalMods::get).forEach(ModManager::initInDedicatedServer);
    }

    public static boolean isCameraDecoupled() {
        return AdditionalMods.shoulderSurfing().isCameraDecoupled() != false || AdditionalMods.betterThirdPerson().isCameraDecoupled();
    }
}

