/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.stackablecuring.dependencies.stackablecuring.colosseum.i18n;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.annotations.NotNull;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.annotations.Nullable;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.colosseum.ColosseumPlugin;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.colosseum.i18n.ColosseumI18nManager;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.colosseum.i18n.ColosseumI18nManagerBuilder$loadExternalLanguageFiles$1$1$hashMapType$1;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.colosseum.i18n.ColosseumI18nManagerBuilder$parseLanguageFromJar$1$mapType$1;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.Metadata;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.Pair;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.collections.CollectionsKt;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.collections.MapsKt;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.io.CloseableKt;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.io.FilesKt;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.io.TextStreamsKt;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.functions.Function0;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.Intrinsics;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.SourceDebugExtension;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.sequences.SequencesKt;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.text.Charsets;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0007J\u001f\u0010\u0014\u001a\u00020\u00002\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0016\"\u00020\u0007\u00a2\u0006\u0002\u0010\u0017JO\u0010\u0018\u001a\u00020\u00002B\u0010\u0015\u001a\"\u0012\u001e\b\u0001\u0012\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\u00190\u0016\"\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\u0019\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007J(\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00072\u0018\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0007J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ0\u0010%\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\u00192\u0006\u0010&\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J(\u0010'\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\t2\u0006\u0010&\u001a\u00020\u0007H\u0002J\u0006\u0010(\u001a\u00020)R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u000b\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\f0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/i18n/ColosseumI18nManagerBuilder;", "", "plugin", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/ColosseumPlugin;", "<init>", "(Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/ColosseumPlugin;)V", "defaultLanguage", "", "staticLanguages", "", "", "dynamicLanguages", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/Function0;", "forceLanguage", "languagesToLower", "", "setDefaultLocale", "defaultLocale", "loadInternalLanguageDirectory", "directory", "loadInternalLanguages", "languages", "", "([Ljava/lang/String;)Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/i18n/ColosseumI18nManagerBuilder;", "addStaticLanguage", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/Pair;", "([Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/Pair;)Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/i18n/ColosseumI18nManagerBuilder;", "loadExternalLanguageFiles", "langFile", "Ljava/io/File;", "name", "baseLangFile", "addDynamicLanguage", "lang", "fetchLang", "language", "setLanguagesToLower", "parseLanguageFromJar", "path", "parseLanguageDirectoryFromJar", "build", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/i18n/ColosseumI18nManager;", "Colosseum"})
@SourceDebugExtension(value={"SMAP\nColosseumI18nManagerBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColosseumI18nManagerBuilder.kt\nme/spartacus04/colosseum/i18n/ColosseumI18nManagerBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n13805#2,2:189\n747#3,4:191\n478#4:195\n424#4:196\n478#4:201\n424#4:202\n1252#5,4:197\n1252#5,4:203\n*S KotlinDebug\n*F\n+ 1 ColosseumI18nManagerBuilder.kt\nme/spartacus04/colosseum/i18n/ColosseumI18nManagerBuilder\n*L\n49#1:189,2\n162#1:191,4\n176#1:195\n176#1:196\n177#1:201\n177#1:202\n176#1:197,4\n177#1:203,4\n*E\n"})
public final class ColosseumI18nManagerBuilder {
    @NotNull
    private final ColosseumPlugin plugin;
    @NotNull
    private String defaultLanguage;
    @NotNull
    private Map<String, Map<String, String>> staticLanguages;
    @NotNull
    private Map<String, Function0<Map<String, String>>> dynamicLanguages;
    @Nullable
    private String forceLanguage;
    private boolean languagesToLower;

    public ColosseumI18nManagerBuilder(@NotNull ColosseumPlugin colosseumPlugin) {
        Intrinsics.checkNotNullParameter((Object)colosseumPlugin, "plugin");
        this.plugin = colosseumPlugin;
        this.defaultLanguage = "en_US";
        this.staticLanguages = new LinkedHashMap();
        this.dynamicLanguages = new LinkedHashMap();
        this.languagesToLower = true;
    }

    @NotNull
    public final ColosseumI18nManagerBuilder setDefaultLocale(@NotNull String string) {
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder;
        Intrinsics.checkNotNullParameter(string, "defaultLocale");
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder2 = colosseumI18nManagerBuilder = this;
        colosseumI18nManagerBuilder.defaultLanguage = string;
        return colosseumI18nManagerBuilder;
    }

    @NotNull
    public final ColosseumI18nManagerBuilder loadInternalLanguageDirectory(@NotNull String string) {
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder;
        Intrinsics.checkNotNullParameter(string, "directory");
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder2 = colosseumI18nManagerBuilder = this;
        colosseumI18nManagerBuilder.staticLanguages.putAll(colosseumI18nManagerBuilder2.parseLanguageDirectoryFromJar(string));
        return colosseumI18nManagerBuilder;
    }

    @NotNull
    public final ColosseumI18nManagerBuilder loadInternalLanguages(String ... stringArray) {
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder;
        Intrinsics.checkNotNullParameter(stringArray, "languages");
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder2 = colosseumI18nManagerBuilder = this;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = string = stringArray[i];
            Pair<String, Map<String, String>> object = colosseumI18nManagerBuilder2.parseLanguageFromJar(string2 + ".json", string2);
            colosseumI18nManagerBuilder2.staticLanguages.put(object.getFirst(), object.getSecond());
        }
        return colosseumI18nManagerBuilder;
    }

    @NotNull
    public final ColosseumI18nManagerBuilder addStaticLanguage(Pair<String, ? extends Map<String, String>> ... pairArray) {
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder;
        Intrinsics.checkNotNullParameter(pairArray, "languages");
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder2 = colosseumI18nManagerBuilder = this;
        MapsKt.putAll(colosseumI18nManagerBuilder.staticLanguages, pairArray);
        return colosseumI18nManagerBuilder;
    }

    @NotNull
    public final ColosseumI18nManagerBuilder loadExternalLanguageFiles(@NotNull File file, @NotNull String string, @NotNull String string2) {
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder;
        Intrinsics.checkNotNullParameter(file, "langFile");
        Intrinsics.checkNotNullParameter(string, "name");
        Intrinsics.checkNotNullParameter(string2, "baseLangFile");
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder2 = colosseumI18nManagerBuilder = this;
        colosseumI18nManagerBuilder.dynamicLanguages.put(string, () -> ColosseumI18nManagerBuilder.loadExternalLanguageFiles$lambda$0$0(file, colosseumI18nManagerBuilder2, string2));
        return colosseumI18nManagerBuilder;
    }

    @NotNull
    public final ColosseumI18nManagerBuilder addDynamicLanguage(@NotNull String string, @NotNull Function0<? extends Map<String, String>> function0) {
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder;
        Intrinsics.checkNotNullParameter(string, "lang");
        Intrinsics.checkNotNullParameter(function0, "fetchLang");
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder2 = colosseumI18nManagerBuilder = this;
        colosseumI18nManagerBuilder.dynamicLanguages.put(string, function0);
        return colosseumI18nManagerBuilder;
    }

    @NotNull
    public final ColosseumI18nManagerBuilder forceLanguage(@NotNull String string) {
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder;
        Intrinsics.checkNotNullParameter(string, "language");
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder2 = colosseumI18nManagerBuilder = this;
        colosseumI18nManagerBuilder.forceLanguage = string;
        return colosseumI18nManagerBuilder;
    }

    @NotNull
    public final ColosseumI18nManagerBuilder setLanguagesToLower(boolean bl) {
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder;
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder2 = colosseumI18nManagerBuilder = this;
        colosseumI18nManagerBuilder.languagesToLower = bl;
        return colosseumI18nManagerBuilder;
    }

    private final Pair<String, Map<String, String>> parseLanguageFromJar(String object, String pair) {
        InputStream inputStream = this.plugin.getResource((String)object);
        Intrinsics.checkNotNull(inputStream);
        object = inputStream;
        Object object2 = Charsets.UTF_8;
        Object object3 = new InputStreamReader((InputStream)object, (Charset)object2);
        object = new BufferedReader((Reader)object3, 8192);
        object2 = null;
        try {
            object3 = (BufferedReader)object;
            Type type = new ColosseumI18nManagerBuilder$parseLanguageFromJar$1$mapType$1().getType();
            Object t = ColosseumPlugin.Companion.getGSON().fromJson(TextStreamsKt.readText((Reader)object3), type);
            Intrinsics.checkNotNullExpressionValue(t, "fromJson(...)");
            object3 = (Map)t;
            pair = new Pair<Object, Object>(pair, object3);
        }
        catch (Throwable throwable) {
            try {
                pair = throwable;
                object2 = throwable;
                throw pair;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally((Closeable)object, null);
        return pair;
    }

    private final Map<String, Map<String, String>> parseLanguageDirectoryFromJar(String object) {
        Object object2;
        String string = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
        Closeable closeable = new JarFile(StringsKt.replace$default(string, "%20", " ", false, 4, null));
        closeable = closeable;
        Throwable throwable = null;
        try {
            object2 = closeable;
            Enumeration<JarEntry> enumeration = ((JarFile)object2).entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, "entries(...)");
            object = SequencesKt.map(SequencesKt.filter(SequencesKt.asSequence(CollectionsKt.iterator(enumeration)), arg_0 -> ColosseumI18nManagerBuilder.parseLanguageDirectoryFromJar$lambda$0$0((String)object, arg_0)), arg_0 -> ColosseumI18nManagerBuilder.parseLanguageDirectoryFromJar$lambda$0$1((String)object, this, arg_0));
            object2 = new LinkedHashMap();
            object = object.iterator();
            while (object.hasNext()) {
                Object object3 = object.next();
                Object object4 = object2;
                object3 = (Pair)object3;
                object4.put(((Pair)object3).getFirst(), ((Pair)object3).getSecond());
            }
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally(closeable, throwable);
                throw throwable3;
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return object2;
    }

    @NotNull
    public final ColosseumI18nManager build() {
        if (this.languagesToLower) {
            Object object;
            Object object2;
            Map.Entry entry;
            Object object3;
            String string = this.defaultLanguage.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            this.defaultLanguage = string;
            ColosseumI18nManagerBuilder colosseumI18nManagerBuilder = this;
            Map map = colosseumI18nManagerBuilder.staticLanguages;
            ColosseumI18nManagerBuilder colosseumI18nManagerBuilder2 = colosseumI18nManagerBuilder;
            Iterator iterator2 = map;
            map = new LinkedHashMap(MapsKt.mapCapacity(map.size()));
            iterator2 = iterator2.entrySet();
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                object3 = iterator2.next();
                entry = (Map.Entry)object3;
                object2 = map;
                String string2 = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                object3 = (Map.Entry)object3;
                object = object2 = string2;
                entry = object3.getValue();
                object.put(object2, entry);
            }
            colosseumI18nManagerBuilder2.staticLanguages = MapsKt.toMutableMap(map);
            ColosseumI18nManagerBuilder colosseumI18nManagerBuilder3 = this;
            map = colosseumI18nManagerBuilder3.dynamicLanguages;
            colosseumI18nManagerBuilder2 = colosseumI18nManagerBuilder3;
            iterator2 = map;
            map = new LinkedHashMap(MapsKt.mapCapacity(map.size()));
            iterator2 = iterator2.entrySet();
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                object3 = iterator2.next();
                entry = (Map.Entry)object3;
                object2 = map;
                String string3 = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                object3 = (Map.Entry)object3;
                object = object2 = string3;
                entry = object3.getValue();
                object.put(object2, entry);
            }
            colosseumI18nManagerBuilder2.dynamicLanguages = MapsKt.toMutableMap(map);
        }
        return new ColosseumI18nManager(this.staticLanguages, this.dynamicLanguages, this.defaultLanguage, this.forceLanguage, this.plugin);
    }

    private static final Map loadExternalLanguageFiles$lambda$0$0(File object, ColosseumI18nManagerBuilder object2, String object3) {
        Reader reader;
        Type type = new ColosseumI18nManagerBuilder$loadExternalLanguageFiles$1$1$hashMapType$1().getType();
        if (!((File)object).exists()) {
            InputStream inputStream = ((ColosseumI18nManagerBuilder)object2).plugin.getResource((String)object3);
            Intrinsics.checkNotNull(inputStream);
            object2 = inputStream;
            object3 = Charsets.UTF_8;
            reader = new InputStreamReader((InputStream)object2, (Charset)object3);
            object2 = new BufferedReader(reader, 8192);
            object3 = null;
            try {
                reader = (BufferedReader)object2;
                ((File)object).createNewFile();
                FilesKt.writeText$default((File)object, TextStreamsKt.readText(reader), null, 2, null);
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    object3 = throwable;
                    throw object;
                }
                catch (Throwable throwable2) {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                    throw throwable2;
                }
            }
            CloseableKt.closeFinally((Closeable)object2, null);
        }
        object2 = object;
        object3 = Charsets.UTF_8;
        object = object2;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object3);
        object2 = new BufferedReader((Reader)object, 8192);
        object3 = null;
        try {
            reader = (BufferedReader)object2;
            Object t = ColosseumPlugin.Companion.getGSON().fromJson(TextStreamsKt.readText(reader), type);
            Intrinsics.checkNotNullExpressionValue(t, "fromJson(...)");
            object = (HashMap)t;
            object = (Map)object;
        }
        catch (Throwable throwable) {
            try {
                object = throwable;
                object3 = throwable;
                throw object;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                throw throwable3;
            }
        }
        CloseableKt.closeFinally((Closeable)object2, null);
        return object;
    }

    private static final boolean parseLanguageDirectoryFromJar$lambda$0$0(String string, JarEntry jarEntry) {
        String string2 = jarEntry.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        if (StringsKt.startsWith$default(string2, string, false, 2, null)) {
            String string3 = jarEntry.getName();
            Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
            if (StringsKt.endsWith$default(string3, ".json", false, 2, null)) {
                return true;
            }
        }
        return false;
    }

    private static final Pair parseLanguageDirectoryFromJar$lambda$0$1(String string, ColosseumI18nManagerBuilder colosseumI18nManagerBuilder, JarEntry object) {
        String string2 = ((ZipEntry)object).getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        object = StringsKt.replaceFirst$default(string2, string, "", false, 4, null);
        if (StringsKt.startsWith$default((String)object, "/", false, 2, null)) {
            String string3 = ((String)object).substring(1);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            object = string3;
        }
        return colosseumI18nManagerBuilder.parseLanguageFromJar(string + '/' + (String)object, StringsKt.replace$default((String)object, ".json", "", false, 4, null));
    }
}

