/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.stackablecuring.dependencies.stackablecuring.colosseum.logging;

import java.util.Arrays;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.annotations.NotNull;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.colosseum.ColosseumPlugin;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.colosseum.i18n.CommandSenderExtKt;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.colosseum.logging.MessageFormatter;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.Metadata;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.Pair;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005JG\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052*\u0010\u0018\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001a0\u0019\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001a\u00a2\u0006\u0002\u0010\u001bJG\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052*\u0010\u0018\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001a0\u0019\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001a\u00a2\u0006\u0002\u0010\u001bJG\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052*\u0010\u0018\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001a0\u0019\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001a\u00a2\u0006\u0002\u0010\u001bJG\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052*\u0010\u0018\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001a0\u0019\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001a\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/logging/PluginLogger;", "", "isDebug", "", "prefix", "", "<init>", "(ZLjava/lang/String;)V", "messageFormatter", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/logging/MessageFormatter;", "getMessageFormatter", "()Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/logging/MessageFormatter;", "confirm", "", "message", "info", "warn", "error", "url", "debug", "confirmI18n", "plugin", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/ColosseumPlugin;", "key", "placeholders", "", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/Pair;", "(Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/ColosseumPlugin;Ljava/lang/String;[Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/Pair;)V", "infoI18n", "warnI18n", "errorI18n", "Colosseum"})
public class PluginLogger {
    private final boolean isDebug;
    @NotNull
    private final MessageFormatter messageFormatter;

    public PluginLogger(boolean bl, @NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "prefix");
        this.isDebug = bl;
        this.messageFormatter = new MessageFormatter(string);
    }

    @NotNull
    public final MessageFormatter getMessageFormatter() {
        return this.messageFormatter;
    }

    public final void confirm(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "message");
        Bukkit.getConsoleSender().sendMessage(this.messageFormatter.confirm(string));
    }

    public final void info(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "message");
        Bukkit.getConsoleSender().sendMessage(this.messageFormatter.info(string));
    }

    public final void warn(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "message");
        Bukkit.getConsoleSender().sendMessage(this.messageFormatter.warn(string));
    }

    public final void error(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "message");
        Bukkit.getConsoleSender().sendMessage(this.messageFormatter.error(string));
    }

    public final void url(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "url");
        Bukkit.getConsoleSender().sendMessage(this.messageFormatter.url(string));
    }

    public final void debug(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "message");
        if (this.isDebug) {
            Bukkit.getConsoleSender().sendMessage(this.messageFormatter.debug(string));
        }
    }

    public final void confirmI18n(@NotNull ColosseumPlugin colosseumPlugin, @NotNull String string, Pair<String, String> ... pairArray) {
        Intrinsics.checkNotNullParameter((Object)colosseumPlugin, "plugin");
        Intrinsics.checkNotNullParameter(string, "key");
        Intrinsics.checkNotNullParameter(pairArray, "placeholders");
        ConsoleCommandSender consoleCommandSender = Bukkit.getConsoleSender();
        Intrinsics.checkNotNullExpressionValue(consoleCommandSender, "getConsoleSender(...)");
        CommandSenderExtKt.sendI18nConfirm((CommandSender)consoleCommandSender, colosseumPlugin, string, Arrays.copyOf(pairArray, pairArray.length));
    }

    public final void infoI18n(@NotNull ColosseumPlugin colosseumPlugin, @NotNull String string, Pair<String, String> ... pairArray) {
        Intrinsics.checkNotNullParameter((Object)colosseumPlugin, "plugin");
        Intrinsics.checkNotNullParameter(string, "key");
        Intrinsics.checkNotNullParameter(pairArray, "placeholders");
        ConsoleCommandSender consoleCommandSender = Bukkit.getConsoleSender();
        Intrinsics.checkNotNullExpressionValue(consoleCommandSender, "getConsoleSender(...)");
        CommandSenderExtKt.sendI18nInfo((CommandSender)consoleCommandSender, colosseumPlugin, string, Arrays.copyOf(pairArray, pairArray.length));
    }

    public final void warnI18n(@NotNull ColosseumPlugin colosseumPlugin, @NotNull String string, Pair<String, String> ... pairArray) {
        Intrinsics.checkNotNullParameter((Object)colosseumPlugin, "plugin");
        Intrinsics.checkNotNullParameter(string, "key");
        Intrinsics.checkNotNullParameter(pairArray, "placeholders");
        ConsoleCommandSender consoleCommandSender = Bukkit.getConsoleSender();
        Intrinsics.checkNotNullExpressionValue(consoleCommandSender, "getConsoleSender(...)");
        CommandSenderExtKt.sendI18nInfo((CommandSender)consoleCommandSender, colosseumPlugin, string, Arrays.copyOf(pairArray, pairArray.length));
    }

    public final void errorI18n(@NotNull ColosseumPlugin colosseumPlugin, @NotNull String string, Pair<String, String> ... pairArray) {
        Intrinsics.checkNotNullParameter((Object)colosseumPlugin, "plugin");
        Intrinsics.checkNotNullParameter(string, "key");
        Intrinsics.checkNotNullParameter(pairArray, "placeholders");
        ConsoleCommandSender consoleCommandSender = Bukkit.getConsoleSender();
        Intrinsics.checkNotNullExpressionValue(consoleCommandSender, "getConsoleSender(...)");
        CommandSenderExtKt.sendI18nInfo((CommandSender)consoleCommandSender, colosseumPlugin, string, Arrays.copyOf(pairArray, pairArray.length));
    }
}

