/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.stackablecuring.dependencies.stackablecuring.colosseum.scheduler.schedulersImpl.bukkit;

import me.spartacus04.stackablecuring.dependencies.stackablecuring.annotations.NotNull;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.colosseum.scheduler.schedulersImpl.bukkit.BukkitScheduledTask;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.colosseum.scheduler.scheduling.TaskScheduler;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.Metadata;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/scheduler/schedulersImpl/bukkit/BukkitScheduler;", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/scheduler/scheduling/TaskScheduler;", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "isGlobalThread", "", "isEntityThread", "entity", "Lorg/bukkit/entity/Entity;", "isRegionThread", "location", "Lorg/bukkit/Location;", "runTask", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/scheduler/schedulersImpl/bukkit/BukkitScheduledTask;", "runnable", "Ljava/lang/Runnable;", "runTaskLater", "delay", "", "runTaskTimer", "period", "runTaskAsynchronously", "runTaskLaterAsynchronously", "runTaskTimerAsynchronously", "execute", "", "cancelTasks", "Colosseum"})
public final class BukkitScheduler
extends TaskScheduler {
    @NotNull
    private final Plugin plugin;

    public BukkitScheduler(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
    }

    @Override
    public final boolean isGlobalThread() {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public final boolean isEntityThread(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public final boolean isRegionThread(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    @NotNull
    public final BukkitScheduledTask runTask(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTask(this.plugin, runnable);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTask(...)");
        return new BukkitScheduledTask(bukkitTask, false, 2, null);
    }

    @Override
    @NotNull
    public final BukkitScheduledTask runTaskLater(@NotNull Runnable runnable, long l) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTaskLater(this.plugin, runnable, l);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskLater(...)");
        return new BukkitScheduledTask(bukkitTask, false, 2, null);
    }

    @Override
    @NotNull
    public final BukkitScheduledTask runTaskTimer(@NotNull Runnable runnable, long l, long l2) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTaskTimer(this.plugin, runnable, l, l2);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimer(...)");
        return new BukkitScheduledTask(bukkitTask, false, 2, null);
    }

    @Override
    @NotNull
    public final BukkitScheduledTask runTaskAsynchronously(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, runnable);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskAsynchronously(...)");
        return new BukkitScheduledTask(bukkitTask, false, 2, null);
    }

    @Override
    @NotNull
    public final BukkitScheduledTask runTaskLaterAsynchronously(@NotNull Runnable runnable, long l) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTaskLaterAsynchronously(this.plugin, runnable, l);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskLaterAsynchronously(...)");
        return new BukkitScheduledTask(bukkitTask, false, 2, null);
    }

    @Override
    @NotNull
    public final BukkitScheduledTask runTaskTimerAsynchronously(@NotNull Runnable runnable, long l, long l2) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously(this.plugin, runnable, l, l2);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimerAsynchronously(...)");
        return new BukkitScheduledTask(bukkitTask, false, 2, null);
    }

    @Override
    public final void execute(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask(this.plugin, runnable);
    }

    @Override
    public final void cancelTasks() {
        this.plugin.getServer().getScheduler().cancelTasks(this.plugin);
    }

    @Override
    public final void cancelTasks(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        plugin.getServer().getScheduler().cancelTasks(plugin);
    }
}

