/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.internal.bind;

import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.errorprone.annotations.CanIgnoreReturnValue;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.JsonArray;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.JsonElement;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.JsonNull;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.JsonObject;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.JsonPrimitive;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.internal.bind.JsonTreeReader$1;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.stream.JsonReader;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.stream.JsonToken;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.stream.MalformedJsonException;

public final class JsonTreeReader
extends JsonReader {
    private static final Reader UNREADABLE_READER = new JsonTreeReader$1();
    private static final Object SENTINEL_CLOSED = new Object();
    private Object[] stack = new Object[32];
    private int stackSize = 0;
    private String[] pathNames = new String[32];
    private int[] pathIndices = new int[32];

    public JsonTreeReader(JsonElement jsonElement) {
        super(UNREADABLE_READER);
        this.push(jsonElement);
    }

    @Override
    public final void beginArray() {
        this.expect(JsonToken.BEGIN_ARRAY);
        JsonArray jsonArray = (JsonArray)this.peekStack();
        this.push(jsonArray.iterator());
        this.pathIndices[this.stackSize - 1] = 0;
    }

    @Override
    public final void endArray() {
        this.expect(JsonToken.END_ARRAY);
        this.popStack();
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
    }

    @Override
    public final void beginObject() {
        this.expect(JsonToken.BEGIN_OBJECT);
        JsonObject jsonObject = (JsonObject)this.peekStack();
        this.push(jsonObject.entrySet().iterator());
    }

    @Override
    public final void endObject() {
        this.expect(JsonToken.END_OBJECT);
        this.pathNames[this.stackSize - 1] = null;
        this.popStack();
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
    }

    @Override
    public final boolean hasNext() {
        JsonToken jsonToken = ((JsonReader)this).peek();
        return jsonToken != JsonToken.END_OBJECT && jsonToken != JsonToken.END_ARRAY && jsonToken != JsonToken.END_DOCUMENT;
    }

    @Override
    public final JsonToken peek() {
        Object object;
        block12: {
            boolean bl;
            while (true) {
                if (this.stackSize == 0) {
                    return JsonToken.END_DOCUMENT;
                }
                object = this.peekStack();
                if (!(object instanceof Iterator)) break block12;
                bl = this.stack[this.stackSize - 2] instanceof JsonObject;
                if (!(object = (Iterator)object).hasNext()) break;
                if (bl) {
                    return JsonToken.NAME;
                }
                this.push(object.next());
            }
            if (bl) {
                return JsonToken.END_OBJECT;
            }
            return JsonToken.END_ARRAY;
        }
        if (object instanceof JsonObject) {
            return JsonToken.BEGIN_OBJECT;
        }
        if (object instanceof JsonArray) {
            return JsonToken.BEGIN_ARRAY;
        }
        if (object instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)object;
            if (jsonPrimitive.isString()) {
                return JsonToken.STRING;
            }
            if (jsonPrimitive.isBoolean()) {
                return JsonToken.BOOLEAN;
            }
            if (jsonPrimitive.isNumber()) {
                return JsonToken.NUMBER;
            }
            throw new AssertionError();
        }
        if (object instanceof JsonNull) {
            return JsonToken.NULL;
        }
        if (object == SENTINEL_CLOSED) {
            throw new IllegalStateException("JsonReader is closed");
        }
        throw new MalformedJsonException("Custom JsonElement subclass " + object.getClass().getName() + " is not supported");
    }

    private Object peekStack() {
        return this.stack[this.stackSize - 1];
    }

    @CanIgnoreReturnValue
    private Object popStack() {
        Object object = this.stack[--this.stackSize];
        this.stack[this.stackSize] = null;
        return object;
    }

    private void expect(JsonToken jsonToken) {
        if (((JsonReader)this).peek() != jsonToken) {
            throw new IllegalStateException("Expected " + (Object)((Object)jsonToken) + " but was " + (Object)((Object)((JsonReader)this).peek()) + this.locationString());
        }
    }

    private String nextName(boolean bl) {
        this.expect(JsonToken.NAME);
        Object object = (Iterator)this.peekStack();
        object = (Map.Entry)object.next();
        String string = (String)object.getKey();
        this.pathNames[this.stackSize - 1] = bl ? "<skipped>" : string;
        this.push(object.getValue());
        return string;
    }

    @Override
    public final String nextName() {
        return this.nextName(false);
    }

    @Override
    public final String nextString() {
        Object object = ((JsonReader)this).peek();
        if (object != JsonToken.STRING && object != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.STRING) + " but was " + (Object)object + this.locationString());
        }
        object = ((JsonElement)((JsonPrimitive)this.popStack())).getAsString();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return object;
    }

    @Override
    public final boolean nextBoolean() {
        this.expect(JsonToken.BOOLEAN);
        boolean bl = ((JsonElement)((JsonPrimitive)this.popStack())).getAsBoolean();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return bl;
    }

    @Override
    public final void nextNull() {
        this.expect(JsonToken.NULL);
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
    }

    @Override
    public final double nextDouble() {
        JsonToken jsonToken = ((JsonReader)this).peek();
        if (jsonToken != JsonToken.NUMBER && jsonToken != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + (Object)((Object)jsonToken) + this.locationString());
        }
        double d = ((JsonElement)((JsonPrimitive)this.peekStack())).getAsDouble();
        if (!this.isLenient() && (Double.isNaN(d) || Double.isInfinite(d))) {
            throw new MalformedJsonException("JSON forbids NaN and infinities: " + d);
        }
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return d;
    }

    @Override
    public final long nextLong() {
        JsonToken jsonToken = ((JsonReader)this).peek();
        if (jsonToken != JsonToken.NUMBER && jsonToken != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + (Object)((Object)jsonToken) + this.locationString());
        }
        long l = ((JsonElement)((JsonPrimitive)this.peekStack())).getAsLong();
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return l;
    }

    @Override
    public final int nextInt() {
        JsonToken jsonToken = ((JsonReader)this).peek();
        if (jsonToken != JsonToken.NUMBER && jsonToken != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + (Object)((Object)jsonToken) + this.locationString());
        }
        int n = ((JsonElement)((JsonPrimitive)this.peekStack())).getAsInt();
        this.popStack();
        if (this.stackSize > 0) {
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
        }
        return n;
    }

    final JsonElement nextJsonElement() {
        Object object = ((JsonReader)this).peek();
        if (object == JsonToken.NAME || object == JsonToken.END_ARRAY || object == JsonToken.END_OBJECT || object == JsonToken.END_DOCUMENT) {
            throw new IllegalStateException("Unexpected " + (Object)object + " when reading a JsonElement.");
        }
        object = (JsonElement)this.peekStack();
        ((JsonReader)this).skipValue();
        return object;
    }

    @Override
    public final void close() {
        this.stack = new Object[]{SENTINEL_CLOSED};
        this.stackSize = 1;
    }

    @Override
    public final void skipValue() {
        JsonToken jsonToken = ((JsonReader)this).peek();
        switch (jsonToken) {
            case NAME: {
                this.nextName(true);
                return;
            }
            case END_ARRAY: {
                ((JsonReader)this).endArray();
                return;
            }
            case END_OBJECT: {
                ((JsonReader)this).endObject();
                return;
            }
            case END_DOCUMENT: {
                return;
            }
        }
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + this.locationString();
    }

    public final void promoteNameToValue() {
        this.expect(JsonToken.NAME);
        Object object = (Iterator)this.peekStack();
        object = (Map.Entry)object.next();
        this.push(object.getValue());
        this.push(new JsonPrimitive((String)object.getKey()));
    }

    private void push(Object object) {
        if (this.stackSize == this.stack.length) {
            int n = this.stackSize << 1;
            this.stack = Arrays.copyOf(this.stack, n);
            this.pathIndices = Arrays.copyOf(this.pathIndices, n);
            this.pathNames = Arrays.copyOf(this.pathNames, n);
        }
        this.stack[this.stackSize++] = object;
    }

    private String getPath(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("$");
        for (int i = 0; i < this.stackSize; ++i) {
            if (this.stack[i] instanceof JsonArray) {
                if (++i >= this.stackSize || !(this.stack[i] instanceof Iterator)) continue;
                int n = this.pathIndices[i];
                if (bl && n > 0 && (i == this.stackSize - 1 || i == this.stackSize - 2)) {
                    --n;
                }
                stringBuilder.append('[').append(n).append(']');
                continue;
            }
            if (!(this.stack[i] instanceof JsonObject) || ++i >= this.stackSize || !(this.stack[i] instanceof Iterator)) continue;
            stringBuilder.append('.');
            if (this.pathNames[i] == null) continue;
            stringBuilder.append(this.pathNames[i]);
        }
        return stringBuilder.toString();
    }

    @Override
    public final String getPath() {
        return this.getPath(false);
    }

    @Override
    public final String getPreviousPath() {
        return this.getPath(true);
    }

    private String locationString() {
        return " at path " + ((JsonReader)this).getPath();
    }
}

