/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.internal.sql;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.JsonSyntaxException;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.TypeAdapter;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.TypeAdapterFactory;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.internal.sql.SqlDateTypeAdapter$1;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.stream.JsonReader;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.stream.JsonToken;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.stream.JsonWriter;

final class SqlDateTypeAdapter
extends TypeAdapter<java.sql.Date> {
    static final TypeAdapterFactory FACTORY = new SqlDateTypeAdapter$1();
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    private SqlDateTypeAdapter() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final java.sql.Date read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        String string = jsonReader.nextString();
        SqlDateTypeAdapter sqlDateTypeAdapter = this;
        synchronized (sqlDateTypeAdapter) {
            TimeZone timeZone = this.format.getTimeZone();
            try {
                Date date = this.format.parse(string);
                date = new java.sql.Date(date.getTime());
                return date;
            }
            catch (ParseException date) {
                throw new JsonSyntaxException("Failed parsing '" + string + "' as SQL Date; at path " + jsonReader.getPreviousPath(), date);
            }
            finally {
                this.format.setTimeZone(timeZone);
            }
        }
    }

    @Override
    public final void write(JsonWriter jsonWriter, java.sql.Date object) {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        SqlDateTypeAdapter sqlDateTypeAdapter = this;
        synchronized (sqlDateTypeAdapter) {
            object = this.format.format((Date)object);
        }
        jsonWriter.value((String)object);
    }

    /* synthetic */ SqlDateTypeAdapter(SqlDateTypeAdapter$1 sqlDateTypeAdapter$1) {
        this();
    }
}

