/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.stream;

import java.io.Closeable;
import java.io.EOFException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Objects;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.Strictness;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.internal.JsonReaderInternalAccess;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.internal.TroubleshootingGuide;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.stream.JsonReader$1;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.stream.JsonToken;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.gson.stream.MalformedJsonException;

public class JsonReader
implements Closeable {
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_EOF = 17;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    private final Reader in;
    private Strictness strictness = Strictness.LEGACY_STRICT;
    static final int DEFAULT_NESTING_LIMIT = 255;
    private int nestingLimit = 255;
    static final int BUFFER_SIZE = 1024;
    private final char[] buffer = new char[1024];
    private int pos = 0;
    private int limit = 0;
    private int lineNumber = 0;
    private int lineStart = 0;
    int peeked = 0;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String[] pathNames;
    private int[] pathIndices;

    public JsonReader(Reader reader) {
        this.stack[this.stackSize++] = 6;
        this.pathNames = new String[32];
        this.pathIndices = new int[32];
        this.in = Objects.requireNonNull(reader, "in == null");
    }

    @Deprecated
    public final void setLenient(boolean bl) {
        this.setStrictness(bl ? Strictness.LENIENT : Strictness.LEGACY_STRICT);
    }

    public final boolean isLenient() {
        return this.strictness == Strictness.LENIENT;
    }

    public final void setStrictness(Strictness strictness) {
        Objects.requireNonNull(strictness);
        this.strictness = strictness;
    }

    public final Strictness getStrictness() {
        return this.strictness;
    }

    public final void setNestingLimit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid nesting limit: " + n);
        }
        this.nestingLimit = n;
    }

    public final int getNestingLimit() {
        return this.nestingLimit;
    }

    public void beginArray() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 3) {
            this.push(1);
            this.pathIndices[this.stackSize - 1] = 0;
            this.peeked = 0;
            return;
        }
        throw this.unexpectedTokenError("BEGIN_ARRAY");
    }

    public void endArray() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 4) {
            --this.stackSize;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            this.peeked = 0;
            return;
        }
        throw this.unexpectedTokenError("END_ARRAY");
    }

    public void beginObject() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 1) {
            this.push(3);
            this.peeked = 0;
            return;
        }
        throw this.unexpectedTokenError("BEGIN_OBJECT");
    }

    public void endObject() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 2) {
            --this.stackSize;
            this.pathNames[this.stackSize] = null;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            this.peeked = 0;
            return;
        }
        throw this.unexpectedTokenError("END_OBJECT");
    }

    public boolean hasNext() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        return n != 2 && n != 4 && n != 17;
    }

    public JsonToken peek() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        switch (n) {
            case 1: {
                return JsonToken.BEGIN_OBJECT;
            }
            case 2: {
                return JsonToken.END_OBJECT;
            }
            case 3: {
                return JsonToken.BEGIN_ARRAY;
            }
            case 4: {
                return JsonToken.END_ARRAY;
            }
            case 12: 
            case 13: 
            case 14: {
                return JsonToken.NAME;
            }
            case 5: 
            case 6: {
                return JsonToken.BOOLEAN;
            }
            case 7: {
                return JsonToken.NULL;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return JsonToken.STRING;
            }
            case 15: 
            case 16: {
                return JsonToken.NUMBER;
            }
            case 17: {
                return JsonToken.END_DOCUMENT;
            }
        }
        throw new AssertionError();
    }

    int doPeek() {
        int n;
        int n2;
        block45: {
            block47: {
                block46: {
                    block44: {
                        n2 = this.stack[this.stackSize - 1];
                        if (n2 != 1) break block44;
                        this.stack[this.stackSize - 1] = 2;
                        break block45;
                    }
                    if (n2 != 2) break block46;
                    n = this.nextNonWhitespace(true);
                    switch (n) {
                        case 93: {
                            this.peeked = 4;
                            return this.peeked;
                        }
                        case 59: {
                            this.checkLenient();
                        }
                        case 44: {
                            break block45;
                        }
                        default: {
                            throw this.syntaxError("Unterminated array");
                        }
                    }
                }
                if (n2 == 3 || n2 == 5) {
                    int n3;
                    this.stack[this.stackSize - 1] = 4;
                    if (n2 == 5) {
                        n3 = this.nextNonWhitespace(true);
                        switch (n3) {
                            case 125: {
                                this.peeked = 2;
                                return this.peeked;
                            }
                            case 59: {
                                this.checkLenient();
                            }
                            case 44: {
                                break;
                            }
                            default: {
                                throw this.syntaxError("Unterminated object");
                            }
                        }
                    }
                    n3 = this.nextNonWhitespace(true);
                    switch (n3) {
                        case 34: {
                            this.peeked = 13;
                            return this.peeked;
                        }
                        case 39: {
                            this.checkLenient();
                            this.peeked = 12;
                            return this.peeked;
                        }
                        case 125: {
                            if (n2 != 5) {
                                this.peeked = 2;
                                return this.peeked;
                            }
                            throw this.syntaxError("Expected name");
                        }
                    }
                    this.checkLenient();
                    --this.pos;
                    if (this.isLiteral((char)n3)) {
                        this.peeked = 14;
                        return this.peeked;
                    }
                    throw this.syntaxError("Expected name");
                }
                if (n2 != 4) break block47;
                this.stack[this.stackSize - 1] = 5;
                n = this.nextNonWhitespace(true);
                switch (n) {
                    case 58: {
                        break block45;
                    }
                    case 61: {
                        this.checkLenient();
                        if ((this.pos < this.limit || this.fillBuffer(1)) && this.buffer[this.pos] == '>') {
                            ++this.pos;
                        }
                        break block45;
                    }
                    default: {
                        throw this.syntaxError("Expected ':'");
                    }
                }
            }
            if (n2 == 6) {
                if (this.strictness == Strictness.LENIENT) {
                    this.consumeNonExecutePrefix();
                }
                this.stack[this.stackSize - 1] = 7;
            } else if (n2 == 7) {
                n = this.nextNonWhitespace(false);
                if (n == -1) {
                    this.peeked = 17;
                    return this.peeked;
                }
                this.checkLenient();
                --this.pos;
            } else if (n2 == 8) {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        n = this.nextNonWhitespace(true);
        switch (n) {
            case 93: {
                if (n2 == 1) {
                    this.peeked = 4;
                    return this.peeked;
                }
            }
            case 44: 
            case 59: {
                if (n2 == 1 || n2 == 2) {
                    this.checkLenient();
                    --this.pos;
                    this.peeked = 7;
                    return this.peeked;
                }
                throw this.syntaxError("Unexpected value");
            }
            case 39: {
                this.checkLenient();
                this.peeked = 8;
                return this.peeked;
            }
            case 34: {
                this.peeked = 9;
                return this.peeked;
            }
            case 91: {
                this.peeked = 3;
                return this.peeked;
            }
            case 123: {
                this.peeked = 1;
                return this.peeked;
            }
        }
        --this.pos;
        n2 = this.peekKeyword();
        if (n2 != 0) {
            return n2;
        }
        n2 = this.peekNumber();
        if (n2 != 0) {
            return n2;
        }
        JsonReader jsonReader = this;
        if (!jsonReader.isLiteral(jsonReader.buffer[this.pos])) {
            throw this.syntaxError("Expected value");
        }
        this.checkLenient();
        this.peeked = 10;
        return this.peeked;
    }

    private int peekKeyword() {
        int n;
        String string;
        String string2;
        char c = this.buffer[this.pos];
        if (c == 't' || c == 'T') {
            string2 = "true";
            string = "TRUE";
            n = 5;
        } else if (c == 'f' || c == 'F') {
            string2 = "false";
            string = "FALSE";
            n = 6;
        } else if (c == 'n' || c == 'N') {
            string2 = "null";
            string = "NULL";
            n = 7;
        } else {
            return 0;
        }
        boolean bl = this.strictness != Strictness.STRICT;
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            if (this.pos + i >= this.limit && !this.fillBuffer(i + 1)) {
                return 0;
            }
            c = this.buffer[this.pos + i];
            c = c == string2.charAt(i) || bl && c == string.charAt(i) ? (char)'\u0001' : '\u0000';
            if (c != '\u0000') continue;
            return 0;
        }
        if (this.pos + n2 < this.limit || this.fillBuffer(n2 + 1)) {
            JsonReader jsonReader = this;
            if (jsonReader.isLiteral(jsonReader.buffer[this.pos + n2])) {
                return 0;
            }
        }
        this.pos += n2;
        this.peeked = n;
        return this.peeked;
    }

    private int peekNumber() {
        char[] cArray = this.buffer;
        int n = this.pos;
        int n2 = this.limit;
        long l = 0L;
        boolean bl = false;
        boolean bl2 = true;
        int n3 = 0;
        int n4 = 0;
        block6: while (true) {
            if (n + n4 == n2) {
                if (n4 == cArray.length) {
                    return 0;
                }
                if (!this.fillBuffer(n4 + 1)) break;
                n = this.pos;
                n2 = this.limit;
            }
            char c = cArray[n + n4];
            switch (c) {
                case '-': {
                    if (n3 == 0) {
                        bl = true;
                        n3 = 1;
                        break;
                    }
                    if (n3 == 5) {
                        n3 = 6;
                        break;
                    }
                    return 0;
                }
                case '+': {
                    if (n3 == 5) {
                        n3 = 6;
                        break;
                    }
                    return 0;
                }
                case 'E': 
                case 'e': {
                    if (n3 == 2 || n3 == 4) {
                        n3 = 5;
                        break;
                    }
                    return 0;
                }
                case '.': {
                    if (n3 == 2) {
                        n3 = 3;
                        break;
                    }
                    return 0;
                }
                default: {
                    if (c < '0' || c > '9') {
                        if (!this.isLiteral(c)) break block6;
                        return 0;
                    }
                    if (n3 == 1 || n3 == 0) {
                        l = -(c - 48);
                        n3 = 2;
                        break;
                    }
                    if (n3 == 2) {
                        if (l == 0L) {
                            return 0;
                        }
                        long l2 = l * 10L - (long)(c - 48);
                        bl2 &= l > -922337203685477580L || l == -922337203685477580L && l2 < l;
                        l = l2;
                        break;
                    }
                    if (n3 == 3) {
                        n3 = 4;
                        break;
                    }
                    if (n3 != 5 && n3 != 6) break;
                    n3 = 7;
                }
            }
            ++n4;
        }
        if (!(n3 != 2 || !bl2 || l == Long.MIN_VALUE && !bl || l == 0L && bl)) {
            this.peekedLong = bl ? l : -l;
            this.pos += n4;
            this.peeked = 15;
            return this.peeked;
        }
        if (n3 == 2 || n3 == 4 || n3 == 7) {
            this.peekedNumberLength = n4;
            this.peeked = 16;
            return this.peeked;
        }
        return 0;
    }

    private boolean isLiteral(char c) {
        switch (c) {
            case '#': 
            case '/': 
            case ';': 
            case '=': 
            case '\\': {
                this.checkLenient();
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    public String nextName() {
        String string;
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 14) {
            string = this.nextUnquotedValue();
        } else if (n == 12) {
            string = this.nextQuotedValue('\'');
        } else if (n == 13) {
            string = this.nextQuotedValue('\"');
        } else {
            throw this.unexpectedTokenError("a name");
        }
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = string;
        return string;
    }

    public String nextString() {
        String string;
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 10) {
            string = this.nextUnquotedValue();
        } else if (n == 8) {
            string = this.nextQuotedValue('\'');
        } else if (n == 9) {
            string = this.nextQuotedValue('\"');
        } else if (n == 11) {
            string = this.peekedString;
            this.peekedString = null;
        } else if (n == 15) {
            string = Long.toString(this.peekedLong);
        } else if (n == 16) {
            string = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else {
            throw this.unexpectedTokenError("a string");
        }
        this.peeked = 0;
        int n2 = this.stackSize - 1;
        this.pathIndices[n2] = this.pathIndices[n2] + 1;
        return string;
    }

    public boolean nextBoolean() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 5) {
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return true;
        }
        if (n == 6) {
            this.peeked = 0;
            int n3 = this.stackSize - 1;
            this.pathIndices[n3] = this.pathIndices[n3] + 1;
            return false;
        }
        throw this.unexpectedTokenError("a boolean");
    }

    public void nextNull() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 7) {
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return;
        }
        throw this.unexpectedTokenError("null");
    }

    public double nextDouble() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 15) {
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return this.peekedLong;
        }
        if (n == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n == 8 || n == 9) {
            this.peekedString = this.nextQuotedValue(n == 8 ? (char)'\'' : '\"');
        } else if (n == 10) {
            this.peekedString = this.nextUnquotedValue();
        } else if (n != 11) {
            throw this.unexpectedTokenError("a double");
        }
        this.peeked = 11;
        double d = Double.parseDouble(this.peekedString);
        if (this.strictness != Strictness.LENIENT && (Double.isNaN(d) || Double.isInfinite(d))) {
            throw this.syntaxError("JSON forbids NaN and infinities: " + d);
        }
        this.peekedString = null;
        this.peeked = 0;
        int n3 = this.stackSize - 1;
        this.pathIndices[n3] = this.pathIndices[n3] + 1;
        return d;
    }

    public long nextLong() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 15) {
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return this.peekedLong;
        }
        if (n == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n == 8 || n == 9 || n == 10) {
            this.peekedString = n == 10 ? this.nextUnquotedValue() : this.nextQuotedValue(n == 8 ? (char)'\'' : '\"');
            try {
                long l = Long.parseLong(this.peekedString);
                this.peeked = 0;
                int n3 = this.stackSize - 1;
                this.pathIndices[n3] = this.pathIndices[n3] + 1;
                return l;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            throw this.unexpectedTokenError("a long");
        }
        this.peeked = 11;
        double d = Double.parseDouble(this.peekedString);
        long l = (long)d;
        if ((double)l != d) {
            throw new NumberFormatException("Expected a long but was " + this.peekedString + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n4 = this.stackSize - 1;
        this.pathIndices[n4] = this.pathIndices[n4] + 1;
        return l;
    }

    private String nextQuotedValue(char c) {
        char[] cArray = this.buffer;
        StringBuilder stringBuilder = null;
        do {
            int n;
            int n2 = this.pos;
            int n3 = this.limit;
            int n4 = n2;
            while (n2 < n3) {
                n = cArray[n2++];
                if (this.strictness == Strictness.STRICT && n < 32) {
                    throw this.syntaxError("Unescaped control characters (\\u0000-\\u001F) are not allowed in strict mode");
                }
                if (n == c) {
                    this.pos = n2;
                    n2 = n2 - n4 - 1;
                    if (stringBuilder == null) {
                        return new String(cArray, n4, n2);
                    }
                    stringBuilder.append(cArray, n4, n2);
                    return stringBuilder.toString();
                }
                if (n == 92) {
                    this.pos = n2;
                    n2 = n2 - n4 - 1;
                    if (stringBuilder == null) {
                        int n5 = n2 + 1 << 1;
                        stringBuilder = new StringBuilder(Math.max(n5, 16));
                    }
                    stringBuilder.append(cArray, n4, n2);
                    stringBuilder.append(this.readEscapeCharacter());
                    n2 = this.pos;
                    n3 = this.limit;
                    n4 = n2;
                    continue;
                }
                if (n != 10) continue;
                ++this.lineNumber;
                this.lineStart = n2;
            }
            if (stringBuilder == null) {
                n = n2 - n4 << 1;
                stringBuilder = new StringBuilder(Math.max(n, 16));
            }
            stringBuilder.append(cArray, n4, n2 - n4);
            this.pos = n2;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    private String nextUnquotedValue() {
        CharSequence charSequence = null;
        int n = 0;
        block4: while (true) {
            if (this.pos + n < this.limit) {
                switch (this.buffer[this.pos + n]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        break block4;
                    }
                    default: {
                        ++n;
                        break;
                    }
                }
                continue;
            }
            if (n < this.buffer.length) {
                if (!this.fillBuffer(n + 1)) break;
                continue;
            }
            if (charSequence == null) {
                charSequence = new StringBuilder(Math.max(n, 16));
            }
            charSequence.append(this.buffer, this.pos, n);
            this.pos += n;
            n = 0;
            if (!this.fillBuffer(1)) break;
        }
        charSequence = charSequence == null ? new String(this.buffer, this.pos, n) : charSequence.append(this.buffer, this.pos, n).toString();
        this.pos += n;
        return charSequence;
    }

    private void skipQuotedValue(char c) {
        char[] cArray = this.buffer;
        do {
            int n = this.pos;
            int n2 = this.limit;
            while (n < n2) {
                char c2;
                if ((c2 = cArray[n++]) == c) {
                    this.pos = n;
                    return;
                }
                if (c2 == '\\') {
                    this.pos = n;
                    this.readEscapeCharacter();
                    n = this.pos;
                    n2 = this.limit;
                    continue;
                }
                if (c2 != '\n') continue;
                ++this.lineNumber;
                this.lineStart = n;
            }
            this.pos = n;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    private void skipUnquotedValue() {
        do {
            int n = 0;
            while (this.pos + n < this.limit) {
                switch (this.buffer[this.pos + n]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        this.pos += n;
                        return;
                    }
                }
                ++n;
            }
            this.pos += n;
        } while (this.fillBuffer(1));
    }

    public int nextInt() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 15) {
            n = (int)this.peekedLong;
            if (this.peekedLong != (long)n) {
                throw new NumberFormatException("Expected an int but was " + this.peekedLong + this.locationString());
            }
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return n;
        }
        if (n == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n == 8 || n == 9 || n == 10) {
            this.peekedString = n == 10 ? this.nextUnquotedValue() : this.nextQuotedValue(n == 8 ? (char)'\'' : '\"');
            try {
                n = Integer.parseInt(this.peekedString);
                this.peeked = 0;
                int n3 = this.stackSize - 1;
                this.pathIndices[n3] = this.pathIndices[n3] + 1;
                return n;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            throw this.unexpectedTokenError("an int");
        }
        this.peeked = 11;
        double d = Double.parseDouble(this.peekedString);
        n = (int)d;
        if ((double)n != d) {
            throw new NumberFormatException("Expected an int but was " + this.peekedString + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n4 = this.stackSize - 1;
        this.pathIndices[n4] = this.pathIndices[n4] + 1;
        return n;
    }

    @Override
    public void close() {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.in.close();
    }

    public void skipValue() {
        int n = 0;
        do {
            int n2;
            if ((n2 = this.peeked) == 0) {
                n2 = this.doPeek();
            }
            switch (n2) {
                case 3: {
                    this.push(1);
                    ++n;
                    break;
                }
                case 1: {
                    this.push(3);
                    ++n;
                    break;
                }
                case 4: {
                    --this.stackSize;
                    --n;
                    break;
                }
                case 2: {
                    if (n == 0) {
                        this.pathNames[this.stackSize - 1] = null;
                    }
                    --this.stackSize;
                    --n;
                    break;
                }
                case 10: {
                    this.skipUnquotedValue();
                    break;
                }
                case 8: {
                    this.skipQuotedValue('\'');
                    break;
                }
                case 9: {
                    this.skipQuotedValue('\"');
                    break;
                }
                case 14: {
                    this.skipUnquotedValue();
                    if (n != 0) break;
                    this.pathNames[this.stackSize - 1] = "<skipped>";
                    break;
                }
                case 12: {
                    this.skipQuotedValue('\'');
                    if (n != 0) break;
                    this.pathNames[this.stackSize - 1] = "<skipped>";
                    break;
                }
                case 13: {
                    this.skipQuotedValue('\"');
                    if (n != 0) break;
                    this.pathNames[this.stackSize - 1] = "<skipped>";
                    break;
                }
                case 16: {
                    this.pos += this.peekedNumberLength;
                    break;
                }
                case 17: {
                    return;
                }
            }
            this.peeked = 0;
        } while (n > 0);
        int n3 = this.stackSize - 1;
        this.pathIndices[n3] = this.pathIndices[n3] + 1;
    }

    private void push(int n) {
        if (this.stackSize - 1 >= this.nestingLimit) {
            throw new MalformedJsonException("Nesting limit " + this.nestingLimit + " reached" + this.locationString());
        }
        if (this.stackSize == this.stack.length) {
            int n2 = this.stackSize << 1;
            this.stack = Arrays.copyOf(this.stack, n2);
            this.pathIndices = Arrays.copyOf(this.pathIndices, n2);
            this.pathNames = Arrays.copyOf(this.pathNames, n2);
        }
        this.stack[this.stackSize++] = n;
    }

    private boolean fillBuffer(int n) {
        int n2;
        char[] cArray = this.buffer;
        this.lineStart -= this.pos;
        if (this.limit != this.pos) {
            this.limit -= this.pos;
            System.arraycopy(cArray, this.pos, cArray, 0, this.limit);
        } else {
            this.limit = 0;
        }
        this.pos = 0;
        while ((n2 = this.in.read(cArray, this.limit, cArray.length - this.limit)) != -1) {
            this.limit += n2;
            if (this.lineNumber == 0 && this.lineStart == 0 && this.limit > 0 && cArray[0] == '\ufeff') {
                ++this.pos;
                ++this.lineStart;
                ++n;
            }
            if (this.limit < n) continue;
            return true;
        }
        return false;
    }

    private int nextNonWhitespace(boolean bl) {
        block12: {
            char c;
            char[] cArray = this.buffer;
            int n = this.pos;
            int n2 = this.limit;
            block4: while (true) {
                if (n == n2) {
                    this.pos = n;
                    if (!this.fillBuffer(1)) break block12;
                    n = this.pos;
                    n2 = this.limit;
                }
                if ((c = cArray[n++]) == '\n') {
                    ++this.lineNumber;
                    this.lineStart = n;
                    continue;
                }
                if (c == ' ' || c == '\r' || c == '\t') continue;
                if (c == '/') {
                    this.pos = n;
                    if (n == n2) {
                        --this.pos;
                        n = this.fillBuffer(2) ? 1 : 0;
                        ++this.pos;
                        if (n == 0) {
                            return c;
                        }
                    }
                    this.checkLenient();
                    n = cArray[this.pos];
                    switch (n) {
                        case 42: {
                            ++this.pos;
                            if (!this.skipTo("*/")) {
                                throw this.syntaxError("Unterminated comment");
                            }
                            n = this.pos + 2;
                            n2 = this.limit;
                            continue block4;
                        }
                        case 47: {
                            ++this.pos;
                            this.skipToEndOfLine();
                            n = this.pos;
                            n2 = this.limit;
                            continue block4;
                        }
                    }
                    return c;
                }
                if (c != '#') break;
                this.pos = n;
                this.checkLenient();
                this.skipToEndOfLine();
                n = this.pos;
                n2 = this.limit;
            }
            this.pos = n;
            return c;
        }
        if (bl) {
            throw new EOFException("End of input" + this.locationString());
        }
        return -1;
    }

    private void checkLenient() {
        if (this.strictness != Strictness.LENIENT) {
            throw this.syntaxError("Use JsonReader.setStrictness(Strictness.LENIENT) to accept malformed JSON");
        }
    }

    private void skipToEndOfLine() {
        while (this.pos < this.limit || this.fillBuffer(1)) {
            char c;
            if ((c = this.buffer[this.pos++]) == '\n') {
                ++this.lineNumber;
                this.lineStart = this.pos;
                return;
            }
            if (c != '\r') continue;
        }
    }

    private boolean skipTo(String string) {
        int n = string.length();
        while (this.pos + n <= this.limit || this.fillBuffer(n)) {
            block5: {
                if (this.buffer[this.pos] == '\n') {
                    ++this.lineNumber;
                    this.lineStart = this.pos + 1;
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (this.buffer[this.pos + i] == string.charAt(i)) {
                            continue;
                        }
                        break block5;
                    }
                    return true;
                }
            }
            ++this.pos;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.locationString();
    }

    String locationString() {
        int n = this.lineNumber + 1;
        int n2 = this.pos - this.lineStart + 1;
        return " at line " + n + " column " + n2 + " path " + this.getPath();
    }

    private String getPath(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("$");
        block5: for (int i = 0; i < this.stackSize; ++i) {
            int n = this.stack[i];
            switch (n) {
                case 1: 
                case 2: {
                    n = this.pathIndices[i];
                    if (bl && n > 0 && i == this.stackSize - 1) {
                        --n;
                    }
                    stringBuilder.append('[').append(n).append(']');
                    continue block5;
                }
                case 3: 
                case 4: 
                case 5: {
                    stringBuilder.append('.');
                    if (this.pathNames[i] == null) continue block5;
                    stringBuilder.append(this.pathNames[i]);
                    continue block5;
                }
                case 6: 
                case 7: 
                case 8: {
                    continue block5;
                }
                default: {
                    throw new AssertionError((Object)("Unknown scope value: " + n));
                }
            }
        }
        return stringBuilder.toString();
    }

    public String getPath() {
        return this.getPath(false);
    }

    public String getPreviousPath() {
        return this.getPath(true);
    }

    private char readEscapeCharacter() {
        if (this.pos == this.limit && !this.fillBuffer(1)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        int n = this.buffer[this.pos++];
        switch (n) {
            case 117: {
                int n2;
                if (this.pos + 4 > this.limit && !this.fillBuffer(4)) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                n = 0;
                int n3 = n2 + 4;
                for (n2 = this.pos; n2 < n3; ++n2) {
                    char c = this.buffer[n2];
                    n <<= 4;
                    if (c >= '0' && c <= '9') {
                        n += c - 48;
                        continue;
                    }
                    if (c >= 'a' && c <= 'f') {
                        n += c - 97 + 10;
                        continue;
                    }
                    if (c >= 'A' && c <= 'F') {
                        n += c - 65 + 10;
                        continue;
                    }
                    throw this.syntaxError("Malformed Unicode escape \\u" + new String(this.buffer, this.pos, 4));
                }
                this.pos += 4;
                return (char)n;
            }
            case 116: {
                return '\t';
            }
            case 98: {
                return '\b';
            }
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 102: {
                return '\f';
            }
            case 10: {
                if (this.strictness == Strictness.STRICT) {
                    throw this.syntaxError("Cannot escape a newline character in strict mode");
                }
                ++this.lineNumber;
                this.lineStart = this.pos;
            }
            case 39: {
                if (this.strictness == Strictness.STRICT) {
                    throw this.syntaxError("Invalid escaped character \"'\" in strict mode");
                }
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)n;
            }
        }
        throw this.syntaxError("Invalid escape sequence");
    }

    private MalformedJsonException syntaxError(String string) {
        throw new MalformedJsonException(string + this.locationString() + "\nSee " + TroubleshootingGuide.createUrl("malformed-json"));
    }

    private IllegalStateException unexpectedTokenError(String string) {
        Object object = this.peek();
        object = object == JsonToken.NULL ? "adapter-not-null-safe" : "unexpected-json-structure";
        return new IllegalStateException("Expected " + string + " but was " + (Object)((Object)this.peek()) + this.locationString() + "\nSee " + TroubleshootingGuide.createUrl((String)object));
    }

    private void consumeNonExecutePrefix() {
        this.nextNonWhitespace(true);
        --this.pos;
        if (this.pos + 5 > this.limit && !this.fillBuffer(5)) {
            return;
        }
        int n = this.pos;
        char[] cArray = this.buffer;
        if (this.buffer[n] != ')' || cArray[n + 1] != ']' || cArray[n + 2] != '}' || cArray[n + 3] != '\'' || cArray[n + 4] != '\n') {
            return;
        }
        this.pos += 5;
    }

    static /* synthetic */ IllegalStateException access$000(JsonReader jsonReader, String string) {
        return jsonReader.unexpectedTokenError(string);
    }

    static {
        JsonReaderInternalAccess.INSTANCE = new JsonReader$1();
    }
}

