/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.annotations.NotNull;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.Metadata;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.PublishedApi;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.SinceKotlin;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.Unit;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.collections.CollectionsKt;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.collections.builders.ListBuilder;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.internal.InlineOnly;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.functions.Function1;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.CollectionToArray;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.Intrinsics;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=5, xi=49, d1={"\u0000P\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\u001f\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0004\u001a7\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0001\"\u0004\b\u0000\u0010\u00062\u001d\u0010\u0007\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bH\u0081\b\u00f8\u0001\u0000\u001a?\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0001\"\u0004\b\u0000\u0010\u00062\u0006\u0010\f\u001a\u00020\r2\u001d\u0010\u0007\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bH\u0081\b\u00f8\u0001\u0000\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\t\"\u0004\b\u0000\u0010\u0006H\u0001\u001a\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\t\"\u0004\b\u0000\u0010\u00062\u0006\u0010\f\u001a\u00020\rH\u0001\u001a\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0001\"\u0004\b\u0000\u0010\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00060\tH\u0001\u001a\u001f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0012H\u0087\b\u001a\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0014H\u0007\u001a&\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u001a\"\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0081\b\u00a2\u0006\u0002\u0010\u001c\u001a4\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0018\"\u0004\b\u0000\u0010\u00022\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0018H\u0081\b\u00a2\u0006\u0002\u0010\u001e\u001a/\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0018\"\u0004\b\u0000\u0010\u00022\u0006\u0010 \u001a\u00020\r2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0018H\u0000\u00a2\u0006\u0002\u0010!\u001a1\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00190\u0018\"\u0004\b\u0000\u0010\u0002*\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\u0010%\u001a\u0011\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\rH\u0081\b\u001a\u0011\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\rH\u0081\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006*"}, d2={"listOf", "", "T", "element", "(Ljava/lang/Object;)Ljava/util/List;", "buildListInternal", "E", "builderAction", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/Function1;", "", "", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/ExtensionFunctionType;", "capacity", "", "createListBuilder", "build", "builder", "toList", "Ljava/util/Enumeration;", "shuffled", "", "random", "Ljava/util/Random;", "collectionToArray", "", "", "collection", "", "(Ljava/util/Collection;)[Ljava/lang/Object;", "array", "(Ljava/util/Collection;[Ljava/lang/Object;)[Ljava/lang/Object;", "terminateCollectionToArray", "collectionSize", "(I[Ljava/lang/Object;)[Ljava/lang/Object;", "copyToArrayOfAny", "isVarargs", "", "([Ljava/lang/Object;Z)[Ljava/lang/Object;", "checkIndexOverflow", "index", "checkCountOverflow", "count", "me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin-stdlib"}, xs="me/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/collections/CollectionsKt")
@SourceDebugExtension(value={"SMAP\nCollectionsJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionsJVM.kt\nkotlin/collections/CollectionsKt__CollectionsJVMKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
class CollectionsKt__CollectionsJVMKt {
    @NotNull
    public static final <T> List<T> listOf(T t) {
        List<T> list = Collections.singletonList(t);
        Intrinsics.checkNotNullExpressionValue(list, "singletonList(...)");
        return list;
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    @InlineOnly
    private static final <E> List<E> buildListInternal(Function1<? super List<E>, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, "builderAction");
        List<E> list = CollectionsKt.createListBuilder();
        function1.invoke(list);
        return CollectionsKt.build(list);
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    @InlineOnly
    private static final <E> List<E> buildListInternal(int n, Function1<? super List<E>, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, "builderAction");
        List<E> list = CollectionsKt.createListBuilder(n);
        function1.invoke(list);
        return CollectionsKt.build(list);
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    @NotNull
    public static final <E> List<E> createListBuilder() {
        return new ListBuilder(0, 1, null);
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    @NotNull
    public static final <E> List<E> createListBuilder(int n) {
        return new ListBuilder(n);
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    @NotNull
    public static final <E> List<E> build(@NotNull List<E> list) {
        Intrinsics.checkNotNullParameter(list, "builder");
        return ((ListBuilder)list).build();
    }

    @InlineOnly
    private static final <T> List<T> toList(Enumeration<T> enumeration) {
        Intrinsics.checkNotNullParameter(enumeration, "<this>");
        ArrayList<T> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, "list(...)");
        return arrayList;
    }

    @SinceKotlin(version="1.2")
    @NotNull
    public static final <T> List<T> shuffled(@NotNull Iterable<? extends T> iterable) {
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        iterable = CollectionsKt.toMutableList(iterable);
        List<T> list = iterable;
        Collections.shuffle(iterable);
        return iterable;
    }

    @SinceKotlin(version="1.2")
    @NotNull
    public static final <T> List<T> shuffled(@NotNull Iterable<? extends T> iterable, @NotNull Random random) {
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        Intrinsics.checkNotNullParameter(random, "random");
        iterable = CollectionsKt.toMutableList(iterable);
        List<T> list = iterable;
        Collections.shuffle(iterable, random);
        return iterable;
    }

    @InlineOnly
    private static final Object[] collectionToArray(Collection<?> collection) {
        Intrinsics.checkNotNullParameter(collection, "collection");
        return CollectionToArray.toArray(collection);
    }

    @InlineOnly
    private static final <T> T[] collectionToArray(Collection<?> collection, T[] TArray) {
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(TArray, "array");
        return CollectionToArray.toArray(collection, TArray);
    }

    @NotNull
    public static final <T> T[] terminateCollectionToArray(int n, @NotNull T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, "array");
        if (n < TArray.length) {
            TArray[n] = null;
        }
        return TArray;
    }

    @NotNull
    public static final <T> Object[] copyToArrayOfAny(@NotNull T[] TArray, boolean bl) {
        Intrinsics.checkNotNullParameter(TArray, "<this>");
        if (bl && Intrinsics.areEqual(TArray.getClass(), Object[].class)) {
            return TArray;
        }
        Object[] objectArray = Arrays.copyOf(TArray, TArray.length, Object[].class);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        return objectArray;
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    @InlineOnly
    private static final int checkIndexOverflow(int n) {
        if (n < 0) {
            CollectionsKt.throwIndexOverflow();
        }
        return n;
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    @InlineOnly
    private static final int checkCountOverflow(int n) {
        if (n < 0) {
            CollectionsKt.throwCountOverflow();
        }
        return n;
    }
}

