/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.ranges;

import me.spartacus04.stackablecuring.dependencies.stackablecuring.annotations.NotNull;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.annotations.Nullable;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.Metadata;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.collections.CharIterator;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.internal.ProgressionUtilKt;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.Intrinsics;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.markers.KMappedMarker;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.ranges.CharProgression$Companion;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.ranges.CharProgressionIterator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB!\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\t\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/ranges/CharProgression;", "", "", "start", "endInclusive", "step", "", "<init>", "(CCI)V", "first", "getFirst", "()C", "last", "getLast", "getStep", "()I", "iterator", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/collections/CharIterator;", "isEmpty", "", "equals", "other", "", "hashCode", "toString", "", "Companion", "me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin-stdlib"})
public class CharProgression
implements Iterable<Character>,
KMappedMarker {
    @NotNull
    public static final CharProgression$Companion Companion = new CharProgression$Companion(null);
    private final char first;
    private final char last;
    private final int step;

    public CharProgression(char c, char c2, int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Step must be non-zero.");
        }
        if (n == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Step must be greater than Int.MIN_VALUE to avoid overflow on negation.");
        }
        this.first = c;
        this.last = (char)ProgressionUtilKt.getProgressionLastElement(c, c2, n);
        this.step = n;
    }

    public final char getFirst() {
        return this.first;
    }

    public final char getLast() {
        return this.last;
    }

    public final int getStep() {
        return this.step;
    }

    @NotNull
    public CharIterator iterator() {
        return new CharProgressionIterator(this.first, this.last, this.step);
    }

    public boolean isEmpty() {
        if (this.step > 0) {
            return Intrinsics.compare(this.first, this.last) > 0;
        }
        return Intrinsics.compare(this.first, this.last) < 0;
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof CharProgression && (this.isEmpty() && ((CharProgression)object).isEmpty() || this.first == ((CharProgression)object).first && this.last == ((CharProgression)object).last && this.step == ((CharProgression)object).step);
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return -1;
        }
        return 31 * (31 * this.first + this.last) + this.step;
    }

    @NotNull
    public String toString() {
        if (this.step > 0) {
            return this.first + ".." + this.last + " step " + this.step;
        }
        return this.first + " downTo " + this.last + " step " + -this.step;
    }
}

