/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.text;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.annotations.NotNull;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.annotations.Nullable;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.ExperimentalStdlibApi;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.Metadata;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.PublishedApi;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.SinceKotlin;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.WasExperimental;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.collections.CollectionsKt;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.functions.Function1;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.Intrinsics;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.SourceDebugExtension;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.ranges.RangesKt;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.sequences.Sequence;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.sequences.SequencesKt;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.text.MatchResult;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.text.MatcherMatchResult;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.text.Regex$Companion;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.text.Regex$Serialized;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.text.Regex$findAll$2;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.text.Regex$special$$inlined$fromInt$1;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.text.Regex$splitToSequence$1;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.text.RegexKt;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.text.RegexOption;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 22\u00060\u0001j\u0002`\u0002:\u000212B\u0011\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\fB\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0004\b\u0005\u0010\u000fJ\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0086\u0004J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010 \u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010!\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001dH\u0007J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001dH\u0007J\u0016\u0010$\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\bJ\"\u0010$\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00180'J\u0016\u0010(\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\bJ\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0*2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020\u001dJ \u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020\u001dH\u0007J\b\u0010-\u001a\u00020\bH\u0016J\u0006\u0010.\u001a\u00020\u0004J\b\u0010/\u001a\u000200H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00063"}, d2={"Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/text/Regex;", "Ljava/io/Serializable;", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/io/Serializable;", "nativePattern", "Ljava/util/regex/Pattern;", "<init>", "(Ljava/util/regex/Pattern;)V", "pattern", "", "(Ljava/lang/String;)V", "option", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/text/RegexOption;", "(Ljava/lang/String;Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/text/RegexOption;)V", "options", "", "(Ljava/lang/String;Ljava/util/Set;)V", "getPattern", "()Ljava/lang/String;", "_options", "getOptions", "()Ljava/util/Set;", "matches", "", "input", "", "containsMatchIn", "find", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/text/MatchResult;", "startIndex", "", "findAll", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/sequences/Sequence;", "matchEntire", "matchAt", "index", "matchesAt", "replace", "replacement", "transform", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/Function1;", "replaceFirst", "split", "", "limit", "splitToSequence", "toString", "toPattern", "writeReplace", "", "Serialized", "Companion", "me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin-stdlib"})
@SourceDebugExtension(value={"SMAP\nRegex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Regex.kt\nkotlin/text/Regex\n+ 2 Regex.kt\nkotlin/text/RegexKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,401:1\n22#2,3:402\n1#3:405\n*S KotlinDebug\n*F\n+ 1 Regex.kt\nkotlin/text/Regex\n*L\n103#1:402,3\n*E\n"})
public final class Regex
implements Serializable {
    @NotNull
    public static final Regex$Companion Companion = new Regex$Companion(null);
    @NotNull
    private final Pattern nativePattern;
    @Nullable
    private Set<? extends RegexOption> _options;

    @PublishedApi
    public Regex(@NotNull Pattern pattern) {
        Intrinsics.checkNotNullParameter(pattern, "nativePattern");
        this.nativePattern = pattern;
    }

    public Regex(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "pattern");
        Pattern pattern = Pattern.compile(string);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        this(pattern);
    }

    public Regex(@NotNull String string, @NotNull RegexOption regexOption) {
        Intrinsics.checkNotNullParameter(string, "pattern");
        Intrinsics.checkNotNullParameter(regexOption, "option");
        Pattern pattern = Pattern.compile(string, Regex$Companion.access$ensureUnicodeCase(Companion, regexOption.getValue()));
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        this(pattern);
    }

    public Regex(@NotNull String string, @NotNull Set<? extends RegexOption> set) {
        Intrinsics.checkNotNullParameter(string, "pattern");
        Intrinsics.checkNotNullParameter(set, "options");
        Pattern pattern = Pattern.compile(string, Regex$Companion.access$ensureUnicodeCase(Companion, RegexKt.access$toInt(set)));
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        this(pattern);
    }

    @NotNull
    public final String getPattern() {
        String string = this.nativePattern.pattern();
        Intrinsics.checkNotNullExpressionValue(string, "pattern(...)");
        return string;
    }

    @NotNull
    public final Set<RegexOption> getOptions() {
        Set<RegexOption> set = this._options;
        if (set == null) {
            Set<RegexOption> set2;
            int n = this.nativePattern.flags();
            EnumSet<RegexOption> enumSet = set2 = EnumSet.allOf(RegexOption.class);
            Intrinsics.checkNotNull(set2);
            CollectionsKt.retainAll((Iterable)enumSet, (Function1)new Regex$special$$inlined$fromInt$1(n));
            Set set3 = Collections.unmodifiableSet((Set)set2);
            Intrinsics.checkNotNullExpressionValue(set3, "unmodifiableSet(...)");
            Set set4 = set3;
            set2 = set3;
            this._options = set2;
            set = set4;
        }
        return set;
    }

    public final boolean matches(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "input");
        return this.nativePattern.matcher(charSequence).matches();
    }

    public final boolean containsMatchIn(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "input");
        return this.nativePattern.matcher(charSequence).find();
    }

    @Nullable
    public final MatchResult find(@NotNull CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "input");
        Matcher matcher = this.nativePattern.matcher(charSequence);
        Intrinsics.checkNotNullExpressionValue(matcher, "matcher(...)");
        return RegexKt.access$findNext(matcher, n, charSequence);
    }

    public static /* synthetic */ MatchResult find$default(Regex regex, CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.find(charSequence, n);
    }

    @NotNull
    public final Sequence<MatchResult> findAll(@NotNull CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "input");
        if (n < 0 || n > charSequence.length()) {
            throw new IndexOutOfBoundsException("Start index out of bounds: " + n + ", input length: " + charSequence.length());
        }
        return SequencesKt.generateSequence(() -> Regex.findAll$lambda$1(this, charSequence, n), (Function1)Regex$findAll$2.INSTANCE);
    }

    public static /* synthetic */ Sequence findAll$default(Regex regex, CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.findAll(charSequence, n);
    }

    @Nullable
    public final MatchResult matchEntire(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "input");
        Matcher matcher = this.nativePattern.matcher(charSequence);
        Intrinsics.checkNotNullExpressionValue(matcher, "matcher(...)");
        return RegexKt.access$matchEntire(matcher, charSequence);
    }

    @SinceKotlin(version="1.7")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    @Nullable
    public final MatchResult matchAt(@NotNull CharSequence charSequence, int n) {
        MatcherMatchResult matcherMatchResult;
        Intrinsics.checkNotNullParameter(charSequence, "input");
        Matcher matcher = this.nativePattern.matcher(charSequence).useAnchoringBounds(false).useTransparentBounds(true).region(n, charSequence.length());
        if (matcher.lookingAt()) {
            Intrinsics.checkNotNull(matcher);
            matcherMatchResult = new MatcherMatchResult(matcher, charSequence);
        } else {
            matcherMatchResult = null;
        }
        return matcherMatchResult;
    }

    @SinceKotlin(version="1.7")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    public final boolean matchesAt(@NotNull CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "input");
        return this.nativePattern.matcher(charSequence).useAnchoringBounds(false).useTransparentBounds(true).region(n, charSequence.length()).lookingAt();
    }

    @NotNull
    public final String replace(@NotNull CharSequence charSequence, @NotNull String string) {
        Intrinsics.checkNotNullParameter(charSequence, "input");
        Intrinsics.checkNotNullParameter(string, "replacement");
        String string2 = this.nativePattern.matcher(charSequence).replaceAll(string);
        Intrinsics.checkNotNullExpressionValue(string2, "replaceAll(...)");
        return string2;
    }

    @NotNull
    public final String replace(@NotNull CharSequence charSequence, @NotNull Function1<? super MatchResult, ? extends CharSequence> function1) {
        Intrinsics.checkNotNullParameter(charSequence, "input");
        Intrinsics.checkNotNullParameter(function1, "transform");
        MatchResult matchResult = Regex.find$default(this, charSequence, 0, 2, null);
        if (matchResult == null) {
            return ((Object)charSequence).toString();
        }
        MatchResult matchResult2 = matchResult;
        int n = 0;
        int n2 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        do {
            stringBuilder.append(charSequence, n, (int)matchResult2.getRange().getStart());
            stringBuilder.append(function1.invoke(matchResult2));
            n = matchResult2.getRange().getEndInclusive() + 1;
            matchResult2 = matchResult2.next();
        } while (n < n2 && matchResult2 != null);
        if (n < n2) {
            stringBuilder.append(charSequence, n, n2);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String replaceFirst(@NotNull CharSequence charSequence, @NotNull String string) {
        Intrinsics.checkNotNullParameter(charSequence, "input");
        Intrinsics.checkNotNullParameter(string, "replacement");
        String string2 = this.nativePattern.matcher(charSequence).replaceFirst(string);
        Intrinsics.checkNotNullExpressionValue(string2, "replaceFirst(...)");
        return string2;
    }

    @NotNull
    public final List<String> split(@NotNull CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "input");
        StringsKt.requireNonNegativeLimit(n);
        Matcher matcher = this.nativePattern.matcher(charSequence);
        if (n == 1 || !matcher.find()) {
            return CollectionsKt.listOf(((Object)charSequence).toString());
        }
        ArrayList<String> arrayList = new ArrayList<String>(n > 0 ? RangesKt.coerceAtMost(n, 10) : 10);
        int n2 = 0;
        --n;
        do {
            arrayList.add(((Object)charSequence.subSequence(n2, matcher.start())).toString());
            n2 = matcher.end();
        } while ((n < 0 || arrayList.size() != n) && matcher.find());
        arrayList.add(((Object)charSequence.subSequence(n2, charSequence.length())).toString());
        return arrayList;
    }

    public static /* synthetic */ List split$default(Regex regex, CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.split(charSequence, n);
    }

    @SinceKotlin(version="1.6")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    @NotNull
    public final Sequence<String> splitToSequence(@NotNull CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "input");
        StringsKt.requireNonNegativeLimit(n);
        return SequencesKt.sequence(new Regex$splitToSequence$1(this, charSequence, n, null));
    }

    public static /* synthetic */ Sequence splitToSequence$default(Regex regex, CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.splitToSequence(charSequence, n);
    }

    @NotNull
    public final String toString() {
        String string = this.nativePattern.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final Pattern toPattern() {
        return this.nativePattern;
    }

    private final Object writeReplace() {
        String string = this.nativePattern.pattern();
        Intrinsics.checkNotNullExpressionValue(string, "pattern(...)");
        return new Regex$Serialized(string, this.nativePattern.flags());
    }

    private static final MatchResult findAll$lambda$1(Regex regex, CharSequence charSequence, int n) {
        return regex.find(charSequence, n);
    }

    public static final /* synthetic */ Pattern access$getNativePattern$p(Regex regex) {
        return regex.nativePattern;
    }
}

