/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.time;

import me.spartacus04.stackablecuring.dependencies.stackablecuring.annotations.NotNull;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.KotlinNothingValueException;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.Metadata;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.SinceKotlin;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.internal.InlineOnly;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.functions.Function0;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.functions.Function1;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.Intrinsics;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.SourceDebugExtension;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.time.ExperimentalTime;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.time.Instant;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.time.InstantFormatException;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.time.UnboundLocalDateTime;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\f\n\u0002\u0010\u0015\n\u0002\b\u0006\u001a\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0003\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0003\u001a'\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0082\b\u001a'\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0082\b\u001a\u0010\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0014H\u0000\u001a\u0014\u0010&\u001a\u00020\u0014*\u00020\u00142\u0006\u0010$\u001a\u00020\u0001H\u0002\u001a\u0014\u0010,\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010-\u001a\u00020\u0014H\u0002\"\u001f\u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0000\u0010\u0005\"\u001f\u0010\u0006\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0004\u001a\u0004\b\u0006\u0010\u0005\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0014X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010#\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010)\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010*\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010+\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"isDistantPast", "", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/time/Instant;", "isDistantPast$annotations", "(Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/time/Instant;)V", "(Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/time/Instant;)Z", "isDistantFuture", "isDistantFuture$annotations", "DISTANT_PAST_SECONDS", "", "DISTANT_FUTURE_SECONDS", "MIN_SECOND", "MAX_SECOND", "parseIso", "isoString", "", "formatIso", "", "instant", "DAYS_PER_CYCLE", "", "DAYS_0000_TO_1970", "safeAddOrElse", "a", "b", "action", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/kotlin/Function0;", "", "safeMultiplyOrElse", "SECONDS_PER_HOUR", "SECONDS_PER_MINUTE", "HOURS_PER_DAY", "SECONDS_PER_DAY", "NANOS_PER_SECOND", "NANOS_PER_MILLI", "MILLIS_PER_SECOND", "isLeapYear", "year", "monthLength", "POWERS_OF_TEN", "", "asciiDigitPositionsInIsoStringAfterYear", "colonsInIsoOffsetString", "asciiDigitsInIsoOffsetString", "truncateForErrorMessage", "maxLength", "me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin-stdlib"})
@SourceDebugExtension(value={"SMAP\nInstant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Instant.kt\nkotlin/time/InstantKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,799:1\n1#2:800\n*E\n"})
public final class InstantKt {
    private static final long DISTANT_PAST_SECONDS = -3217862419201L;
    private static final long DISTANT_FUTURE_SECONDS = 3093527980800L;
    private static final long MIN_SECOND = -31557014167219200L;
    private static final long MAX_SECOND = 31556889864403199L;
    private static final int DAYS_PER_CYCLE = 146097;
    private static final int DAYS_0000_TO_1970 = 719528;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_DAY = 86400;
    public static final int NANOS_PER_SECOND = 1000000000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int MILLIS_PER_SECOND = 1000;
    @NotNull
    private static final int[] POWERS_OF_TEN;
    @NotNull
    private static final int[] asciiDigitPositionsInIsoStringAfterYear;
    @NotNull
    private static final int[] colonsInIsoOffsetString;
    @NotNull
    private static final int[] asciiDigitsInIsoOffsetString;

    private static final boolean isDistantPast(Instant instant) {
        Intrinsics.checkNotNullParameter(instant, "<this>");
        return instant.compareTo(Instant.Companion.getDISTANT_PAST()) <= 0;
    }

    @SinceKotlin(version="2.1")
    @ExperimentalTime
    @InlineOnly
    public static /* synthetic */ void isDistantPast$annotations(Instant instant) {
    }

    private static final boolean isDistantFuture(Instant instant) {
        Intrinsics.checkNotNullParameter(instant, "<this>");
        return instant.compareTo(Instant.Companion.getDISTANT_FUTURE()) >= 0;
    }

    @SinceKotlin(version="2.1")
    @ExperimentalTime
    @InlineOnly
    public static /* synthetic */ void isDistantFuture$annotations(Instant instant) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @ExperimentalTime
    private static final Instant parseIso(CharSequence charSequence) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n72;
        int n8;
        int n9;
        CharSequence charSequence2 = charSequence;
        int n10 = 0;
        if (!(charSequence2.length() > 0)) {
            String string = "An empty string is not a valid Instant";
            throw new IllegalArgumentException(string.toString());
        }
        int n11 = charSequence2.charAt(0);
        switch (n11) {
            case 43: 
            case 45: {
                ++n10;
                n9 = n11;
                break;
            }
            default: {
                n9 = 32;
            }
        }
        int n12 = n9;
        n11 = n10;
        int n13 = 0;
        while (n10 < charSequence2.length()) {
            n8 = charSequence2.charAt(n10);
            boolean bl = 48 <= n8 ? n8 < 58 : false;
            if (!bl) break;
            n13 = n13 * 10 + (charSequence2.charAt(n10) - 48);
            ++n10;
        }
        if ((n8 = n10 - n11) > 10) {
            InstantKt.parseIso$parseFailure(charSequence, "Expected at most 10 digits for the year number, got " + n8 + " digits");
            throw new KotlinNothingValueException();
        }
        if (n8 == 10 && Intrinsics.compare(charSequence2.charAt(n11), 50) >= 0) {
            InstantKt.parseIso$parseFailure(charSequence, "Expected at most 9 digits for the year number or year 1000000000, got " + n8 + " digits");
            throw new KotlinNothingValueException();
        }
        if (n8 < 4) {
            InstantKt.parseIso$parseFailure(charSequence, "The year number must be padded to 4 digits, got " + n8 + " digits");
            throw new KotlinNothingValueException();
        }
        if (n12 == 43 && n8 == 4) {
            InstantKt.parseIso$parseFailure(charSequence, "The '+' sign at the start is only valid for year numbers longer than 4 digits");
            throw new KotlinNothingValueException();
        }
        if (n12 == 32 && n8 != 4) {
            InstantKt.parseIso$parseFailure(charSequence, "A '+' or '-' sign is required for year numbers longer than 4 digits");
            throw new KotlinNothingValueException();
        }
        int n14 = n12 = n12 == 45 ? -n13 : n13;
        if (charSequence2.length() < n10 + 16) {
            InstantKt.parseIso$parseFailure(charSequence, "The input string is too short");
            throw new KotlinNothingValueException();
        }
        InstantKt.parseIso$expect(charSequence, "'-'", n10, InstantKt::parseIso$lambda$1);
        InstantKt.parseIso$expect(charSequence, "'-'", n10 + 3, InstantKt::parseIso$lambda$2);
        InstantKt.parseIso$expect(charSequence, "'T' or 't'", n10 + 6, InstantKt::parseIso$lambda$3);
        InstantKt.parseIso$expect(charSequence, "':'", n10 + 9, InstantKt::parseIso$lambda$4);
        InstantKt.parseIso$expect(charSequence, "':'", n10 + 12, InstantKt::parseIso$lambda$5);
        for (int n72 : asciiDigitPositionsInIsoStringAfterYear) {
            InstantKt.parseIso$expect(charSequence, "an ASCII digit", n10 + n72, InstantKt::parseIso$lambda$6);
        }
        int n15 = InstantKt.parseIso$twoDigitNumber(charSequence2, n10 + 1);
        n13 = InstantKt.parseIso$twoDigitNumber(charSequence2, n10 + 4);
        n8 = InstantKt.parseIso$twoDigitNumber(charSequence2, n10 + 7);
        n72 = InstantKt.parseIso$twoDigitNumber(charSequence2, n10 + 10);
        int n16 = InstantKt.parseIso$twoDigitNumber(charSequence2, n10 + 13);
        if (charSequence2.charAt(n10 + 15) != '.') {
            n10 += 15;
            n6 = 0;
        } else {
            n5 = 0;
            for (n10 = n4 = n10 + 16; n10 < charSequence2.length(); ++n10) {
                n3 = charSequence2.charAt(n10);
                boolean bl = 48 <= n3 ? n3 < 58 : false;
                if (!bl) break;
                n5 = n5 * 10 + (charSequence2.charAt(n10) - 48);
            }
            if (!((n3 = n10 - n4) > 0 ? n3 < 10 : false)) {
                InstantKt.parseIso$parseFailure(charSequence, "1..9 digits are supported for the fraction of the second, got " + n3 + " digits");
                throw new KotlinNothingValueException();
            }
            n6 = n2 = n5 * POWERS_OF_TEN[9 - n3];
        }
        if (n10 >= charSequence2.length()) {
            InstantKt.parseIso$parseFailure(charSequence, "The UTC offset at the end of the string is missing");
            throw new KotlinNothingValueException();
        }
        n5 = charSequence2.charAt(n10);
        switch (n5) {
            case 90: 
            case 122: {
                if (charSequence2.length() != n10 + 1) {
                    InstantKt.parseIso$parseFailure(charSequence, "Extra text after the instant at position " + (n10 + 1));
                    throw new KotlinNothingValueException();
                }
                n = 0;
                break;
            }
            case 43: 
            case 45: {
                int n17;
                int n18;
                n3 = charSequence2.length() - n10;
                if (n3 > 9) {
                    CharSequence charSequence3 = charSequence2;
                    int n19 = charSequence3.length();
                    InstantKt.parseIso$parseFailure(charSequence, "The UTC offset string \"" + InstantKt.truncateForErrorMessage(((Object)charSequence3.subSequence(n10, n19)).toString(), 16) + "\" is too long");
                    throw new KotlinNothingValueException();
                }
                if (n3 % 3 != 0) {
                    CharSequence charSequence4 = charSequence2;
                    int n20 = charSequence4.length();
                    InstantKt.parseIso$parseFailure(charSequence, "Invalid UTC offset string \"" + ((Object)charSequence4.subSequence(n10, n20)).toString() + '\"');
                    throw new KotlinNothingValueException();
                }
                for (int n21 : colonsInIsoOffsetString) {
                    if (n10 + n21 >= charSequence2.length()) break;
                    if (charSequence2.charAt(n10 + n21) == ':') continue;
                    InstantKt.parseIso$parseFailure(charSequence, "Expected ':' at index " + (n10 + n21) + ", got '" + charSequence2.charAt(n10 + n21) + '\'');
                    throw new KotlinNothingValueException();
                }
                for (int n21 : asciiDigitsInIsoOffsetString) {
                    if (n10 + n21 >= charSequence2.length()) break;
                    n18 = charSequence2.charAt(n10 + n21);
                    if (48 <= n18 ? n18 < 58 : false) continue;
                    InstantKt.parseIso$parseFailure(charSequence, "Expected an ASCII digit at index " + (n10 + n21) + ", got '" + charSequence2.charAt(n10 + n21) + '\'');
                    throw new KotlinNothingValueException();
                }
                n4 = InstantKt.parseIso$twoDigitNumber(charSequence2, n10 + 1);
                int n22 = n3 > 3 ? InstantKt.parseIso$twoDigitNumber(charSequence2, n10 + 4) : 0;
                int n23 = n17 = n3 > 6 ? InstantKt.parseIso$twoDigitNumber(charSequence2, n10 + 7) : 0;
                if (n22 > 59) {
                    InstantKt.parseIso$parseFailure(charSequence, "Expected offset-minute-of-hour in 0..59, got " + n22);
                    throw new KotlinNothingValueException();
                }
                if (n17 > 59) {
                    InstantKt.parseIso$parseFailure(charSequence, "Expected offset-second-of-minute in 0..59, got " + n17);
                    throw new KotlinNothingValueException();
                }
                if (n4 > 17 && (n4 != 18 || n22 != 0 || n17 != 0)) {
                    CharSequence charSequence5 = charSequence2;
                    n18 = charSequence5.length();
                    InstantKt.parseIso$parseFailure(charSequence, "Expected an offset in -18:00..+18:00, got " + ((Object)charSequence5.subSequence(n10, n18)).toString());
                    throw new KotlinNothingValueException();
                }
                n = (n4 * 3600 + n22 * 60 + n17) * (n5 == 45 ? -1 : 1);
                break;
            }
            default: {
                InstantKt.parseIso$parseFailure(charSequence, "Expected the UTC offset at position " + n10 + ", got '" + (char)n5 + '\'');
                throw new KotlinNothingValueException();
            }
        }
        n4 = n;
        if (!(n15 > 0 ? n15 < 13 : false)) {
            InstantKt.parseIso$parseFailure(charSequence, "Expected a month number in 1..12, got " + n15);
            throw new KotlinNothingValueException();
        }
        if (!(n13 > 0 ? n13 <= InstantKt.monthLength(n15, InstantKt.isLeapYear(n12)) : false)) {
            InstantKt.parseIso$parseFailure(charSequence, "Expected a valid day-of-month for month " + n15 + " of year " + n12 + ", got " + n13);
            throw new KotlinNothingValueException();
        }
        if (n8 > 23) {
            InstantKt.parseIso$parseFailure(charSequence, "Expected hour in 0..23, got " + n8);
            throw new KotlinNothingValueException();
        }
        if (n72 > 59) {
            InstantKt.parseIso$parseFailure(charSequence, "Expected minute-of-hour in 0..59, got " + n72);
            throw new KotlinNothingValueException();
        }
        if (n16 > 59) {
            InstantKt.parseIso$parseFailure(charSequence, "Expected second-of-minute in 0..59, got " + n16);
            throw new KotlinNothingValueException();
        }
        return new UnboundLocalDateTime(n12, n15, n13, n8, n72, n16, n2).toInstant(n4);
    }

    @ExperimentalTime
    private static final String formatIso(Instant object) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        object = UnboundLocalDateTime.Companion.fromInstant((Instant)object);
        StringBuilder stringBuilder3 = stringBuilder2;
        int n = ((UnboundLocalDateTime)object).getYear();
        if (Math.abs(n) < 1000) {
            StringBuilder stringBuilder4 = new StringBuilder();
            if (n >= 0) {
                Intrinsics.checkNotNullExpressionValue(stringBuilder4.append(n + 10000).deleteCharAt(0), "deleteCharAt(...)");
            } else {
                Intrinsics.checkNotNullExpressionValue(stringBuilder4.append(n - 10000).deleteCharAt(1), "deleteCharAt(...)");
            }
            stringBuilder3.append((CharSequence)stringBuilder4);
        } else {
            if (n >= 10000) {
                stringBuilder3.append('+');
            }
            stringBuilder3.append(n);
        }
        stringBuilder2.append('-');
        InstantKt.formatIso$lambda$8$appendTwoDigits(stringBuilder2, stringBuilder2, ((UnboundLocalDateTime)object).getMonth());
        stringBuilder2.append('-');
        InstantKt.formatIso$lambda$8$appendTwoDigits(stringBuilder2, stringBuilder2, ((UnboundLocalDateTime)object).getDay());
        stringBuilder2.append('T');
        InstantKt.formatIso$lambda$8$appendTwoDigits(stringBuilder2, stringBuilder2, ((UnboundLocalDateTime)object).getHour());
        stringBuilder2.append(':');
        InstantKt.formatIso$lambda$8$appendTwoDigits(stringBuilder2, stringBuilder2, ((UnboundLocalDateTime)object).getMinute());
        stringBuilder2.append(':');
        InstantKt.formatIso$lambda$8$appendTwoDigits(stringBuilder2, stringBuilder2, ((UnboundLocalDateTime)object).getSecond());
        if (((UnboundLocalDateTime)object).getNanosecond() != 0) {
            stringBuilder2.append('.');
            n = 0;
            while (((UnboundLocalDateTime)object).getNanosecond() % POWERS_OF_TEN[n + 1] == 0) {
                ++n;
            }
            int n2 = n;
            n = n2 - n2 % 3;
            int n3 = ((UnboundLocalDateTime)object).getNanosecond() / POWERS_OF_TEN[n];
            object = String.valueOf(n3 + POWERS_OF_TEN[9 - n]);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type java.lang.String");
            String string = ((String)object).substring(1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            stringBuilder2.append(string);
        }
        stringBuilder2.append('Z');
        return stringBuilder.toString();
    }

    private static final long safeAddOrElse(long l, long l2, Function0 function0) {
        long l3 = l + l2;
        if ((l ^ l3) < 0L && (l ^ l2) >= 0L) {
            function0.invoke();
            throw new KotlinNothingValueException();
        }
        return l3;
    }

    private static final long safeMultiplyOrElse(long l, long l2, Function0 function0) {
        if (l2 == 1L) {
            return l;
        }
        if (l == 1L) {
            return l2;
        }
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        long l3 = l * l2;
        if (l3 / l2 != l || l == Long.MIN_VALUE && l2 == -1L || l2 == Long.MIN_VALUE && l == -1L) {
            function0.invoke();
            throw new KotlinNothingValueException();
        }
        return l3;
    }

    public static final boolean isLeapYear(int n) {
        return (n & 3) == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    private static final int monthLength(int n, boolean bl) {
        switch (n) {
            case 2: {
                if (bl) {
                    return 29;
                }
                return 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    private static final String truncateForErrorMessage(CharSequence charSequence, int n) {
        if (charSequence.length() <= n) {
            return ((Object)charSequence).toString();
        }
        return ((Object)charSequence.subSequence(0, n)).toString() + "...";
    }

    private static final Void parseIso$parseFailure(CharSequence charSequence, String string) {
        throw new InstantFormatException(string + " when parsing an Instant from \"" + InstantKt.truncateForErrorMessage(charSequence, 64) + '\"');
    }

    private static final void parseIso$expect(CharSequence charSequence, String string, int n, Function1<? super Character, Boolean> function1) {
        char c = charSequence.charAt(n);
        if (!function1.invoke(Character.valueOf(c)).booleanValue()) {
            InstantKt.parseIso$parseFailure(charSequence, "Expected " + string + ", but got '" + c + "' at position " + n);
            throw new KotlinNothingValueException();
        }
    }

    private static final boolean parseIso$lambda$1(char c) {
        return c == '-';
    }

    private static final boolean parseIso$lambda$2(char c) {
        return c == '-';
    }

    private static final boolean parseIso$lambda$3(char c) {
        return c == 'T' || c == 't';
    }

    private static final boolean parseIso$lambda$4(char c) {
        return c == ':';
    }

    private static final boolean parseIso$lambda$5(char c) {
        return c == ':';
    }

    private static final boolean parseIso$lambda$6(char c) {
        if ('0' <= c) {
            return c < ':';
        }
        return false;
    }

    private static final int parseIso$twoDigitNumber(CharSequence charSequence, int n) {
        return (charSequence.charAt(n) - 48) * 10 + (charSequence.charAt(n + 1) - 48);
    }

    private static final void formatIso$lambda$8$appendTwoDigits(Appendable appendable, StringBuilder stringBuilder, int n) {
        if (n < 10) {
            appendable.append('0');
        }
        stringBuilder.append(n);
    }

    public static final /* synthetic */ String access$formatIso(Instant instant) {
        return InstantKt.formatIso(instant);
    }

    public static final /* synthetic */ Instant access$parseIso(CharSequence charSequence) {
        return InstantKt.parseIso(charSequence);
    }

    static {
        int[] nArray = new int[10];
        int[] nArray2 = nArray;
        nArray[0] = 1;
        nArray2[1] = 10;
        nArray2[2] = 100;
        nArray2[3] = 1000;
        nArray2[4] = 10000;
        nArray2[5] = 100000;
        nArray2[6] = 1000000;
        nArray2[7] = 10000000;
        nArray2[8] = 100000000;
        nArray2[9] = 1000000000;
        POWERS_OF_TEN = nArray2;
        int[] nArray3 = new int[10];
        nArray2 = nArray3;
        nArray3[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 4;
        nArray2[3] = 5;
        nArray2[4] = 7;
        nArray2[5] = 8;
        nArray2[6] = 10;
        nArray2[7] = 11;
        nArray2[8] = 13;
        nArray2[9] = 14;
        asciiDigitPositionsInIsoStringAfterYear = nArray2;
        int[] nArray4 = new int[2];
        nArray2 = nArray4;
        nArray4[0] = 3;
        nArray2[1] = 6;
        colonsInIsoOffsetString = nArray2;
        int[] nArray5 = new int[6];
        nArray2 = nArray5;
        nArray5[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 4;
        nArray2[3] = 5;
        nArray2[4] = 7;
        nArray2[5] = 8;
        asciiDigitsInIsoOffsetString = nArray2;
    }
}

