/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.stackablecuring.listeners;

import de.tr7zw.nbtapi.NBT;
import de.tr7zw.nbtapi.NBTCompoundList;
import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import de.tr7zw.nbtapi.iface.ReadableNBT;
import de.tr7zw.nbtapi.iface.ReadableNBTList;
import java.util.ArrayList;
import java.util.Locale;
import me.spartacus04.stackablecuring.StackableCuring;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.annotations.NotNull;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.colosseum.ColosseumPlugin;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.colosseum.listeners.ColosseumListener;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.Metadata;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.Intrinsics;
import me.spartacus04.stackablecuring.dependencies.stackablecuring.kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lme/spartacus04/stackablecuring/listeners/VillagerEvent;", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/listeners/ColosseumListener;", "plugin", "Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/ColosseumPlugin;", "<init>", "(Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/ColosseumPlugin;)V", "getPlugin", "()Lme/spartacus04/stackablecuring/dependencies/stackablecuring/colosseum/ColosseumPlugin;", "onPlayerInteractAtEntityEvent", "", "e", "Lorg/bukkit/event/player/PlayerInteractAtEntityEvent;", "onVillagerTransformEvent", "Lorg/bukkit/event/entity/EntityTransformEvent;", "getMajorPositiveGossip", "", "villager", "Lorg/bukkit/entity/Entity;", "offlinePlayer", "Lorg/bukkit/OfflinePlayer;", "getProfessionKey", "", "Lorg/bukkit/entity/ZombieVillager;", "stackablecuring"})
@SourceDebugExtension(value={"SMAP\nVillagerEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VillagerEvent.kt\nme/spartacus04/stackablecuring/listeners/VillagerEvent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1869#2,2:96\n*S KotlinDebug\n*F\n+ 1 VillagerEvent.kt\nme/spartacus04/stackablecuring/listeners/VillagerEvent\n*L\n30#1:96,2\n*E\n"})
public final class VillagerEvent
extends ColosseumListener {
    @NotNull
    private final ColosseumPlugin plugin;

    public VillagerEvent(@NotNull ColosseumPlugin colosseumPlugin) {
        Intrinsics.checkNotNullParameter((Object)colosseumPlugin, "plugin");
        super(colosseumPlugin);
        this.plugin = colosseumPlugin;
    }

    @NotNull
    public final ColosseumPlugin getPlugin() {
        return this.plugin;
    }

    @EventHandler
    public final void onPlayerInteractAtEntityEvent(@NotNull PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        Intrinsics.checkNotNullParameter(playerInteractAtEntityEvent, "e");
        if (!StackableCuring.Companion.getCONFIG().getUNINSTALL_MODE()) {
            return;
        }
        Villager villager = (playerInteractAtEntityEvent = playerInteractAtEntityEvent.getRightClicked()) instanceof Villager ? (Villager)playerInteractAtEntityEvent : null;
        if (villager == null) {
            return;
        }
        playerInteractAtEntityEvent = villager;
        NBT.modify((Entity)((Entity)villager), VillagerEvent::onPlayerInteractAtEntityEvent$lambda$1);
    }

    @EventHandler
    public final void onVillagerTransformEvent(@NotNull EntityTransformEvent entityTransformEvent) {
        Intrinsics.checkNotNullParameter(entityTransformEvent, "e");
        if (StackableCuring.Companion.getCONFIG().getUNINSTALL_MODE()) {
            return;
        }
        if (entityTransformEvent.getTransformReason() != EntityTransformEvent.TransformReason.CURED) {
            return;
        }
        Entity entity = entityTransformEvent.getEntity();
        ZombieVillager zombieVillager = entity instanceof ZombieVillager ? (ZombieVillager)entity : null;
        if (zombieVillager == null) {
            return;
        }
        ZombieVillager zombieVillager2 = zombieVillager;
        Entity entity2 = entityTransformEvent.getTransformedEntity();
        Villager villager = entity2 instanceof Villager ? (Villager)entity2 : null;
        if (villager == null) {
            return;
        }
        entityTransformEvent = villager;
        OfflinePlayer offlinePlayer = zombieVillager2.getConversionPlayer();
        if (offlinePlayer == null) {
            return;
        }
        entity = offlinePlayer;
        ArrayList<String> arrayList = StackableCuring.Companion.getCONFIG().getVILLAGER_BLACKLIST();
        String string = this.getProfessionKey(zombieVillager2).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        if (arrayList.contains(string)) {
            return;
        }
        int n = this.getMajorPositiveGossip((Entity)zombieVillager2, (OfflinePlayer)entity);
        if (n == 0) {
            return;
        }
        this.plugin.getScheduler().runTaskLater(() -> VillagerEvent.onVillagerTransformEvent$lambda$3((Villager)entityTransformEvent, (OfflinePlayer)entity, n), 1L);
    }

    public final int getMajorPositiveGossip(@NotNull Entity entity, @NotNull OfflinePlayer offlinePlayer) {
        Intrinsics.checkNotNullParameter(entity, "villager");
        Intrinsics.checkNotNullParameter(offlinePlayer, "offlinePlayer");
        Object object = NBT.get((Entity)entity, arg_0 -> VillagerEvent.getMajorPositiveGossip$lambda$5(offlinePlayer, arg_0));
        Intrinsics.checkNotNullExpressionValue(object, "get(...)");
        return ((Number)object).intValue();
    }

    private final String getProfessionKey(ZombieVillager object) {
        object = object.getClass().getMethod("getVillagerProfession", new Class[0]).invoke(object, new Object[0]);
        object = object.getClass().getMethod("getKey", new Class[0]).invoke(object, new Object[0]);
        object = object.getClass().getMethod("getKey", new Class[0]).invoke(object, new Object[0]);
        return object.toString();
    }

    private static final void onPlayerInteractAtEntityEvent$lambda$1(ReadWriteNBT object) {
        object = object.getCompoundList("Gossips");
        Intrinsics.checkNotNull(object);
        object = (Iterable)object;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            if (!Intrinsics.areEqual((object2 = (ReadWriteNBT)object2).getString("Type"), "major_positive") || object2.getInteger("Value") <= 20) continue;
            object2.setInteger("Value", Integer.valueOf(20));
        }
    }

    private static final void onVillagerTransformEvent$lambda$3$lambda$2(OfflinePlayer offlinePlayer, int n, ReadWriteNBT readWriteNBT) {
        readWriteNBT = readWriteNBT.getCompoundList("Gossips");
        int n2 = readWriteNBT.size();
        for (int i = 0; i < n2; ++i) {
            if (!Intrinsics.areEqual(((ReadWriteNBT)readWriteNBT.get(i)).getString("Type"), "major_positive") || !Intrinsics.areEqual(((ReadWriteNBT)readWriteNBT.get(i)).getUUID("Target"), offlinePlayer.getUniqueId())) continue;
            ((ReadWriteNBT)readWriteNBT.get(i)).setInteger("Value", Integer.valueOf(n + 20));
        }
    }

    private static final void onVillagerTransformEvent$lambda$3(Villager villager, OfflinePlayer offlinePlayer, int n) {
        NBT.modify((Entity)((Entity)villager), arg_0 -> VillagerEvent.onVillagerTransformEvent$lambda$3$lambda$2(offlinePlayer, n, arg_0));
    }

    private static final Integer getMajorPositiveGossip$lambda$5(OfflinePlayer offlinePlayer, ReadableNBT object) {
        Object v1;
        block1: {
            ReadableNBTList readableNBTList = object.getCompoundList("Gossips");
            Intrinsics.checkNotNull(readableNBTList, "null cannot be cast to non-null type de.tr7zw.nbtapi.NBTCompoundList");
            object = (NBTCompoundList)readableNBTList;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                ReadWriteNBT readWriteNBT = (ReadWriteNBT)e;
                if (!(Intrinsics.areEqual(readWriteNBT.getString("Type"), "major_positive") && Intrinsics.areEqual(readWriteNBT.getUUID("Target"), offlinePlayer.getUniqueId()))) continue;
                v1 = e;
                break block1;
            }
            v1 = null;
        }
        offlinePlayer = v1;
        Object object2 = offlinePlayer;
        return offlinePlayer != null && (object2 = object2.getInteger("Value")) != null ? (Integer)object2 : 0;
    }
}

