/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.mcft;

import com.github.squi2rel.mcft.FTModel;
import com.github.squi2rel.mcft.MCFTClient;
import com.github.squi2rel.mcft.services.OSC;
import java.util.Random;

public class AutoBlink {
    public static boolean enabled;
    private static float blinkTime;
    private static float blinkDuration;
    private static float blinkInterval;
    private static boolean blinking;
    private static float eyeOpenness;
    private static float last;
    private static final Random random;
    private static long lastUpdateTime;

    public static void update() {
        if (!MCFTClient.config.autoBlink || MCFTClient.config.autoSwitchBlink && OSC.lastReceived != lastUpdateTime && System.currentTimeMillis() - OSC.lastReceived < 3000L) {
            enabled = false;
            return;
        }
        enabled = true;
        long currentTime = System.currentTimeMillis();
        float delta = currentTime - lastUpdateTime;
        lastUpdateTime = currentTime;
        last += delta;
        if (!blinking && last >= blinkInterval) {
            blinking = true;
            blinkTime = 0.0f;
            last = 0.0f;
            blinkDuration = MCFTClient.config.blinkDuration * 1000.0f + random.nextFloat() * MCFTClient.config.blinkDurationFix * 1000.0f;
            blinkInterval = MCFTClient.config.blinkInterval * 1000.0f + random.nextFloat() * MCFTClient.config.blinkIntervalFix * 1000.0f;
        }
        if (blinking) {
            float t = (blinkTime += delta) / blinkDuration;
            if (t >= 1.0f) {
                blinking = false;
                eyeOpenness = 1.0f;
            } else {
                eyeOpenness = (float)(1.0 - Math.sin((double)t * Math.PI));
            }
        }
        FTModel.model.eyeL.percent = FTModel.model.eyeR.percent = eyeOpenness * MCFTClient.config.blinkMaxY;
        OSC.lastReceived = lastUpdateTime;
    }

    static {
        blinkTime = 0.0f;
        blinkDuration = 300.0f;
        blinkInterval = 3000.0f;
        blinking = false;
        eyeOpenness = 1.0f;
        last = 0.0f;
        random = new Random();
        lastUpdateTime = System.currentTimeMillis();
    }
}

