/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.mcft;

import com.github.squi2rel.mcft.tracking.EyeTrackingRect;
import com.github.squi2rel.mcft.tracking.MouthTrackingRect;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.class_3532;

public class FTModel {
    public static FTModel model;
    public EyeTrackingRect eyeR = new EyeTrackingRect(0.0f, 0.0f, 0.0f, 0.0f);
    public EyeTrackingRect eyeL = new EyeTrackingRect(0.0f, 0.0f, 0.0f, 0.0f);
    public MouthTrackingRect mouth = new MouthTrackingRect(0.0f, 0.0f, 0.0f, 0.0f);
    public boolean isFlat = false;
    public transient boolean enabled = false;
    public transient long lastReceived = 0L;

    public FTModel() {
    }

    public FTModel(EyeTrackingRect eyeR, EyeTrackingRect eyeL, MouthTrackingRect mouth, boolean isFlat) {
        this.eyeR = eyeR;
        this.eyeL = eyeL;
        this.mouth = mouth;
        this.isFlat = isFlat;
    }

    public void update(float fps) {
        float delta = class_3532.method_15363((float)((float)System.currentTimeMillis() - (float)this.lastReceived / 1000.0f * fps), (float)0.0f, (float)1.0f);
        this.eyeR.update(delta);
        this.eyeL.update(delta);
        if (!this.isFlat) {
            this.mouth.update(delta);
        }
    }

    public boolean active() {
        return System.currentTimeMillis() - this.lastReceived < 3000L;
    }

    public void readSync(byte[] data) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])data);
        try {
            this.eyeR.readSync(buf);
            this.eyeL.readSync(buf);
            this.mouth.readSync(buf);
            if (buf.readableBytes() != 0) {
                throw new IllegalArgumentException("buffer remaining " + buf.readableBytes() + " bytes");
            }
            this.lastReceived = System.currentTimeMillis();
        }
        finally {
            buf.release();
        }
    }

    public void validate(boolean init) {
        this.eyeR.validate(init);
        this.eyeL.validate(init);
        this.mouth.validate(init);
    }
}

