/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.mcft;

import com.github.squi2rel.mcft.FTModel;
import com.github.squi2rel.mcft.Platform;
import com.github.squi2rel.mcft.ServerConfig;
import com.github.squi2rel.mcft.ServerPacketHandler;
import com.github.squi2rel.mcft.network.ConfigPayload;
import com.github.squi2rel.mcft.network.TrackingParamsPayload;
import com.github.squi2rel.mcft.network.TrackingUpdatePayload;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1074;
import net.minecraft.class_2374;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCFT {
    public static final String MOD_ID = "mcft";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mcft");
    public static ConcurrentHashMap<UUID, FTModel> models = new ConcurrentHashMap();
    public static String version = Platform.getVersion();
    public static Path configPath = Platform.getConfigPath();
    public static ServerConfig config;

    public static void onInitialize() {
        config = MCFT.loadConfig(ServerConfig.class, configPath);
        ServerPacketHandler.registerC2S(TrackingParamsPayload.class, TrackingParamsPayload.ID, TrackingParamsPayload.CODEC, (payload, p) -> {
            FTModel old = models.get(p.method_5667());
            if (old == null) {
                LOGGER.info(class_1074.method_4662((String)"mcft.logging.playerconnected", (Object[])new Object[]{Objects.requireNonNull(p.method_5476()).getString()}));
            }
            FTModel model = new FTModel(payload.eyeR(), payload.eyeL(), payload.mouth(), payload.flat());
            model.validate(true);
            if (old != null) {
                model.enabled = old.enabled;
            }
            models.put(p.method_5667(), model);
            if (model.enabled) {
                TrackingParamsPayload packet = new TrackingParamsPayload(p.method_5667(), model.eyeR, model.eyeL, model.mouth, model.isFlat);
                for (class_3222 player : Objects.requireNonNull(p.method_5682()).method_3760().method_14571()) {
                    ServerPacketHandler.sendS2C(player, packet);
                }
            }
        });
        ServerPacketHandler.registerC2S(TrackingUpdatePayload.class, TrackingUpdatePayload.ID, TrackingUpdatePayload.CODEC, (payload, p) -> {
            Record packet;
            FTModel model = models.get(p.method_5667());
            if (model == null || System.currentTimeMillis() - model.lastReceived + 10L < (long)(1000 / MCFT.config.fps)) {
                return;
            }
            model.readSync(payload.data());
            model.validate(false);
            if (!model.enabled) {
                model.enabled = true;
                LOGGER.info(class_1074.method_4662((String)"mcft.logging.oscreceived", (Object[])new Object[]{Objects.requireNonNull(p.method_5476()).getString()}));
                packet = new TrackingParamsPayload(p.method_5667(), model.eyeR, model.eyeL, model.mouth, model.isFlat);
                for (class_3222 player2 : Objects.requireNonNull(p.method_5682()).method_3760().method_14571()) {
                    ServerPacketHandler.sendS2C(player2, packet);
                }
            }
            packet = new TrackingUpdatePayload(p.method_5667(), payload.data());
            for (class_3222 player2 : p.method_51469().method_18766(player -> player.method_19538().method_24802((class_2374)p.method_19538(), (double)MCFT.config.syncRadius))) {
                ServerPacketHandler.sendS2C(player2, packet);
            }
        });
        Platform.register();
    }

    public static void onPlayerJoin(class_3222 player) {
        models.forEach((u, m) -> {
            if (m.enabled) {
                ServerPacketHandler.sendS2C(player, new TrackingParamsPayload((UUID)u, m.eyeR, m.eyeL, m.mouth, m.isFlat));
            }
        });
        ServerPacketHandler.sendS2C(player, new ConfigPayload(version, MCFT.config.fps));
    }

    public static void onPlayerLeave(class_3222 player) {
        models.remove(player.method_5667());
    }

    public static <T> T loadConfig(Class<T> clazz, Path path) {
        try {
            return (T)new Gson().fromJson(Files.readString(path), clazz);
        }
        catch (Exception e) {
            try {
                MCFT.saveConfig(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), path);
                return (T)new Gson().fromJson(Files.readString(path), clazz);
            }
            catch (Exception ex) {
                RuntimeException th = new RuntimeException("Failed to load config file", ex);
                th.addSuppressed(e);
                throw th;
            }
        }
    }

    public static void saveConfig(Object config, Path path) {
        try {
            Files.writeString(path, (CharSequence)new Gson().toJson(config), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

