/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.mcft;

import com.github.squi2rel.mcft.AutoBlink;
import com.github.squi2rel.mcft.ClientPacketHandler;
import com.github.squi2rel.mcft.Config;
import com.github.squi2rel.mcft.FTClient;
import com.github.squi2rel.mcft.FTModel;
import com.github.squi2rel.mcft.MCFT;
import com.github.squi2rel.mcft.Platform;
import com.github.squi2rel.mcft.network.ConfigPayload;
import com.github.squi2rel.mcft.network.TrackingParamsPayload;
import com.github.squi2rel.mcft.network.TrackingUpdatePayload;
import com.github.squi2rel.mcft.services.HTTP;
import com.github.squi2rel.mcft.services.OSC;
import com.github.squi2rel.mcft.ui.UVGridScreen;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.commons.lang3.StringUtils;

@Environment(value=EnvType.CLIENT)
public class MCFTClient {
    public static final class_310 MC = class_310.method_1551();
    private static long lastSync = System.currentTimeMillis();
    public static int fps = -1;
    public static boolean configScreen = false;
    public static boolean connected = false;
    public static HashMap<UUID, FTModel> uuidToModel = new HashMap();
    public static Config config;
    public static final Path configPath;

    public static void onInitializeClient() {
        config = MCFT.loadConfig(Config.class, configPath);
        FTModel.model = MCFTClient.config.model;
        FTModel.model.eyeL.rawPos.set(MCFTClient.config.eyeOffsetXL, MCFTClient.config.eyeOffsetYL);
        FTModel.model.eyeR.rawPos.set(MCFTClient.config.eyeOffsetXR, MCFTClient.config.eyeOffsetYR);
        try {
            HTTP.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ClientPacketHandler.registerS2C(TrackingParamsPayload.class, TrackingParamsPayload.ID, TrackingParamsPayload.CODEC, p -> MC.execute(() -> uuidToModel.put(p.player(), new FTModel(p.eyeR(), p.eyeL(), p.mouth(), p.flat()))));
        ClientPacketHandler.registerS2C(TrackingUpdatePayload.class, TrackingUpdatePayload.ID, TrackingUpdatePayload.CODEC, p -> MC.execute(() -> {
            FTModel model = uuidToModel.get(p.player());
            if (model == null || model == FTModel.model) {
                return;
            }
            model.readSync(p.data());
        }));
        ClientPacketHandler.registerS2C(ConfigPayload.class, ConfigPayload.ID, ConfigPayload.CODEC, p -> MC.execute(() -> {
            if (!MCFTClient.checkVersion(p.version())) {
                Objects.requireNonNull(MCFTClient.MC.field_1724).method_7353((class_2561)class_2561.method_43469((String)"mcft.message.versionmismatch", (Object[])new Object[]{MCFT.version, p.version()}), false);
                return;
            }
            fps = p.fps();
            if (!connected) {
                MCFT.LOGGER.info(class_1074.method_4662((String)"mcft.logging.connected", (Object[])new Object[0]));
            }
            connected = true;
            FTClient.uploadParams(FTModel.model);
        }));
        Platform.registerCommand();
    }

    public static void update() {
        if (MCFTClient.MC.field_1724 == null || MCFTClient.MC.field_1687 == null) {
            return;
        }
        AutoBlink.update();
        if (FTModel.model.active() && System.currentTimeMillis() - lastSync > (long)(1000 / fps)) {
            FTClient.writeSync(FTModel.model);
            lastSync = System.currentTimeMillis();
        }
        FTModel.model.lastReceived = OSC.lastReceived;
        uuidToModel.put(MCFTClient.MC.field_1724.method_5667(), FTModel.model);
        uuidToModel.entrySet().removeIf(entry -> Objects.requireNonNull(MC.method_1562()).method_2871((UUID)entry.getKey()) == null);
        if (configScreen && MCFTClient.MC.field_1755 == null) {
            MC.method_1507((class_437)new UVGridScreen());
            configScreen = false;
        }
    }

    private static boolean checkVersion(String v) {
        String[] p1 = StringUtils.split((String)v, (char)'.');
        String[] p2 = StringUtils.split((String)MCFT.version, (char)'.');
        if (p1.length < 2 || p2.length < 2) {
            return false;
        }
        return p1[0].equals(p2[0]) && p1[1].equals(p2[1]);
    }

    static {
        configPath = Platform.getClientConfigPath();
    }
}

