/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.mcft.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.squi2rel.mcft.MCFT;
import com.github.squi2rel.mcft.MCFTClient;
import com.github.squi2rel.mcft.services.DNS;
import com.github.squi2rel.mcft.services.OSC;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_320;

public class HTTP {
    public static final int port = MCFTClient.config.httpPort;

    public static void init() throws IOException {
        HTTP.createInfo();
        Thread http = new Thread(() -> {
            ServerSocket serverSocket;
            try {
                serverSocket = new ServerSocket(port);
                try {
                    OSC.init();
                    DNS.init();
                    MCFT.LOGGER.info("HTTP started on port {}", (Object)port);
                    while (true) {
                        try {}
                        catch (IOException iOException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        serverSocket.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                MCFT.LOGGER.error("Service start failed", (Throwable)e);
                return;
            }
            while (true) {
                Socket s = serverSocket.accept();
                try {
                    String headerLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    while ((headerLine = in.readLine()) != null && !headerLine.isEmpty()) {
                    }
                    String response = HTTP.getString();
                    OutputStream out = s.getOutputStream();
                    out.write(response.getBytes(StandardCharsets.UTF_8));
                    out.flush();
                    continue;
                }
                finally {
                    if (s == null) continue;
                    s.close();
                    continue;
                }
                break;
            }
        });
        http.setName("MCFT Service");
        http.setDaemon(true);
        http.start();
    }

    private static String getString() throws IOException {
        String jsonBody = HTTP.generateJsonData(class_310.method_1551().method_1548().method_44717());
        byte[] jsonBytes = jsonBody.getBytes(StandardCharsets.UTF_8);
        return "HTTP/1.1 200 OK\r\nContent-Type: application/json; charset=utf-8\r\nContent-Length: " + jsonBytes.length + "\r\nConnection: close\r\n\r\n" + jsonBody;
    }

    private static void createInfo() throws IOException {
        File root = new File(System.getenv("localappdata") + "Low", "VRChat/VRChat/OSC/MCFT/Avatars");
        if (!root.exists() && !root.mkdirs()) {
            throw new IOException();
        }
        class_320 s = class_310.method_1551().method_1548();
        File child = new File(root, String.valueOf(s.method_44717()) + ".json");
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode tree = mapper.createObjectNode();
        tree.put("id", Objects.requireNonNull(s.method_44717()).toString());
        tree.put("name", s.method_1676());
        ArrayNode parameters = mapper.createArrayNode();
        for (String p : OSC.allParameters.keySet()) {
            ObjectNode obj = mapper.createObjectNode();
            obj.put("name", p);
            ObjectNode input = mapper.createObjectNode();
            input.put("address", "/v2/" + p);
            input.put("type", "Float");
            obj.set("input", (JsonNode)input);
            parameters.add((JsonNode)obj);
        }
        tree.set("parameters", (JsonNode)parameters);
        Files.writeString(child.toPath(), (CharSequence)mapper.writeValueAsString((Object)tree), new OpenOption[0]);
    }

    private static String generateJsonData(UUID uuid) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Node root = new Node(n -> {
            n.FULL_PATH = "/avatar";
            n.ACCESS = 0;
            n.CONTENTS = Map.of("change", new Node(c -> {
                c.FULL_PATH = n.FULL_PATH + "/change";
                c.ACCESS = 3;
                c.TYPE = "s";
                c.VALUE = uuid.toString();
            }), "parameters", new Node(c -> {
                c.FULL_PATH = n.FULL_PATH + "/parameters";
                c.ACCESS = 0;
                c.CONTENTS = new HashMap<String, Node>();
                for (String param : OSC.allParameters.keySet()) {
                    c.CONTENTS.put(param, new Node(p -> {
                        p.FULL_PATH = "/v2/" + param;
                        p.ACCESS = 3;
                        p.TYPE = "f";
                        p.VALUE = Float.valueOf(0.0f);
                    }));
                }
            }));
        });
        return mapper.writeValueAsString((Object)root);
    }

    public static class Node {
        public String FULL_PATH;
        public int ACCESS;
        public Map<String, Node> CONTENTS;
        public String TYPE;
        @JsonDeserialize(using=ValueDeserializer.class)
        @JsonSerialize(using=ValueSerializer.class)
        public Object VALUE;

        public Node(Consumer<Node> constructor) {
            constructor.accept(this);
        }
    }

    public static class ValueSerializer
    extends JsonSerializer<Object> {
        public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                return;
            }
            gen.writeStartArray();
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                gen.writeBoolean(b.booleanValue());
            } else if (value instanceof Float) {
                Float v = (Float)value;
                gen.writeNumber(v.floatValue());
            } else if (value instanceof String) {
                String s = (String)value;
                gen.writeString(s);
            } else {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(value));
            }
            gen.writeEndArray();
        }
    }

    public static class ValueDeserializer
    extends JsonDeserializer<Object> {
        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            if (node.isArray() && node.size() == 1) {
                JsonNode element = node.get(0);
                if (element.isBoolean()) {
                    return element.asBoolean();
                }
                if (element.isInt()) {
                    return element.asInt();
                }
                if (element.isDouble()) {
                    return element.asDouble();
                }
                if (element.isTextual()) {
                    return element.asText();
                }
            }
            return null;
        }
    }
}

