/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.mcft.services;

import com.github.squi2rel.mcft.AutoBlink;
import com.github.squi2rel.mcft.FTModel;
import com.github.squi2rel.mcft.MCFT;
import com.github.squi2rel.mcft.MCFTClient;
import com.illposed.osc.MessageSelector;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCMessageEvent;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.transport.OSCPortIn;
import com.illposed.osc.transport.OSCPortOut;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_310;

public class OSC {
    public static long lastReceived = 0L;
    public static Map<String, Consumer<List<Object>>> allParameters = Map.ofEntries(Map.entry("EyeLeftX", f -> {
        FTModel.model.eyeL.rawPos.x = MCFTClient.config.eyeOffsetXL + ((Float)f.get(0)).floatValue() * -MCFTClient.config.eyeXMul;
    }), Map.entry("EyeLeftY", f -> {
        FTModel.model.eyeL.rawPos.y = MCFTClient.config.eyeOffsetYL + ((Float)f.get(0)).floatValue() * -MCFTClient.config.eyeYMul;
    }), Map.entry("EyeLidLeft", f -> {
        if (!AutoBlink.enabled) {
            FTModel.model.eyeL.percent = ((Float)f.get(0)).floatValue();
        }
    }), Map.entry("EyeRightX", f -> {
        FTModel.model.eyeR.rawPos.x = MCFTClient.config.eyeOffsetXR + ((Float)f.get(0)).floatValue() * -MCFTClient.config.eyeXMul;
    }), Map.entry("EyeRightY", f -> {
        FTModel.model.eyeR.rawPos.y = MCFTClient.config.eyeOffsetYR + ((Float)f.get(0)).floatValue() * -MCFTClient.config.eyeYMul;
    }), Map.entry("EyeLidRight", f -> {
        if (!AutoBlink.enabled) {
            FTModel.model.eyeR.percent = ((Float)f.get(0)).floatValue();
        }
    }), Map.entry("JawOpen", f -> {
        FTModel.model.mouth.percent = ((Float)f.get(0)).floatValue();
    }));

    public static void init() throws Exception {
        OSCPortIn receiver = new OSCPortIn((SocketAddress)new InetSocketAddress("localhost", MCFTClient.config.oscReceivePort));
        OSCPortOut sender = new OSCPortOut((SocketAddress)new InetSocketAddress("localhost", MCFTClient.config.oscSendPort));
        receiver.getDispatcher().addListener(new MessageSelector(){

            public boolean isInfoRequired() {
                return false;
            }

            public boolean matches(OSCMessageEvent oscMessageEvent) {
                return true;
            }
        }, e -> {
            OSCMessage msg = e.getMessage();
            Consumer<List<Object>> c = allParameters.get(msg.getAddress().replace("/v2/", ""));
            if (c != null) {
                lastReceived = System.currentTimeMillis();
                c.accept(msg.getArguments());
            }
        });
        receiver.startListening();
        MCFT.LOGGER.info("OSC started on port {}", (Object)9000);
        sender.send((OSCPacket)new OSCMessage("/avatar/change", List.of(Objects.requireNonNull(class_310.method_1551().method_1548().method_44717()).toString())));
    }
}

