/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.mcft.tracking;

import com.github.squi2rel.mcft.tracking.Rect;
import com.github.squi2rel.mcft.tracking.TrackingRect;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_3532;

public class EyeTrackingRect
extends TrackingRect {
    public transient float percent;
    public transient float lastPercent;
    public transient Rect rawPos = new Rect();
    public transient Rect lastPos = new Rect();
    public TrackingRect ball = new TrackingRect(0.0f, 0.0f, 0.75f, 0.75f);
    public TrackingRect lid = new TrackingRect();
    public TrackingRect inner = new TrackingRect();

    public EyeTrackingRect() {
    }

    public EyeTrackingRect(float x, float y, float w, float h) {
        super(x, y, w, h);
    }

    @Override
    public void writeSync(ByteBuf buf) {
        buf.writeFloat(this.percent);
        Rect.writePos(this.rawPos, buf);
    }

    @Override
    public void readSync(ByteBuf buf) {
        this.lastPercent = this.percent;
        this.percent = buf.readFloat();
        this.lastPos.set(this.rawPos.x, this.rawPos.y);
        Rect.readPos(this.rawPos, buf);
    }

    protected EyeTrackingRect(float x, float y, float w, float h, float u1, float v1, float u2, float v2, float ew, float eh, float eu1, float eu2, float ev1, float ev2, float lu1, float lv1, float lu2, float lv2, float iu1, float iv1, float iu2, float iv2) {
        super(x, y, w, h, u1, v1, u2, v2);
        this.ball.set(ew, eh, eu1, ev1, eu2, ev2);
        this.lid.uv(lu1, lv1, lu2, lv2);
        this.inner.uv(iu1, iv1, iu2, iv2);
    }

    @Override
    public void update(float delta) {
        tmp.lerpPos(delta, this.lastPos, this.rawPos);
        float p = EyeTrackingRect.lerp(delta, this.lastPercent, this.percent);
        this.ball.set(EyeTrackingRect.tmp.x, EyeTrackingRect.tmp.y);
        this.h = this.ih * p;
    }

    @Override
    public void write(ByteBuf buf) {
        super.write(buf);
        this.ball.write(buf);
        Rect.write(tmp.set(this.lid.u1, this.lid.v1, this.lid.u2, this.lid.v2, this.inner.u1, this.inner.v1, this.inner.u2, this.inner.v2), buf);
    }

    @Override
    public void validate(boolean init) {
        if (init) {
            super.validate(true);
            this.ball.validate(true);
            this.lid.validate(true);
            this.inner.validate(true);
            this.ball.w = class_3532.method_15363((float)this.ball.w, (float)0.0f, (float)(8.0f - this.ball.x));
            this.ball.h = class_3532.method_15363((float)this.ball.h, (float)0.0f, (float)(8.0f - this.ball.y));
            this.lid.w = class_3532.method_15363((float)this.lid.w, (float)0.0f, (float)(8.0f - this.lid.x));
            this.lid.h = class_3532.method_15363((float)this.lid.h, (float)0.0f, (float)(8.0f - this.lid.y));
            this.inner.w = class_3532.method_15363((float)this.inner.w, (float)0.0f, (float)(8.0f - this.inner.x));
            this.inner.h = class_3532.method_15363((float)this.inner.h, (float)0.0f, (float)(8.0f - this.inner.y));
        } else {
            this.percent = class_3532.method_15363((float)this.percent, (float)0.0f, (float)1.0f);
            this.rawPos.x = class_3532.method_15363((float)this.rawPos.x, (float)-2.0f, (float)2.0f);
            this.rawPos.y = class_3532.method_15363((float)this.rawPos.y, (float)-2.0f, (float)2.0f);
        }
    }

    public static EyeTrackingRect read(ByteBuf buf) {
        Rect rect = Rect.read(buf);
        Rect ball = Rect.read(buf);
        Rect inner = Rect.read(buf);
        if (rect == null || ball == null || inner == null) {
            throw new IllegalArgumentException();
        }
        return new EyeTrackingRect(rect.x, rect.y, rect.w, rect.h, rect.ix, rect.iy, rect.iw, rect.ih, ball.w, ball.h, ball.ix, ball.iy, ball.iw, ball.ih, inner.x, inner.y, inner.w, inner.h, inner.ix, inner.iy, inner.iw, inner.ih);
    }
}

