/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.mcft.tracking;

import com.github.squi2rel.mcft.tracking.Rect;
import com.github.squi2rel.mcft.tracking.TrackingRect;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_3532;

public class MouthTrackingRect
extends TrackingRect {
    public transient float percent;
    public transient float lastPercent;

    public MouthTrackingRect(float x, float y, float w, float h) {
        super(x, y, w, h);
    }

    public MouthTrackingRect(float x, float y, float w, float h, float u1, float v1, float u2, float v2) {
        super(x, y, w, h, u1, v1, u2, v2);
    }

    @Override
    public void writeSync(ByteBuf buf) {
        buf.writeFloat(this.percent);
    }

    @Override
    public void readSync(ByteBuf buf) {
        this.lastPercent = this.percent;
        this.percent = buf.readFloat();
    }

    @Override
    public void update(float delta) {
        float p = MouthTrackingRect.lerp(delta, this.lastPercent, this.percent);
        float r = Math.max(p - 0.05f, 0.0f) / 0.95f;
        this.h = this.ih * r;
        this.y = this.iy - this.ih * (1.0f - r);
        float a = this.ih * p;
        this.x = this.ix + a;
        this.w = this.iw - a * 2.0f;
    }

    @Override
    public void validate(boolean init) {
        if (init) {
            super.validate(true);
            this.x = class_3532.method_15363((float)this.x, (float)0.0f, (float)8.0f);
            this.y = class_3532.method_15363((float)this.y, (float)0.0f, (float)8.0f);
            this.w = class_3532.method_15363((float)this.w, (float)0.0f, (float)(8.0f - this.x));
            this.h = class_3532.method_15363((float)this.h, (float)-3.0f, (float)8.0f);
        } else {
            this.percent = class_3532.method_15363((float)this.percent, (float)0.0f, (float)1.0f);
        }
    }

    public static MouthTrackingRect read(ByteBuf buf) {
        Rect rect = Rect.read(buf);
        if (rect == null) {
            return null;
        }
        return new MouthTrackingRect(rect.x, rect.y, rect.w, rect.h, rect.ix, rect.iy, rect.iw, rect.ih);
    }
}

