/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.mcft.tracking;

import io.netty.buffer.ByteBuf;

public class Rect {
    public float ix;
    public float iy;
    public float iw;
    public float ih;
    public float x;
    public float y;
    public float w;
    public float h;

    public Rect() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Rect(float x, float y, float w, float h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.ix = x;
        this.iy = y;
        this.iw = w;
        this.ih = h;
    }

    public Rect(float x, float y, float w, float h, float ix, float iy, float iw, float ih) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.ix = ix;
        this.iy = iy;
        this.iw = iw;
        this.ih = ih;
    }

    public Rect set(float x, float y, float w, float h, float ix, float iy, float iw, float ih) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.ix = ix;
        this.iy = iy;
        this.iw = iw;
        this.ih = ih;
        return this;
    }

    public void w(float w) {
        this.w = this.iw = w;
    }

    public void h(float h) {
        this.h = this.ih = h;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void lerpPos(float delta, Rect src, Rect dest) {
        if (src == null) {
            this.x = dest.x;
            this.y = dest.y;
            return;
        }
        this.x = Rect.lerp(delta, src.x, dest.x);
        this.y = Rect.lerp(delta, src.y, dest.y);
    }

    public static void writePos(Rect rect, ByteBuf buf) {
        buf.writeFloat(rect.x);
        buf.writeFloat(rect.y);
    }

    public static void readPos(Rect rect, ByteBuf buf) {
        rect.x = buf.readFloat();
        rect.y = buf.readFloat();
    }

    public static void write(Rect rect, ByteBuf buf) {
        buf.writeBoolean(rect != null);
        if (rect != null) {
            buf.writeFloat(rect.x);
            buf.writeFloat(rect.y);
            buf.writeFloat(rect.w);
            buf.writeFloat(rect.h);
            buf.writeFloat(rect.ix);
            buf.writeFloat(rect.iy);
            buf.writeFloat(rect.iw);
            buf.writeFloat(rect.ih);
        }
    }

    public static float lerp(float delta, float start, float end) {
        return start + delta * (end - start);
    }

    public static Rect read(ByteBuf buf) {
        if (buf.readBoolean()) {
            return new Rect(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
        }
        return null;
    }
}

