/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.mcft.tracking;

import com.github.squi2rel.mcft.tracking.Rect;
import io.netty.buffer.ByteBuf;

public class TrackingRect
extends Rect {
    public float u1;
    public float v1;
    public float u2;
    public float v2;
    protected static final Rect tmp = new Rect();

    public TrackingRect() {
        super(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public TrackingRect(float x, float y, float w, float h) {
        super(x, y, w, h);
    }

    public TrackingRect(float x, float y, float w, float h, float u1, float v1, float u2, float v2) {
        super(x, y, w, h);
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
    }

    public void set(float w, float h, float u1, float v1, float u2, float v2) {
        this.w = this.iw = w;
        this.h = this.ih = h;
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
    }

    public void uv(float u1, float v1, float u2, float v2) {
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
    }

    public void writeSync(ByteBuf buf) {
    }

    public void readSync(ByteBuf buf) {
    }

    public void write(ByteBuf buf) {
        Rect.write(tmp.set(this.ix, this.iy, this.iw, this.ih, this.u1, this.v1, this.u2, this.v2), buf);
    }

    public void update(float delta) {
    }

    public void validate(boolean init) {
        if (!init) {
            return;
        }
        TrackingRect.checkInRange(this.u1, 0.0f, 1.0f);
        TrackingRect.checkInRange(this.v1, 0.0f, 1.0f);
        TrackingRect.checkInRange(this.u2, 0.0f, 1.0f);
        TrackingRect.checkInRange(this.v2, 0.0f, 1.0f);
    }

    public static void checkInRange(float val, float min, float max) {
        if (!(val >= min) || !(val <= max)) {
            throw new IllegalArgumentException(String.format("%f should be between %f and %f", Float.valueOf(val), Float.valueOf(min), Float.valueOf(max)));
        }
    }
}

