/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.mcft.ui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public abstract class GridScreen
extends class_437 {
    public static DecimalFormat NUMBER_FORMAT = new DecimalFormat("0.00");
    protected final int gridLength;
    protected final int drawSize;
    protected boolean selecting = false;
    protected boolean freeDrag = false;
    protected boolean allowSelect = true;
    protected int gridX;
    protected int gridY;
    protected int selectedStartX = -1;
    protected int selectedStartY = -1;
    protected int selectedEndX = -1;
    protected int selectedEndY = -1;

    public GridScreen(class_2561 title, int gridLength, int drawSize) {
        super(title);
        this.gridLength = gridLength;
        this.drawSize = drawSize;
    }

    protected Selection getSelection() {
        if (this.freeDrag) {
            int x1 = Math.min(this.selectedStartX, this.selectedEndX);
            int x2 = Math.max(this.selectedStartX, this.selectedEndX);
            int y1 = Math.min(this.selectedStartY, this.selectedEndY);
            int y2 = Math.max(this.selectedStartY, this.selectedEndY);
            return new Selection(x1, y1, x2 - x1, y2 - y1);
        }
        double cellSize = (double)this.drawSize / (double)this.gridLength;
        int x1 = class_3532.method_15340((int)((int)((double)this.selectedStartX / cellSize)), (int)0, (int)(this.gridLength - 1));
        int y1 = class_3532.method_15340((int)((int)((double)this.selectedStartY / cellSize)), (int)0, (int)(this.gridLength - 1));
        int x2 = class_3532.method_15340((int)((int)((double)this.selectedEndX / cellSize)), (int)0, (int)(this.gridLength - 1));
        int y2 = class_3532.method_15340((int)((int)((double)this.selectedEndY / cellSize)), (int)0, (int)(this.gridLength - 1));
        int fx1 = (int)((double)Math.min(x1, x2) * cellSize);
        int fy1 = (int)((double)Math.min(y1, y2) * cellSize);
        int fx2 = (int)((double)Math.max(x1, x2) * cellSize + cellSize);
        int fy2 = (int)((double)Math.max(y1, y2) * cellSize + cellSize);
        return new Selection(fx1, fy1, fx2 - fx1, fy2 - fy1);
    }

    protected void drawGrid(class_332 context, int x, int y) {
        int cellSize = this.drawSize / this.gridLength;
        for (int i = 0; i <= this.gridLength; ++i) {
            context.method_25292(x, x + this.drawSize, y + i * cellSize, -16777216);
            context.method_25301(x + i * cellSize, y, y + this.drawSize, -16777216);
        }
        if (this.selectedStartX != -1 && this.selectedEndX != -1) {
            if (this.freeDrag) {
                context.method_25294(class_3532.method_15340((int)(this.gridX + this.selectedStartX), (int)this.gridX, (int)(this.gridX + this.drawSize)), class_3532.method_15340((int)(this.gridY + this.selectedStartY), (int)this.gridY, (int)(this.gridY + this.drawSize)), class_3532.method_15340((int)(this.gridX + this.selectedEndX), (int)this.gridX, (int)(this.gridX + this.drawSize)), class_3532.method_15340((int)(this.gridY + this.selectedEndY), (int)this.gridY, (int)(this.gridY + this.drawSize)), 0x55FF0000);
            } else {
                int x1 = class_3532.method_15340((int)(this.selectedStartX / cellSize), (int)0, (int)(this.gridLength - 1)) * cellSize;
                int y1 = class_3532.method_15340((int)(this.selectedStartY / cellSize), (int)0, (int)(this.gridLength - 1)) * cellSize;
                int x2 = class_3532.method_15340((int)(this.selectedEndX / cellSize), (int)0, (int)(this.gridLength - 1)) * cellSize;
                int y2 = class_3532.method_15340((int)(this.selectedEndY / cellSize), (int)0, (int)(this.gridLength - 1)) * cellSize;
                context.method_25294(this.gridX + Math.min(x1, x2), this.gridY + Math.min(y1, y2), this.gridX + Math.max(x1, x2) + cellSize, this.gridY + Math.max(y1, y2) + cellSize, 0x55FF0000);
            }
        }
    }

    protected void drawSelection(class_332 context, Selection selection, int color) {
        if (selection == null) {
            return;
        }
        context.method_25294(this.gridX + selection.x, this.gridY + selection.y, this.gridX + selection.x + selection.w, this.gridY + selection.y + selection.h, color);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.allowSelect && button == 0 && mouseX >= (double)this.gridX && mouseX <= (double)(this.gridX + this.drawSize) && mouseY >= (double)this.gridY && mouseY <= (double)(this.gridY + this.drawSize)) {
            this.selecting = true;
            this.updateSelection(mouseX, mouseY, true);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.selecting && button == 0) {
            this.updateSelection(mouseX, mouseY, false);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.selecting = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private void updateSelection(double mouseX, double mouseY, boolean isStart) {
        double dx = mouseX - (double)this.gridX;
        double dy = mouseY - (double)this.gridY;
        if (isStart) {
            this.selectedStartX = (int)dx;
            this.selectedStartY = (int)dy;
        }
        this.selectedEndX = (int)dx;
        this.selectedEndY = (int)dy;
    }

    public record Selection(int x, int y, int w, int h) {
    }

    public static class SettingsSlider<T extends Number>
    extends class_357 {
        private final double min;
        private final double max;
        private final Consumer<T> callback;
        private final Function<T, String> textProvider;
        private final Function<Double, T> converter;

        public SettingsSlider(int x, int y, int width, int height, T value, T min, T max, Consumer<T> callback, Function<T, String> textProvider, Function<Double, T> converter) {
            super(x, y, width, height, class_5244.field_39003, 0.0);
            this.min = ((Number)min).doubleValue();
            this.max = ((Number)max).doubleValue();
            this.field_22753 = (class_3532.method_15350((double)((Number)value).doubleValue(), (double)((Number)min).doubleValue(), (double)((Number)max).doubleValue()) - ((Number)min).doubleValue()) / (((Number)max).doubleValue() - ((Number)min).doubleValue());
            this.callback = callback;
            this.textProvider = textProvider;
            this.converter = converter;
            this.method_25346();
        }

        public void method_25344() {
            this.callback.accept((Number)this.converter.apply(class_3532.method_16436((double)class_3532.method_15350((double)this.field_22753, (double)0.0, (double)1.0), (double)this.min, (double)this.max)));
        }

        protected void method_25346() {
            this.method_25355(class_2561.method_30163((String)this.textProvider.apply((Number)this.converter.apply(class_3532.method_16436((double)class_3532.method_15350((double)this.field_22753, (double)0.0, (double)1.0), (double)this.min, (double)this.max)))));
        }

        public void setValue(T number) {
            double newValue = (class_3532.method_15350((double)((Number)number).doubleValue(), (double)this.min, (double)this.max) - this.min) / (this.max - this.min);
            if (newValue == this.field_22753) {
                return;
            }
            this.field_22753 = newValue;
            this.method_25344();
            this.method_25346();
        }

        public static SettingsSlider<Float> floatSlider(int x, int y, int width, int height, float value, float min, float max, Consumer<Float> callback, Function<Float, String> textProvider) {
            return new SettingsSlider<Float>(x, y, width, height, Float.valueOf(value), Float.valueOf(min), Float.valueOf(max), callback, textProvider, Double::floatValue);
        }
    }

    public class WidgetGroup {
        private final ArrayList<class_339> widgets = new ArrayList();

        public <T extends class_339> T add(T e) {
            GridScreen.this.method_37063(e);
            this.widgets.add(e);
            return e;
        }

        public void visible(boolean visible) {
            for (class_339 widget : this.widgets) {
                widget.field_22764 = visible;
            }
        }
    }
}

