/*
 * Decompiled with CFR 0.152.
 */
package com.maketendo.creative_heads;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.maketendo.creative_heads.CreativeHeads;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class CreativeHeadsConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File FILE = new File("config/creative_heads.json");
    public boolean singleTab = false;
    public Map<String, String> customCategoryNames = new HashMap<String, String>();
    public static CreativeHeadsConfig INSTANCE = new CreativeHeadsConfig();

    public static void load() {
        try {
            if (!FILE.exists()) {
                System.out.println("Creating default config...");
                CreativeHeadsConfig.INSTANCE.customCategoryNames.putAll(CreativeHeads.CATEGORY_NAMES);
                CreativeHeadsConfig.save();
                return;
            }
            try (FileReader reader = new FileReader(FILE);){
                INSTANCE = (CreativeHeadsConfig)GSON.fromJson((Reader)reader, CreativeHeadsConfig.class);
            }
            System.out.println("Loaded config.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(FILE);){
                GSON.toJson((Object)INSTANCE, (Appendable)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

