/*
 * Decompiled with CFR 0.152.
 */
package com.maketendo.creative_heads;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.maketendo.creative_heads.CreativeHeads;
import com.maketendo.creative_heads.CreativeHeadsConfig;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class HeadFetcher {
    private static final String API_URL = "https://minecraft-heads.com/api/heads/custom-heads?app_uuid=d7e9ffeb-1bd1-4955-9c75-a4fc89ea0860&value=true";
    private static final Map<String, List<class_1799>> CATEGORY_HEADS = new HashMap<String, List<class_1799>>();

    public static void fetchAllHeads() {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(API_URL).openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", "Fabric-Mod");
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(15000);
            StringBuilder sb = new StringBuilder();
            try (Scanner sc = new Scanner(conn.getInputStream());){
                while (sc.hasNextLine()) {
                    sb.append(sc.nextLine());
                }
            }
            JsonElement parsed = JsonParser.parseString((String)sb.toString());
            JsonArray dataArray = HeadFetcher.getDataArray(parsed);
            if (dataArray == null) {
                CreativeHeads.LOGGER.error("API returned no data");
                return;
            }
            for (JsonElement el : dataArray) {
                JsonObject obj = el.getAsJsonObject();
                if (!obj.has("n") || !obj.has("u") || !obj.has("c")) continue;
                String name = obj.get("n").getAsString();
                String category = obj.get("c").getAsString();
                String texture = obj.get("u").getAsString();
                class_1799 head = HeadFetcher.makeHead(name, texture, category);
                CATEGORY_HEADS.computeIfAbsent(category, k -> new ArrayList()).add(head);
            }
            CreativeHeads.LOGGER.info("Loaded " + CATEGORY_HEADS.size() + " categories, " + CATEGORY_HEADS.values().stream().mapToInt(List::size).sum() + " total heads.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static JsonArray getDataArray(JsonElement parsed) {
        if (parsed.isJsonObject() && parsed.getAsJsonObject().has("data")) {
            return parsed.getAsJsonObject().getAsJsonArray("data");
        }
        if (parsed.isJsonArray()) {
            return parsed.getAsJsonArray();
        }
        return null;
    }

    private static class_1799 makeHead(String name, String textureId, String category) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
        String json = String.format("{\"textures\":{\"SKIN\":{\"url\":\"https://textures.minecraft.net/texture/%s\"}}}", textureId);
        String encoded = Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
        ImmutableMultimap map = ImmutableMultimap.builder().put((Object)"textures", (Object)new Property("textures", encoded)).build();
        PropertyMap properties = new PropertyMap((Multimap)map);
        GameProfile profile = new GameProfile(UUID.randomUUID(), "head", properties);
        String displayName = CreativeHeadsConfig.INSTANCE.customCategoryNames.getOrDefault(category, category);
        stack.method_57379(class_9334.field_49617, (Object)class_9296.method_73307((GameProfile)profile));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)("Category: " + displayName)).method_27692(class_124.field_1080))));
        if (name != null && !name.isEmpty()) {
            stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)(name.length() > 32 ? name.substring(0, 32) : name)));
        }
        return stack;
    }

    public static Map<String, List<class_1799>> getCategoryHeads() {
        return CATEGORY_HEADS;
    }
}

