/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.biomeinfo;

import bl4ckscor3.mod.biomeinfo.Configuration;
import bl4ckscor3.mod.biomeinfo.PositionPreset;
import com.mojang.blaze3d.platform.Window;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix3x2fStack;

@EventBusSubscriber(modid="biomeinfo", value={Dist.CLIENT})
public class BiomeInfoRenderer {
    public static final int MARGIN = 3;
    public static Biome previousBiome;
    public static int displayTime;
    public static int alpha;
    public static boolean complete;
    public static boolean fadingIn;
    public static final Map<ResourceKey<Biome>, Component> NAME_CACHE;

    private BiomeInfoRenderer() {
    }

    public static void onClientTick(ClientTickEvent.Pre event) {
        if (complete) {
            if (!fadingIn) {
                if (!Configuration.fadeOut() && alpha != 255) {
                    alpha = 255;
                } else if (Configuration.fadeOut()) {
                    if (displayTime > 0) {
                        --displayTime;
                    } else if (alpha > 0) {
                        alpha -= 10;
                    }
                }
            } else if ((alpha += 10) >= 255) {
                fadingIn = false;
                displayTime = Configuration.displayTime();
                alpha = 255;
            }
        }
    }

    public static void renderBiomeInfo(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (complete && Configuration.enabled()) {
            Minecraft mc = Minecraft.getInstance();
            if (BiomeInfoRenderer.hideBecauseOfF1(mc) || BiomeInfoRenderer.hideBecauseOfF3(mc)) {
                return;
            }
            BlockPos pos = mc.getCameraEntity().blockPosition();
            if (mc.level != null && mc.level.isLoaded(pos)) {
                Holder biomeHolder = mc.level.getBiome(pos);
                if (!biomeHolder.isBound()) {
                    return;
                }
                Biome biome = (Biome)biomeHolder.value();
                if (previousBiome != biome) {
                    previousBiome = biome;
                    if (Configuration.fadeIn()) {
                        displayTime = 0;
                        alpha = 0;
                        fadingIn = true;
                    } else {
                        displayTime = Configuration.displayTime();
                        alpha = 255;
                    }
                }
                if (alpha > 0) {
                    biomeHolder.unwrapKey().ifPresent(key -> {
                        Component biomeName = BiomeInfoRenderer.getBiomeName((ResourceKey<Biome>)key);
                        float scale = (float)Configuration.scale();
                        PositionPreset positionPreset = Configuration.positionPreset();
                        int textOffset = positionPreset.textAlignment().getNegativeOffset(mc.font, biomeName);
                        Matrix3x2fStack pose = guiGraphics.pose();
                        Window window = mc.getWindow();
                        pose.pushMatrix();
                        pose.scale(scale, scale);
                        guiGraphics.drawString(mc.font, biomeName, positionPreset.posX(window) - textOffset, positionPreset.posY(window, mc.font), Configuration.color() | alpha << 24, Configuration.textShadow());
                        pose.popMatrix();
                    });
                }
            }
        }
    }

    private static Component getBiomeName(ResourceKey<Biome> key) {
        return NAME_CACHE.computeIfAbsent(key, k -> {
            String modName;
            String displayedText;
            MutableComponent biomeName;
            ResourceLocation location = key.location();
            String translationKey = Util.makeDescriptionId((String)"biome", (ResourceLocation)location);
            MutableComponent displayName = biomeName = Component.translatable((String)translationKey);
            if (Configuration.fallbackOnUntranslatableName() && (displayedText = biomeName.getString()).equals(translationKey)) {
                String biomePath = key.location().getPath();
                String formattedBiomeName = BiomeInfoRenderer.snakeCaseToEnglish(biomePath);
                displayName = Component.literal((String)formattedBiomeName);
            }
            if (Configuration.appendModName() && (modName = BiomeInfoRenderer.getModName(location)) != null) {
                displayName = displayName.append((Component)Component.literal((String)String.format(" (%s)", modName)));
            }
            return displayName;
        });
    }

    private static boolean hideBecauseOfF1(Minecraft mc) {
        return mc.options.hideGui && Configuration.hideWithUI();
    }

    private static boolean hideBecauseOfF3(Minecraft mc) {
        return mc.getDebugOverlay().showDebugScreen() && Configuration.hideOnDebugScreen();
    }

    private static String snakeCaseToEnglish(String biomePath) {
        String[] words = biomePath.split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            formatted.append(StringUtils.capitalize((String)word)).append(" ");
        }
        return formatted.toString().trim();
    }

    private static String getModName(ResourceLocation location) {
        String namespace = location.getNamespace();
        for (ModInfo info : FMLLoader.getCurrent().getLoadingModList().getMods()) {
            if (!info.getModId().equals(namespace)) continue;
            return info.getDisplayName();
        }
        return BiomeInfoRenderer.snakeCaseToEnglish(namespace);
    }

    @SubscribeEvent
    public static void onResourceManagerReload(AddClientReloadListenersEvent event) {
        event.addListener(ResourceLocation.fromNamespaceAndPath((String)"biomeinfo", (String)"cache_invalidation"), (state, backgroundExecutor, barrier, gameExecutor) -> CompletableFuture.runAsync(NAME_CACHE::clear, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).wait(arg_0)));
    }

    @SubscribeEvent
    public static void onRegisterGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.TITLE, ResourceLocation.fromNamespaceAndPath((String)"biomeinfo", (String)"overlay"), BiomeInfoRenderer::renderBiomeInfo);
    }

    @SubscribeEvent
    public static void onConfigChange(ModConfigEvent event) {
        if (event.getConfig().getSpec() == Configuration.CONFIG_SPEC) {
            NAME_CACHE.clear();
        }
    }

    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        complete = true;
    }

    static {
        displayTime = 0;
        alpha = 0;
        complete = false;
        fadingIn = false;
        NAME_CACHE = new HashMap<ResourceKey<Biome>, Component>();
        NeoForge.EVENT_BUS.addListener(BiomeInfoRenderer::onClientTick);
    }
}

