/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.biomeinfo;

import bl4ckscor3.mod.biomeinfo.PositionPreset;
import bl4ckscor3.mod.biomeinfo.TextAlignment;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Configuration {
    public static final ModConfigSpec CONFIG_SPEC;
    private static final Configuration CONFIG;
    private final ModConfigSpec.BooleanValue enabled;
    private final ModConfigSpec.BooleanValue fadeOut;
    private final ModConfigSpec.BooleanValue fadeIn;
    private final ModConfigSpec.IntValue displayTime;
    private final ModConfigSpec.IntValue posX;
    private final ModConfigSpec.IntValue posY;
    private final ModConfigSpec.DoubleValue scale;
    private final ModConfigSpec.BooleanValue textShadow;
    private final ModConfigSpec.IntValue color;
    private final ModConfigSpec.BooleanValue hideOnDebugScreen;
    private final ModConfigSpec.BooleanValue hideWithUI;
    private final ModConfigSpec.BooleanValue fallbackOnUntranslatableName;
    private final ModConfigSpec.BooleanValue appendModName;
    private final ModConfigSpec.EnumValue<TextAlignment> textAlignment;
    private final ModConfigSpec.EnumValue<PositionPreset> positionPreset;

    Configuration(ModConfigSpec.Builder builder) {
        this.enabled = builder.comment("true if the biome info should be shown, false otherwise.").define("enabled", true);
        this.fadeOut = builder.comment("true if the biome info should fade out shortly after a different biome has been entered. If this is set to false, the biome info will stay visible.").define("fadeOut", true);
        this.fadeIn = builder.comment("true if the biome info should fade in when a different biome has been entered.").define("fadeIn", true);
        this.displayTime = builder.comment("How long in ticks (20 ticks = 1 second) to display the biome info, if fadeOut = true. If fadeIn = true, the time will be counted from the moment the biome info has finished fading in.").defineInRange("displayTime", 30, 0, Integer.MAX_VALUE);
        this.posX = builder.comment("The X position to display the biome info at.").defineInRange("posX", 3, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.posY = builder.comment("The Y position to display the biome info at.").defineInRange("posY", 3, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.scale = builder.comment("The size of the biome info (multiplier).").defineInRange("scale", 1.0, 0.0, Double.MAX_VALUE);
        this.textShadow = builder.comment("true if the biome info should be rendered with a shadow, false otherwise.").define("textShadow", true);
        this.color = builder.comment("The color to display the biome info in (Format: 0xRRGGBB).").defineInRange("color", 0xFFFFFF, 0, 0xFFFFFF);
        this.hideOnDebugScreen = builder.comment("If true, hides the mod's info text when the debug screen (F3) is open.").define("hideOnDebugScreen", true);
        this.hideWithUI = builder.comment("If true, hides the mod's info text when the game's UI is also hidden (F1).").define("hideWithUI", true);
        this.fallbackOnUntranslatableName = builder.comment("If true, will automatically format biome names that do not have a proper translation into an English name.").define("fallbackOnUntranslatableName", true);
        this.appendModName = builder.comment("If true, will append the mod name the biome is from to the biome name.").define("appendModName", false);
        this.textAlignment = builder.comment("The text alignment of the biome info.").defineEnum("textAlignment", (Enum)TextAlignment.LEFT);
        this.positionPreset = builder.comment(new String[]{"This lets BiomeInfo automatically determine the correct position of the text without needing to change the posX, posY, or textAlignment configuration settings manually.", "If this is set to NONE, then BiomeInfo will use those configuration settings. If this is set to anything other than NONE, they will be ignored."}).defineEnum("positionPreset", (Enum)PositionPreset.TOP_LEFT);
    }

    public static boolean enabled() {
        return (Boolean)Configuration.CONFIG.enabled.get();
    }

    public static boolean fadeOut() {
        return (Boolean)Configuration.CONFIG.fadeOut.get();
    }

    public static boolean fadeIn() {
        return (Boolean)Configuration.CONFIG.fadeIn.get();
    }

    public static int displayTime() {
        return (Integer)Configuration.CONFIG.displayTime.get();
    }

    public static int posX() {
        return (Integer)Configuration.CONFIG.posX.get();
    }

    public static int posY() {
        return (Integer)Configuration.CONFIG.posY.get();
    }

    public static double scale() {
        return (Double)Configuration.CONFIG.scale.get();
    }

    public static boolean textShadow() {
        return (Boolean)Configuration.CONFIG.textShadow.get();
    }

    public static int color() {
        return (Integer)Configuration.CONFIG.color.get();
    }

    public static boolean hideOnDebugScreen() {
        return (Boolean)Configuration.CONFIG.hideOnDebugScreen.get();
    }

    public static boolean hideWithUI() {
        return (Boolean)Configuration.CONFIG.hideWithUI.get();
    }

    public static boolean fallbackOnUntranslatableName() {
        return (Boolean)Configuration.CONFIG.fallbackOnUntranslatableName.get();
    }

    public static boolean appendModName() {
        return (Boolean)Configuration.CONFIG.appendModName.get();
    }

    public static TextAlignment textAlignment() {
        return (TextAlignment)((Object)Configuration.CONFIG.textAlignment.get());
    }

    public static PositionPreset positionPreset() {
        return (PositionPreset)((Object)Configuration.CONFIG.positionPreset.get());
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Configuration::new);
        CONFIG_SPEC = (ModConfigSpec)specPair.getRight();
        CONFIG = (Configuration)specPair.getLeft();
    }
}

