/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.biomeinfo;

import bl4ckscor3.mod.biomeinfo.Configuration;
import bl4ckscor3.mod.biomeinfo.TextAlignment;
import com.mojang.blaze3d.platform.Window;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import net.minecraft.client.gui.Font;

public enum PositionPreset {
    NONE(window -> Configuration.posX(), (window, font) -> Configuration.posY(), Configuration::textAlignment),
    TOP_LEFT(window -> 3, (window, font) -> 3, () -> TextAlignment.LEFT),
    TOP_MIDDLE(window -> window.getGuiScaledWidth() / 2, (window, font) -> 3, () -> TextAlignment.MIDDLE),
    TOP_RIGHT(window -> window.getGuiScaledWidth() - 3, (window, font) -> 3, () -> TextAlignment.RIGHT),
    MIDDLE_LEFT(window -> 3, (window, font) -> {
        int n = window.getGuiScaledHeight() / 2;
        Objects.requireNonNull(font);
        return n - 9 / 2;
    }, () -> TextAlignment.LEFT),
    MIDDLE(window -> window.getGuiScaledWidth() / 2, (window, font) -> {
        int n = window.getGuiScaledHeight() / 2;
        Objects.requireNonNull(font);
        return n - 9 / 2;
    }, () -> TextAlignment.MIDDLE),
    MIDDLE_RIGHT(window -> window.getGuiScaledWidth() - 3, (window, font) -> {
        int n = window.getGuiScaledHeight() / 2;
        Objects.requireNonNull(font);
        return n - 9 / 2;
    }, () -> TextAlignment.RIGHT),
    BOTTOM_LEFT(window -> 3, (window, font) -> {
        int n = window.getGuiScaledHeight() - 3;
        Objects.requireNonNull(font);
        return n - 9;
    }, () -> TextAlignment.LEFT),
    BOTTOM_MIDDLE(window -> window.getGuiScaledWidth() / 2, (window, font) -> {
        int n = window.getGuiScaledHeight() - 3;
        Objects.requireNonNull(font);
        return n - 9;
    }, () -> TextAlignment.MIDDLE),
    BOTTOM_RIGHT(window -> window.getGuiScaledWidth() - 3, (window, font) -> {
        int n = window.getGuiScaledHeight() - 3;
        Objects.requireNonNull(font);
        return n - 9;
    }, () -> TextAlignment.RIGHT),
    ABOVE_MIDDLE(window -> window.getGuiScaledWidth() / 2, (window, font) -> window.getGuiScaledHeight() / 4, () -> TextAlignment.MIDDLE),
    ABOVE_HOTBAR(window -> window.getGuiScaledWidth() / 2, (window, font) -> window.getGuiScaledHeight() - 68, () -> TextAlignment.MIDDLE),
    LEFT_OF_CROSSHAIR(window -> window.getGuiScaledWidth() / 2 - 3 - 3, (window, font) -> {
        int n = window.getGuiScaledHeight() / 2;
        Objects.requireNonNull(font);
        return n - 9 / 2;
    }, () -> TextAlignment.RIGHT),
    RIGHT_OF_CROSSHAIR(window -> window.getGuiScaledWidth() / 2 + 3 + 3, (window, font) -> {
        int n = window.getGuiScaledHeight() / 2;
        Objects.requireNonNull(font);
        return n - 9 / 2;
    }, () -> TextAlignment.LEFT),
    ABOVE_CROSSHAIR(window -> window.getGuiScaledWidth() / 2, (window, font) -> {
        int n = window.getGuiScaledHeight() / 2 - 3 - 3;
        Objects.requireNonNull(font);
        return n - 9;
    }, () -> TextAlignment.MIDDLE),
    UNDER_CROSSHAIR_WITH_ATTACK_INDICATOR(window -> window.getGuiScaledWidth() / 2, (window, font) -> {
        int n = window.getGuiScaledHeight() / 2 + 3 + 4;
        Objects.requireNonNull(font);
        return n + 9;
    }, () -> TextAlignment.MIDDLE),
    UNDER_CROSSHAIR(window -> window.getGuiScaledWidth() / 2, (window, font) -> window.getGuiScaledHeight() / 2 + 3 + 3, () -> TextAlignment.MIDDLE);

    private ToIntFunction<Window> xGetter;
    private ToIntBiFunction<Window, Font> yGetter;
    private Supplier<TextAlignment> textAlignmentGetter;

    private PositionPreset(ToIntFunction<Window> xGetter, ToIntBiFunction<Window, Font> yGetter, Supplier<TextAlignment> textAlignmentGetter) {
        this.xGetter = xGetter;
        this.yGetter = yGetter;
        this.textAlignmentGetter = textAlignmentGetter;
    }

    public int posX(Window window) {
        return this.xGetter.applyAsInt(window);
    }

    public int posY(Window window, Font font) {
        return this.yGetter.applyAsInt(window, font);
    }

    public TextAlignment textAlignment() {
        return this.textAlignmentGetter.get();
    }
}

