/*
 * Decompiled with CFR 0.152.
 */
package net.paladins;

import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.paladins.block.PaladinBlocks;
import net.paladins.config.Default;
import net.paladins.config.TweaksConfig;
import net.paladins.content.PaladinSounds;
import net.paladins.effect.PaladinEffects;
import net.paladins.entity.PaladinEntities;
import net.paladins.item.Group;
import net.paladins.item.PaladinBooks;
import net.paladins.item.PaladinWeapons;
import net.paladins.item.Shields;
import net.paladins.item.armor.Armors;
import net.paladins.village.PaladinVillagers;
import net.spell_engine.api.config.ConfigFile;
import net.tiny_config.ConfigManager;

public class PaladinsMod {
    public static final String ID = "paladins";
    public static ConfigManager<ConfigFile.Equipment> itemConfig = new ConfigManager("equipment", (Object)Default.itemConfig).builder().setDirectory("paladins").sanitize(true).build();
    public static ConfigManager<ConfigFile.Shields> shieldConfig = new ConfigManager("shields", (Object)new ConfigFile.Shields()).builder().setDirectory("paladins").sanitize(true).build();
    public static ConfigManager<ConfigFile.Effects> effectsConfig = new ConfigManager("effects", (Object)new ConfigFile.Effects()).builder().setDirectory("paladins").sanitize(true).build();
    public static ConfigManager<StructurePoolConfig> villageConfig = new ConfigManager("villages", (Object)Default.villageConfig).builder().setDirectory("paladins").sanitize(true).build();
    public static ConfigManager<TweaksConfig> tweaksConfig = new ConfigManager("tweaks", (Object)new TweaksConfig()).builder().setDirectory("paladins").sanitize(true).build();

    public static void init() {
        itemConfig.refresh();
        shieldConfig.refresh();
        effectsConfig.refresh();
        villageConfig.refresh();
        tweaksConfig.refresh();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            ((TweaksConfig)PaladinsMod.tweaksConfig.value).ignore_items_required_mods = true;
        }
    }

    public static void registerSounds() {
        PaladinSounds.register();
    }

    public static void registerBlocks() {
        PaladinBlocks.register();
    }

    public static void registerItems() {
        Group.PALADINS = FabricItemGroup.builder().icon(() -> new ItemStack((ItemLike)Armors.paladinArmorSet_t2.head)).title((Component)Component.translatable((String)"itemGroup.paladins.general")).build();
        Registry.register((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, Group.KEY, (Object)Group.PALADINS);
        PaladinBooks.register();
        PaladinWeapons.register(((ConfigFile.Equipment)PaladinsMod.itemConfig.value).weapons);
        Shields.register(((ConfigFile.Shields)PaladinsMod.shieldConfig.value).shields);
        Armors.register(((ConfigFile.Equipment)PaladinsMod.itemConfig.value).armor_sets);
        shieldConfig.save();
        itemConfig.save();
        PaladinEntities.register();
    }

    public static void registerEffects() {
        PaladinEffects.register((ConfigFile.Effects)PaladinsMod.effectsConfig.value);
        effectsConfig.save();
    }

    public static void registerPOI() {
        PaladinVillagers.registerPOI();
    }

    public static void registerVillagers() {
        PaladinVillagers.registerVillagers();
    }
}

