/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.item;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.paladins.PaladinsMod;
import net.paladins.config.TweaksConfig;
import net.paladins.item.Group;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.WeaponConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.weapon.SpellSwordItem;
import net.spell_engine.api.item.weapon.SpellWeaponItem;
import net.spell_engine.api.item.weapon.StaffItem;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_power.api.SpellSchools;

public class PaladinWeapons {
    public static final ArrayList<Weapon.Entry> entries = new ArrayList();
    private static final String AETHER = "aether";
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";
    private static final float claymoreHealing = 0.0f;
    public static final Weapon.Entry stone_claymore = PaladinWeapons.claymore("stone_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.STONE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.COBBLESTONE})), 6.8f).loot(Equipment.LootProperties.of((int)0));
    public static final Weapon.Entry iron_claymore = PaladinWeapons.claymore("iron_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})), 8.3f).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry golden_claymore = PaladinWeapons.claymore("golden_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})), 5.2f).loot(Equipment.LootProperties.of((String)"golden_weapon"));
    public static final Weapon.Entry diamond_claymore = PaladinWeapons.claymore("diamond_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND})), 9.9f).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netherite_claymore = PaladinWeapons.claymore("netherite_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})), 11.5f).loot(Equipment.LootProperties.of((int)3));
    private static final float hammerHealing = 0.0f;
    public static final Weapon.Entry wooden_great_hammer = PaladinWeapons.hammer("wooden_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.WOOD, () -> Ingredient.of((TagKey)ItemTags.PLANKS)), 6.6f).loot(Equipment.LootProperties.of((int)0));
    public static final Weapon.Entry stone_great_hammer = PaladinWeapons.hammer("stone_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.STONE, () -> Ingredient.of((TagKey)ItemTags.STONE_TOOL_MATERIALS)), 8.5f).loot(Equipment.LootProperties.of((int)0));
    public static final Weapon.Entry iron_great_hammer = PaladinWeapons.hammer("iron_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})), 10.3f).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry golden_great_hammer = PaladinWeapons.hammer("golden_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})), 6.6f).loot(Equipment.LootProperties.of((String)"golden_weapon"));
    public static final Weapon.Entry diamond_great_hammer = PaladinWeapons.hammer("diamond_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND})), 12.2f).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netherite_great_hammer = PaladinWeapons.hammer("netherite_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})), 14.1f).loot(Equipment.LootProperties.of((int)3));
    private static final float maceHealing = 0.0f;
    public static final Weapon.Entry iron_mace = PaladinWeapons.mace("iron_mace", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})), 7.0f).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry golden_mace = PaladinWeapons.mace("golden_mace", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})), 4.3f).loot(Equipment.LootProperties.of((String)"golden_weapon"));
    public static final Weapon.Entry diamond_mace = PaladinWeapons.mace("diamond_mace", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND})), 8.3f).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netherite_mace = PaladinWeapons.mace("netherite_mace", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})), 9.6f).loot(Equipment.LootProperties.of((int)3));
    private static final float wandAttackDamage = 2.0f;
    private static final float wandAttackSpeed = -2.4f;
    public static final Weapon.Entry acolyte_wand = PaladinWeapons.wand("acolyte_wand", Weapon.CustomMaterial.matching((Tiers)Tiers.WOOD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)3.0f)).loot(Equipment.LootProperties.of((int)0));
    public static final Weapon.Entry holy_wand = PaladinWeapons.wand("holy_wand", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)3.5f)).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry diamond_holy_wand = PaladinWeapons.wand("diamond_holy_wand", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)4.0f)).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netherite_holy_wand = PaladinWeapons.wand("netherite_holy_wand", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)4.5f)).loot(Equipment.LootProperties.of((int)3));
    private static final float staffAttackDamage = 4.0f;
    private static final float staffAttackSpeed = -3.0f;
    public static final Weapon.Entry holy_staff = PaladinWeapons.staff("holy_staff", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)4.0f)).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry diamond_holy_staff = PaladinWeapons.staff("diamond_holy_staff", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)5.0f)).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netherite_holy_staff = PaladinWeapons.staff("netherite_holy_staff", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)6.0f)).loot(Equipment.LootProperties.of((int)3));

    private static Weapon.Entry entry(String name, Weapon.CustomMaterial material, Weapon.Factory factory, WeaponConfig defaults, Equipment.WeaponType type) {
        Weapon.Entry entry = new Weapon.Entry("paladins", name, material, factory, defaults, type);
        entries.add(entry);
        return entry;
    }

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = ResourceLocation.parse((String)idString);
        if (requirement) {
            return () -> Ingredient.of((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.of((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    private static Weapon.Entry claymore(String name, Weapon.CustomMaterial material, float damage) {
        return PaladinWeapons.entry(name, material, SpellSwordItem::new, new WeaponConfig(damage, -3.0f), Equipment.WeaponType.CLAYMORE);
    }

    private static Weapon.Entry hammer(String name, Weapon.CustomMaterial material, float damage) {
        return PaladinWeapons.entry(name, material, SpellWeaponItem::new, new WeaponConfig(damage, -3.2f), Equipment.WeaponType.HAMMER);
    }

    private static Weapon.Entry mace(String name, Weapon.CustomMaterial material, float damage) {
        return PaladinWeapons.entry(name, material, SpellWeaponItem::new, new WeaponConfig(damage, -2.8f), Equipment.WeaponType.MACE);
    }

    private static Weapon.Entry wand(String name, Weapon.CustomMaterial material) {
        return PaladinWeapons.entry(name, material, StaffItem::new, new WeaponConfig(2.0f, -2.4f), Equipment.WeaponType.HEALING_WAND);
    }

    private static Weapon.Entry staff(String name, Weapon.CustomMaterial material) {
        return PaladinWeapons.entry(name, material, StaffItem::new, new WeaponConfig(4.0f, -3.0f), Equipment.WeaponType.HEALING_STAFF);
    }

    public static void register(Map<String, WeaponConfig> configs) {
        Supplier<Ingredient> repair;
        if (((TweaksConfig)PaladinsMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_NETHER)) {
            repair = PaladinWeapons.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), Items.NETHERITE_INGOT);
            PaladinWeapons.staff("ruby_holy_staff", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair)).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)7.0f)).loot(Equipment.LootProperties.of((int)4));
            PaladinWeapons.claymore("ruby_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 13.0f).loot(Equipment.LootProperties.of((int)4));
            PaladinWeapons.hammer("ruby_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 16.0f).loot(Equipment.LootProperties.of((int)4));
            PaladinWeapons.mace("ruby_mace", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 11.0f).loot(Equipment.LootProperties.of((int)4));
        }
        if (((TweaksConfig)PaladinsMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_END)) {
            repair = PaladinWeapons.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded(BETTER_END), Items.NETHERITE_INGOT);
            PaladinWeapons.claymore("aeternium_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 13.0f).loot(Equipment.LootProperties.of((int)4));
            PaladinWeapons.hammer("aeternium_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 16.0f).loot(Equipment.LootProperties.of((int)4));
            PaladinWeapons.mace("aeternium_mace", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 11.0f).loot(Equipment.LootProperties.of((int)4));
        }
        if (((TweaksConfig)PaladinsMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(AETHER)) {
            repair = PaladinWeapons.ingredient("aether:ambrosium_shard", FabricLoader.getInstance().isModLoaded(AETHER), Items.NETHERITE_INGOT);
            PaladinWeapons.staff("aether_holy_staff", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair)).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)7.0f)).loot(Equipment.LootProperties.of((String)AETHER));
            PaladinWeapons.claymore("aether_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 13.0f).loot(Equipment.LootProperties.of((String)AETHER));
            PaladinWeapons.hammer("aether_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 16.0f).loot(Equipment.LootProperties.of((String)AETHER));
            PaladinWeapons.mace("aether_mace", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 11.0f).loot(Equipment.LootProperties.of((String)AETHER));
        }
        Weapon.register(configs, entries, Group.KEY);
    }
}

