/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import net.paladins.content.PaladinSpells;
import net.paladins.datagen.PaladinRecipes;
import net.paladins.item.PaladinWeapons;
import net.paladins.item.Shields;
import net.paladins.item.armor.Armors;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;

public class PaladinsDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(SpellGen::new);
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(UnsmeltGenerator::new);
        pack.addProvider(PaladinRecipes::new);
    }

    public static class UnsmeltGenerator
    extends FabricRecipeProvider {
        public static int UNSMELT_TIME = 300;

        public UnsmeltGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public void method_10419(class_8790 exporter) {
            UnsmeltGenerator.disassembleArmor(exporter, Armors.paladinArmorSet_t1, class_1802.field_8675);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.paladinArmorSet_t2, class_1802.field_8397);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.paladinArmorSet_t3, class_1802.field_22021);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.priestArmorSet_t1, class_1802.field_8675);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.priestArmorSet_t2, class_1802.field_8397);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.priestArmorSet_t3, class_1802.field_22021);
            UnsmeltGenerator.disassemble(exporter, PaladinWeapons.entries.stream().filter(entry -> entry.id().method_12832().contains("gold")).map(entry -> entry.item()).toList(), class_1802.field_8397);
            UnsmeltGenerator.disassemble(exporter, PaladinWeapons.entries.stream().filter(entry -> entry.id().method_12832().contains("iron")).map(entry -> entry.item()).toList(), class_1802.field_8675);
            UnsmeltGenerator.disassemble(exporter, PaladinWeapons.entries.stream().filter(entry -> entry.id().method_12832().contains("netherite")).map(entry -> entry.item()).toList(), class_1802.field_22021);
            UnsmeltGenerator.disassemble(exporter, List.of(PaladinWeapons.holy_staff.item(), PaladinWeapons.holy_wand.item()), class_1802.field_8397);
            UnsmeltGenerator.disassemble(exporter, List.of(Shields.iron_kite_shield.holder().item), class_1802.field_8675);
            UnsmeltGenerator.disassemble(exporter, List.of(Shields.golden_kite_shield.holder().item), class_1802.field_8397);
            UnsmeltGenerator.disassemble(exporter, List.of(Shields.netherite_kite_shield.holder().item), class_1802.field_22021);
        }

        private static void disassembleArmor(class_8790 exporter, Armor.Set armorSet, class_1792 output) {
            FabricRecipeProvider.method_36233((class_8790)exporter, (List)armorSet.pieces(), (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.method_36234((class_8790)exporter, (List)armorSet.pieces(), (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }

        private static void disassemble(class_8790 exporter, List<class_1935> items, class_1792 output) {
            FabricRecipeProvider.method_36233((class_8790)exporter, items, (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.method_36234((class_8790)exporter, items, (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.generateWeaponTags(PaladinWeapons.entries);
            this.generateArmorTags(Armors.entries.stream().filter(entry -> entry.name().contains("armor")).toList(), RPGSeriesItemTags.ArmorMetaType.MELEE);
            this.generateArmorTags(Armors.entries.stream().filter(entry -> entry.name().contains("robe")).toList(), RPGSeriesItemTags.ArmorMetaType.MAGIC);
            List<RPGSeriesDataGen.ShieldEntry> shieldEntries = Shields.ENTRIES.stream().map(entry -> new RPGSeriesDataGen.ShieldEntry(entry.id(), entry.lootProperties())).toList();
            this.generateShieldTags(shieldEntries);
        }
    }

    public static class SpellGen
    extends SpellGenerator {
        public SpellGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (PaladinSpells.Entry entry : PaladinSpells.entries) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }
}

