/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.expeditive_reloaded.items;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_437;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import org.lilbrocodes.composer_reloaded.api.targeting.Targeting;
import org.lilbrocodes.composer_reloaded.api.targeting.TargetingContext;
import org.lilbrocodes.expeditive_reloaded.ReloadedAdvancements;
import org.lilbrocodes.expeditive_reloaded.mixin.accessor.WolfEntityMethodAccessor;
import org.lilbrocodes.expeditive_reloaded.util.Misc;

public class BambooFlute
extends class_1792 {
    public BambooFlute() {
        super((class_1792.class_1793)new FabricItemSettings().maxCount(1));
    }

    public void playSound(class_1937 world, class_1297 entity, class_3414 soundEvent, float p) {
        world.method_43129((class_1657)entity, entity, soundEvent, class_3419.field_15248, 10.0f, p);
        world.method_32888(class_5712.field_39415, entity.method_19538(), class_5712.class_7397.method_43285((class_1297)entity));
    }

    private int mapAngle(float pitch) {
        int actionIndex;
        if ((pitch = Math.max(-90.0f, Math.min(90.0f, pitch)) * -1.0f) >= 80.0f) {
            actionIndex = 16;
        } else if (pitch <= -80.0f) {
            actionIndex = 1;
        } else {
            float normalizedPitch = (pitch + 80.0f) / 160.0f;
            actionIndex = 2 + Math.round(normalizedPitch * 14.0f);
        }
        return actionIndex;
    }

    private float getPitchFromSeg(int segment) {
        segment = Math.max(1, Math.min(16, segment));
        return 0.5f + (float)(segment - 1) * 0.1f;
    }

    public int method_7881(class_1799 stack) {
        return 200;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_39058;
    }

    public static List<class_1493> getPlayerOwnedWolves(class_1937 world, class_1657 player) {
        ArrayList<class_1493> ownedWolves = new ArrayList<class_1493>();
        class_238 worldBox = new class_238(player.method_24515()).method_1014(1024.0);
        for (class_1493 wolf : world.method_8390(class_1493.class, worldBox, class_1309::method_5805)) {
            UUID wolfOwnerUuid;
            if (!wolf.method_6181() || (wolfOwnerUuid = wolf.method_6139()) == null || !wolfOwnerUuid.equals(player.method_5667())) continue;
            ownedWolves.add(wolf);
        }
        return ownedWolves;
    }

    private static List<class_1493> getPlayerOwnedWolves(class_1937 world, class_1657 player, class_1767 color) {
        List<class_1493> ownedWolves = BambooFlute.getPlayerOwnedWolves(world, player);
        ownedWolves.removeIf(wolf -> wolf.method_6713() != color);
        return ownedWolves;
    }

    public static void setDyed(class_1799 stack, @Nullable class_1767 color) {
        class_2487 nbt = stack.method_7948();
        if (color != null) {
            nbt.method_10582("color", color.method_7792());
        }
    }

    @Nullable
    public static class_1767 getColor(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null && nbt.method_10573("color", 8)) {
            return class_1767.method_7793((String)nbt.method_10558("color"), null);
        }
        return null;
    }

    public void executePlayedAction(class_1657 player, int segment, class_1799 stack) {
        block11: {
            class_1493 wolf;
            double distance;
            class_1297 target;
            List<class_1493> wolvesToCommand;
            block13: {
                block14: {
                    block12: {
                        block10: {
                            wolvesToCommand = BambooFlute.getColor(stack) != null ? BambooFlute.getPlayerOwnedWolves(player.method_37908(), player, BambooFlute.getColor(stack)) : BambooFlute.getPlayerOwnedWolves(player.method_37908(), player);
                            if (segment != 1) break block10;
                            for (class_1493 wolf2 : wolvesToCommand) {
                                if (wolf2.method_5934()) continue;
                                this.sendWolfTo(wolf2, (class_1297)player, 1.0f, false);
                            }
                            break block11;
                        }
                        if (segment != 16) break block12;
                        for (class_1493 wolf3 : wolvesToCommand) {
                            wolf3.method_24346(!wolf3.method_24345());
                            wolf3.method_6179(wolf3.method_24345());
                        }
                        break block11;
                    }
                    target = Targeting.getTargetedEntity((class_1657)player, (TargetingContext)Misc.PACIFIST_SETTINGS.build(player));
                    if (target == null) {
                        return;
                    }
                    distance = Misc.distanceTo2D((class_1297)player, target);
                    if (target instanceof class_1309) break block13;
                    if (!(target instanceof class_1690)) break block14;
                    for (class_1493 wolf4 : wolvesToCommand) {
                        if (!(wolf4 instanceof WolfEntityMethodAccessor)) continue;
                        WolfEntityMethodAccessor accessor = (WolfEntityMethodAccessor)wolf4;
                        accessor.expeditiveReloaded$setTargetIsBoat(true);
                        accessor.expeditiveReloaded$setBoatTarget((class_1690)target);
                        this.sendWolfTo(wolf4, target, 1.0f, false);
                    }
                    break block11;
                }
                if (!(target instanceof class_1531)) break block11;
                for (class_1493 wolf5 : wolvesToCommand) {
                    if (!(wolf5 instanceof WolfEntityMethodAccessor)) continue;
                    WolfEntityMethodAccessor accessor = (WolfEntityMethodAccessor)wolf5;
                    accessor.expeditiveReloaded$setTargetIsArmorStand(true);
                    accessor.expeditiveReloaded$setArmorStandTarget((class_1531)target);
                    this.sendWolfTo(wolf5, target, 1.0f, false);
                }
                break block11;
            }
            if (target instanceof class_1493 && wolvesToCommand.contains(wolf = (class_1493)target) && distance <= 64.0) {
                wolf.method_24346(!wolf.method_24345());
                wolf.method_6179(wolf.method_24345());
            } else if (distance <= 64.0) {
                if (target instanceof class_1493 && ((class_1493)target).method_6139() == player.method_5667()) {
                    return;
                }
                for (class_1493 wolf6 : wolvesToCommand) {
                    if (wolf6.method_24345() || wolf6.method_5934()) continue;
                    this.sendWolfTo(wolf6, target, 1.0f, true);
                }
            }
        }
    }

    public void sendWolfTo(class_1493 wolf, class_1297 target, float speed, boolean attack) {
        wolf.method_5942().method_6340();
        wolf.method_5980(null);
        wolf.method_29514(0);
        if (wolf.method_24345()) {
            wolf.method_24346(false);
            wolf.method_6179(false);
        }
        if (!attack) {
            wolf.method_5942().method_6335(target, (double)speed);
        } else {
            wolf.method_5980((class_1309)target);
            wolf.method_29513(target.method_5667());
            wolf.method_29514(-1);
            wolf.method_19540(true);
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        user.method_6019(hand);
        user.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
        int seg = this.mapAngle(user.method_36455());
        float pitch = this.getPitchFromSeg(seg);
        if (!world.field_9236) {
            this.executePlayedAction(user, seg, itemStack);
            if (user instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)user;
                ReloadedAdvancements.Criterion.PLAYED_FLUTE.trigger(serverPlayer, BambooFlute.getColor(itemStack));
            }
        }
        this.playSound(world, (class_1297)user, (class_3414)class_3417.field_14989.comp_349(), pitch);
        return class_1271.method_22428((Object)itemStack);
    }

    public class_1799 method_7854() {
        class_1799 stack = super.method_7854();
        BambooFlute.setDyed(stack, null);
        return stack;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        class_1767 color = BambooFlute.getColor(stack);
        if (color != null) {
            tooltip.add((class_2561)class_2561.method_43469((String)"expeditive_reloaded.bamboo_flute.tooltip_color", (Object[])new Object[]{Misc.getColoredDyeColorName(color)}).method_27692(class_124.field_1080));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"expeditive_reloaded.bamboo_flute.tooltip_all").method_27692(class_124.field_1080));
        }
        class_310 client = class_310.method_1551();
        if (class_437.method_25442()) {
            this.appendTutorial(tooltip);
        } else {
            tooltip.add((class_2561)class_2561.method_43469((String)"expeditive_reloaded.bamboo_flute.tutorial.show", (Object[])new Object[]{class_2561.method_43471((String)client.field_1690.field_1832.method_1429().method_1441())}).method_27692(class_124.field_1080));
        }
    }

    private void appendTutorial(List<class_2561> tooltip) {
        tooltip.add((class_2561)class_2561.method_43471((String)"expeditive_reloaded.bamboo_flute.tutorial.header").method_27692(class_124.field_1065));
        tooltip.add((class_2561)class_2561.method_43471((String)"expeditive_reloaded.bamboo_flute.tutorial.note_pitch").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"expeditive_reloaded.bamboo_flute.tutorial.look_down").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"expeditive_reloaded.bamboo_flute.tutorial.look_up").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"expeditive_reloaded.bamboo_flute.tutorial.look_at_controlled_wolf").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"expeditive_reloaded.bamboo_flute.tutorial.look_at_other").method_27692(class_124.field_1080));
    }

    public class_2561 method_7864(class_1799 stack) {
        class_1767 color = BambooFlute.getColor(stack);
        if (color != null) {
            return Misc.prependDyeColor(this.method_7848(), color);
        }
        return super.method_7864(stack);
    }
}

