/*
 * Decompiled with CFR 0.152.
 */
package org.lilbrocodes.expeditive_reloaded.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7710;
import org.lilbrocodes.expeditive_reloaded.recipe.DyableShapedRecipe;

public class DyableShapedRecipeSerializer
implements class_1865<DyableShapedRecipe> {
    static class_2371<class_1856> createPatternMatrix(String[] pattern, Map<String, class_1856> symbols, int width, int height) {
        class_2371 defaultedList = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
        HashSet set = Sets.newHashSet(symbols.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                class_1856 ingredient = symbols.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                defaultedList.set(j + width * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + String.valueOf(set));
        }
        return defaultedList;
    }

    @VisibleForTesting
    static String[] removePadding(String ... pattern) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < pattern.length; ++m) {
            String string = pattern[m];
            i = Math.min(i, DyableShapedRecipeSerializer.findFirstSymbol(string));
            int n = DyableShapedRecipeSerializer.findLastSymbol(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (pattern.length == l) {
            return new String[0];
        }
        String[] strings = new String[pattern.length - l - k];
        for (int o = 0; o < strings.length; ++o) {
            strings[o] = pattern[o + k].substring(i, j + 1);
        }
        return strings;
    }

    private static int findFirstSymbol(String line) {
        int i;
        for (i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int findLastSymbol(String pattern) {
        int i;
        for (i = pattern.length() - 1; i >= 0 && pattern.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] getPattern(JsonArray json) {
        String[] strings = new String[json.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = class_3518.method_15287((JsonElement)json.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    static Map<String, class_1856> readSymbols(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), class_1856.method_8102((JsonElement)((JsonElement)entry.getValue()), (boolean)false));
        }
        map.put(" ", class_1856.field_9017);
        return map;
    }

    public DyableShapedRecipe read(class_2960 id, JsonObject json) {
        String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
        class_7710 category = (class_7710)class_7710.field_40252.method_47920(class_3518.method_15253((JsonObject)json, (String)"category", (String)"misc"), (Enum)class_7710.field_40251);
        Map<String, class_1856> key = DyableShapedRecipeSerializer.readSymbols(class_3518.method_15296((JsonObject)json, (String)"key"));
        String[] pattern = DyableShapedRecipeSerializer.removePadding(DyableShapedRecipeSerializer.getPattern(class_3518.method_15261((JsonObject)json, (String)"pattern")));
        int width = pattern[0].length();
        int height = pattern.length;
        class_2371<class_1856> inputs = DyableShapedRecipeSerializer.createPatternMatrix(pattern, key, width, height);
        class_1799 output = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
        return new DyableShapedRecipe(id, group, category, width, height, inputs, output);
    }

    public DyableShapedRecipe read(class_2960 id, class_2540 buf) {
        String group = buf.method_19772();
        class_7710 category = (class_7710)buf.method_10818(class_7710.class);
        int width = buf.method_10816();
        int height = buf.method_10816();
        class_2371 inputs = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
        inputs.replaceAll(ignored -> class_1856.method_8086((class_2540)buf));
        class_1799 output = buf.method_10819();
        return new DyableShapedRecipe(id, group, category, width, height, (class_2371<class_1856>)inputs, output);
    }

    public void write(class_2540 buf, DyableShapedRecipe recipe) {
        buf.method_10814(recipe.group);
        buf.method_10817((Enum)recipe.category);
        buf.method_10804(recipe.width);
        buf.method_10804(recipe.height);
        for (class_1856 ingredient : recipe.ingredients) {
            ingredient.method_8088(buf);
        }
        buf.method_10793(recipe.output);
    }
}

